/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.controls;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.suggestion.controls.BalloonBasedControl;
import com.android.studio.ml.suggestion.controls.CodeSnippetLabel;
import com.android.studio.ml.suggestion.controls.ControlUtilKt;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.android.studio.ml.suggestion.controls.StickyLinesAwareVisibleAreaKt;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplaySnippet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import icons.SmlIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0014J\b\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001dH\u0014R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/studio/ml/suggestion/controls/ReplacementWithinSingleLineControl;", "Lcom/android/studio/ml/suggestion/controls/BalloonBasedControl;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "newTextSnippets", "", "Lcom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplaySnippet;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/RangeMarker;Ljava/util/List;)V", "estimatedNewTextWidth", "", "getEstimatedNewTextWidth", "()I", "estimatedNewTextWidth$delegate", "Lkotlin/Lazy;", "calculateBalloonPosition", "Lcom/intellij/ui/awt/RelativePoint;", "content", "Ljavax/swing/JComponent;", "createBalloonContent", "getLeftPadding", "getSizeForIsVisible", "Ljava/awt/Dimension;", "isVisible", "", "configure", "Lcom/intellij/openapi/ui/popup/BalloonBuilder;", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class ReplacementWithinSingleLineControl
extends BalloonBasedControl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RangeMarker rangeMarker;
    @NotNull
    private final List<CodeDisplaySnippet> newTextSnippets;
    @NotNull
    private final Lazy estimatedNewTextWidth$delegate;
    public static final int $stable = 8;
    @NotNull
    private static final TextAttributesKey deletedTextBackgroundKey;
    @NotNull
    private static final TextAttributesKey insertedTextBackgroundKey;
    @NotNull
    private static final TextAttributesKey popupBorderKey;

    private ReplacementWithinSingleLineControl(Project project2, Editor editor2, RangeMarker rangeMarker, List<CodeDisplaySnippet> newTextSnippets) {
        super(project2, editor2, CollectionsKt.listOf((Object)rangeMarker), null);
        this.rangeMarker = rangeMarker;
        this.newTextSnippets = newTextSnippets;
        this.estimatedNewTextWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ReplacementWithinSingleLineControl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Integer invoke() {
                int n;
                Iterable iterable = ReplacementWithinSingleLineControl.access$getNewTextSnippets$p(this.this$0);
                int n2 = this.this$0.estimateCharacterWidth();
                int n3 = 0;
                for (T t : iterable) {
                    void it;
                    CodeDisplaySnippet codeDisplaySnippet = (CodeDisplaySnippet)t;
                    n = n3;
                    boolean bl = false;
                    int n4 = it.getText().length();
                    n3 = n + n4;
                }
                n = n3;
                return n2 * n;
            }
        }));
    }

    @Override
    @NotNull
    protected BalloonBuilder configure(@NotNull BalloonBuilder $this$configure) {
        Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"<this>");
        $this$configure.setFillColor(ControlUtilKt.getTRANSPARENT());
        $this$configure.setShowCallout(false);
        $this$configure.setBorderInsets((Insets)JBUI.insets((int)1));
        $this$configure.setBorderColor(popupBorderKey.getDefaultAttributes().getForegroundColor());
        $this$configure.setShadow(false);
        return $this$configure;
    }

    private final int getEstimatedNewTextWidth() {
        Lazy lazy = this.estimatedNewTextWidth$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected JComponent createBalloonContent() {
        void $this$createBalloonContent_u24lambda_u240_u241;
        void $this$createBalloonContent_u24lambda_u240_u240_u240;
        JPanel $this$createBalloonContent_u24lambda_u240_u240;
        JPanel jPanel;
        JPanel jPanel2;
        TextRange textRange = this.rangeMarker.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        TextRange deletedRange = textRange;
        Point point = this.getEditor().offsetToXY(deletedRange.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point startPoint = point;
        Point point2 = this.getEditor().offsetToXY(deletedRange.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
        Point endPoint = point2;
        int deletedWidth = endPoint.x - startPoint.x;
        int leftPadding = this.getLeftPadding();
        JPanel $this$createBalloonContent_u24lambda_u240 = jPanel2 = new JPanel();
        boolean bl = false;
        $this$createBalloonContent_u24lambda_u240.setOpaque(false);
        $this$createBalloonContent_u24lambda_u240.setLayout(new BoxLayout($this$createBalloonContent_u24lambda_u240, 1));
        JPanel jPanel3 = jPanel = new JPanel();
        JPanel jPanel4 = $this$createBalloonContent_u24lambda_u240;
        boolean bl2 = false;
        $this$createBalloonContent_u24lambda_u240_u240.setOpaque(false);
        $this$createBalloonContent_u24lambda_u240_u240.setLayout(new BoxLayout($this$createBalloonContent_u24lambda_u240_u240, 0));
        $this$createBalloonContent_u24lambda_u240_u240.add(Box.createHorizontalStrut(leftPadding));
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = jPanel5;
        void var15_15 = $this$createBalloonContent_u24lambda_u240_u240;
        boolean bl3 = false;
        $this$createBalloonContent_u24lambda_u240_u240_u240.setPreferredSize(new Dimension(deletedWidth, this.getEditor().getLineHeight()));
        $this$createBalloonContent_u24lambda_u240_u240_u240.setMinimumSize($this$createBalloonContent_u24lambda_u240_u240_u240.getPreferredSize());
        $this$createBalloonContent_u24lambda_u240_u240_u240.setMaximumSize($this$createBalloonContent_u24lambda_u240_u240_u240.getPreferredSize());
        $this$createBalloonContent_u24lambda_u240_u240_u240.setBackground(deletedTextBackgroundKey.getDefaultAttributes().getBackgroundColor());
        $this$createBalloonContent_u24lambda_u240_u240_u240.setCursor(new Cursor(2));
        var15_15.add(jPanel5);
        $this$createBalloonContent_u24lambda_u240_u240.add(Box.createHorizontalGlue());
        jPanel4.add(jPanel);
        $this$createBalloonContent_u24lambda_u240_u240 = jPanel = new JPanel();
        jPanel4 = $this$createBalloonContent_u24lambda_u240;
        boolean bl4 = false;
        $this$createBalloonContent_u24lambda_u240_u241.setLayout(new BoxLayout((Container)$this$createBalloonContent_u24lambda_u240_u241, 0));
        $this$createBalloonContent_u24lambda_u240_u241.add(Box.createHorizontalStrut(leftPadding));
        $this$createBalloonContent_u24lambda_u240_u241.add((Component)new JBLabel(SmlIcons.DownRightArrow));
        for (CodeDisplaySnippet snippet : this.newTextSnippets) {
            $this$createBalloonContent_u24lambda_u240_u241.add((Component)((Object)new CodeSnippetLabel(snippet, insertedTextBackgroundKey, this.getEditor())));
        }
        $this$createBalloonContent_u24lambda_u240_u241.add(Box.createHorizontalGlue());
        jPanel4.add(jPanel);
        return jPanel2;
    }

    private final int getLeftPadding() {
        int textStartOffset = this.rangeMarker.getTextRange().getStartOffset();
        Point point = this.getEditor().offsetToXY(textStartOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point firstCharPoint = point;
        Point point2 = this.getEditor().offsetToXY(RangesKt.coerceAtLeast((int)(textStartOffset - 1), (int)0));
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
        Point prevCharPoint = point2;
        if (prevCharPoint.y == firstCharPoint.y) {
            return firstCharPoint.x - prevCharPoint.x;
        }
        return 0;
    }

    @Override
    @NotNull
    protected RelativePoint calculateBalloonPosition(@NotNull JComponent content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Point point = this.getEditor().offsetToXY(this.rangeMarker.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point upperLeftTextPoint = point;
        Point upperLeftPoint = new Point(upperLeftTextPoint.x - this.getLeftPadding(), upperLeftTextPoint.y);
        Point displayPoint = new Point(upperLeftPoint.x + content2.getWidth() / 2, upperLeftPoint.y + content2.getHeight() / 2);
        return new RelativePoint((Component)this.getEditor().getContentComponent(), displayPoint);
    }

    @Override
    public boolean isVisible() {
        Point point = this.getEditor().offsetToXY(this.rangeMarker.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point topLeftPoint = point;
        Dimension size = this.getSizeForIsVisible();
        Point bottomRightPoint = new Point(topLeftPoint.x + size.width, topLeftPoint.y + size.height);
        Rectangle visibleArea = StickyLinesAwareVisibleAreaKt.visibleAreaWithoutStickyLines(this.getEditor());
        return visibleArea.contains(topLeftPoint) && visibleArea.contains(bottomRightPoint);
    }

    private final Dimension getSizeForIsVisible() {
        Dimension dimension = this.getContentSize();
        if (dimension != null) {
            Dimension it = dimension;
            boolean bl = false;
            return it;
        }
        int iconWidth = JBUIScale.scale((int)16);
        int newTextWidth = iconWidth + this.getLeftPadding() + this.getEstimatedNewTextWidth();
        int oldTextWidth = this.getEditor().offsetToXY((int)this.rangeMarker.getEndOffset()).x - this.getEditor().offsetToXY((int)this.rangeMarker.getStartOffset()).x;
        int width = Math.max(newTextWidth, oldTextWidth);
        int height = this.getEditor().getLineHeight() * 2;
        return new Dimension(width, height);
    }

    public /* synthetic */ ReplacementWithinSingleLineControl(Project project2, Editor editor2, RangeMarker rangeMarker, List newTextSnippets, DefaultConstructorMarker $constructor_marker) {
        this(project2, editor2, rangeMarker, newTextSnippets);
    }

    public static final /* synthetic */ List access$getNewTextSnippets$p(ReplacementWithinSingleLineControl $this) {
        return $this.newTextSnippets;
    }

    static {
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"EDITOR_SUGGESTION_DELETED_OVERLAY_COLOR");
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createTextAttributesKey(...)");
        deletedTextBackgroundKey = textAttributesKey;
        TextAttributesKey textAttributesKey2 = TextAttributesKey.createTextAttributesKey((String)"EDITOR_SUGGESTION_INSERTED_TEXT");
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"createTextAttributesKey(...)");
        insertedTextBackgroundKey = textAttributesKey2;
        TextAttributesKey textAttributesKey3 = TextAttributesKey.createTextAttributesKey((String)"EDITOR_SUGGESTION_POPUP_BORDER");
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"createTextAttributesKey(...)");
        popupBorderKey = textAttributesKey3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/suggestion/controls/ReplacementWithinSingleLineControl$Companion;", "", "()V", "deletedTextBackgroundKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "insertedTextBackgroundKey", "popupBorderKey", "create", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "newTextSnippets", "", "Lcom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplaySnippet;", "create$aiplugin_core_aicore", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorSuggestionControl create$aiplugin_core_aicore(@NotNull RangeMarker rangeMarker, @NotNull Project project2, @NotNull Editor editor2, @NotNull List<CodeDisplaySnippet> newTextSnippets) {
            Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(newTextSnippets, (String)"newTextSnippets");
            return new ReplacementWithinSingleLineControl(project2, editor2, rangeMarker, newTextSnippets, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

