/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.controls;

import com.android.studio.ml.suggestion.AnchoredDiffChunk;
import com.android.studio.ml.suggestion.controls.AggregateEditorSuggestionControl;
import com.android.studio.ml.suggestion.controls.BlockReplacementSuggestionControl;
import com.android.studio.ml.suggestion.controls.DeletionWithinSingleLineControl;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControlFactory;
import com.android.studio.ml.suggestion.controls.InlineReplacementSuggestionControl;
import com.android.studio.ml.suggestion.controls.InsertionInSingleLineControl;
import com.android.studio.ml.suggestion.controls.ReplacementWithinSingleLineControl;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplayKt;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplayRow;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplaySnippet;
import com.android.studio.ml.suggestion.controls.viewmodel.DiffStyle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J4\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\bH\u0016J&\u0010\u0015\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\bH\u0016J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControlFactoryImpl;", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControlFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createAggregate", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl;", "childSuggestions", "", "createBlockReplacement", "chunk", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "editor", "Lcom/intellij/openapi/editor/Editor;", "originalRows", "Lcom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplayRow;", "newRows", "createDeletionWithinSingleLine", "createInlineReplacement", "snippets", "Lcom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplaySnippet;", "createInsertionWithinSingleLine", "newSnippets", "createReplacementWithinSingleLine", "safeVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "aiplugin.core.aicore"})
@SourceDebugExtension(value={"SMAP\nEditorSuggestionControlFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSuggestionControlFactory.kt\ncom/android/studio/ml/suggestion/controls/EditorSuggestionControlFactoryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n774#2:176\n865#2,2:177\n*S KotlinDebug\n*F\n+ 1 EditorSuggestionControlFactory.kt\ncom/android/studio/ml/suggestion/controls/EditorSuggestionControlFactoryImpl\n*L\n163#1:176\n163#1:177,2\n*E\n"})
final class EditorSuggestionControlFactoryImpl
implements EditorSuggestionControlFactory {
    @NotNull
    private final Project project;

    private EditorSuggestionControlFactoryImpl(Project project2) {
        this.project = project2;
    }

    @Override
    @Nullable
    public EditorSuggestionControl createInlineReplacement(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!(!StringsKt.contains$default((CharSequence)chunk.getOriginalContent(), (char)'\n', (boolean)false, (int)2, null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)chunk.getNewContent(), (char)'\n', (boolean)false, (int)2, null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.createInlineReplacement(chunk, editor2, CodeDisplayKt.createHighlightedSnippetsForSingleLineChunk(chunk, this.project, this.safeVirtualFile(editor2)));
    }

    @Override
    @Nullable
    public EditorSuggestionControl createInlineReplacement(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor2, @NotNull List<CodeDisplaySnippet> snippets) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(snippets, (String)"snippets");
        return InlineReplacementSuggestionControl.Companion.create$aiplugin_core_aicore(snippets, chunk, this.project, editor2);
    }

    @Override
    @NotNull
    public EditorSuggestionControl createBlockReplacement(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return this.createBlockReplacement(chunk, editor2, StringsKt.isBlank((CharSequence)chunk.getOriginalContent()) && !StringsKt.isBlank((CharSequence)chunk.getNewContent()) ? CollectionsKt.emptyList() : CodeDisplayKt.createHighlightedRowsOriginalLines(chunk, this.project, this.safeVirtualFile(editor2)), CodeDisplayKt.createHighlightedRowsNewLines(chunk, this.project, this.safeVirtualFile(editor2)));
    }

    @Override
    @NotNull
    public EditorSuggestionControl createBlockReplacement(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor2, @NotNull List<CodeDisplayRow> originalRows, @NotNull List<CodeDisplayRow> newRows) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(originalRows, (String)"originalRows");
        Intrinsics.checkNotNullParameter(newRows, (String)"newRows");
        return BlockReplacementSuggestionControl.Companion.create$aiplugin_core_aicore(originalRows, newRows, chunk, this.project, editor2, true);
    }

    @Override
    @NotNull
    public EditorSuggestionControl createInsertionWithinSingleLine(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor2, @NotNull List<CodeDisplaySnippet> newSnippets) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(newSnippets, (String)"newSnippets");
        return new InsertionInSingleLineControl(this.project, editor2, chunk.getRangeMarker(), newSnippets);
    }

    @Override
    @NotNull
    public EditorSuggestionControl createAggregate(@NotNull List<? extends EditorSuggestionControl> childSuggestions) {
        Intrinsics.checkNotNullParameter(childSuggestions, (String)"childSuggestions");
        return new AggregateEditorSuggestionControl(this.project, childSuggestions);
    }

    @Override
    @NotNull
    public EditorSuggestionControl createDeletionWithinSingleLine(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return DeletionWithinSingleLineControl.Companion.create$aiplugin_core_aicore(chunk.getRangeMarker(), this.project, editor2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EditorSuggestionControl createReplacementWithinSingleLine(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        List<CodeDisplaySnippet> snippets = CodeDisplayKt.createHighlightedSnippetsForSingleLineChunk(chunk, this.project, this.safeVirtualFile(editor2));
        Iterable $this$filter$iv = snippets;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CodeDisplaySnippet it = (CodeDisplaySnippet)element$iv$iv;
            boolean bl = false;
            if (!(it.getDiffStyle() == DiffStyle.New)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newTextSnippets = (List)destination$iv$iv;
        return ReplacementWithinSingleLineControl.Companion.create$aiplugin_core_aicore(chunk.getRangeMarker(), this.project, editor2, newTextSnippets);
    }

    private final VirtualFile safeVirtualFile(Editor $this$safeVirtualFile) {
        VirtualFile virtualFile2 = $this$safeVirtualFile.getVirtualFile();
        if (virtualFile2 == null) {
            virtualFile2 = FileDocumentManager.getInstance().getFile($this$safeVirtualFile.getDocument());
        }
        if (virtualFile2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return virtualFile2;
    }
}

