/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.controls;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.suggestion.controls.CodeFolder;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.android.studio.ml.suggestion.controls.HintKind;
import com.android.studio.ml.suggestion.controls.StickyLinesAwareVisibleAreaKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00152\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010\tH\u0004J\b\u0010-\u001a\u00020.H$J\b\u0010/\u001a\u000200H&J\r\u00101\u001a\u000702\u00a2\u0006\u0002\b\u0017H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\b\u00105\u001a\u00020.H\u0017J\u0006\u00106\u001a\u00020.J\b\u00107\u001a\u00020$H\u0016J\u0010\u00108\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0015H\u0016J\u0006\u00109\u001a\u00020.J\u0015\u0010:\u001a\u00020.*\u0002042\u0006\u0010;\u001a\u00020\nH\u0083\u0002R\u0016\u0010\r\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0013\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u0014\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\u00158DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControlBase;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rangeMarkers", "", "Lcom/intellij/openapi/editor/RangeMarker;", "hintText", "", "descriptionText", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getDescriptionText", "()Ljava/lang/String;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "hasBeenShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getHintText", "listeners", "getListeners", "()Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl$Listener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRangeMarkers", "()Ljava/util/List;", "resolved", "accept", "", "addListener", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "caretOffsetForMove", "", "doFold", "Lcom/intellij/openapi/util/TextRange;", "doShow", "", "getHintKind", "Lcom/android/studio/ml/suggestion/controls/HintKind;", "getLogicalPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "getVisualBoundsInEditorComponent", "Ljava/awt/Rectangle;", "isVisible", "movesCodeOnShow", "reject", "removeListener", "show", "contains", "rangeMarker", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEditorSuggestionControlBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSuggestionControlBase.kt\ncom/android/studio/ml/suggestion/controls/EditorSuggestionControlBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1563#2:122\n1634#2,3:123\n1869#2,2:127\n1761#2,3:129\n1#3:126\n*S KotlinDebug\n*F\n+ 1 EditorSuggestionControlBase.kt\ncom/android/studio/ml/suggestion/controls/EditorSuggestionControlBase\n*L\n55#1:122\n55#1:123,3\n93#1:127,2\n101#1:129,3\n*E\n"})
public abstract class EditorSuggestionControlBase
extends UserDataHolderBase
implements EditorSuggestionControl,
Disposable.Default {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final List<RangeMarker> rangeMarkers;
    @Nullable
    private final String hintText;
    @Nullable
    private final String descriptionText;
    @NotNull
    private final AtomicBoolean resolved;
    @NotNull
    private final AtomicBoolean hasBeenShown;
    @NotNull
    private final EventDispatcher<EditorSuggestionControl.Listener> eventDispatcher;
    public static final int $stable = 8;

    public EditorSuggestionControlBase(@NotNull Project project2, @NotNull Editor editor2, @NotNull List<? extends RangeMarker> rangeMarkers, @Nullable String hintText, @Nullable String descriptionText) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(rangeMarkers, (String)"rangeMarkers");
        this.project = project2;
        this.editor = editor2;
        this.rangeMarkers = rangeMarkers;
        this.hintText = hintText;
        this.descriptionText = descriptionText;
        this.resolved = new AtomicBoolean();
        this.hasBeenShown = new AtomicBoolean();
        EventDispatcher eventDispatcher = EventDispatcher.create(EditorSuggestionControl.Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
    }

    public /* synthetic */ EditorSuggestionControlBase(Project project2, Editor editor2, List list, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        this(project2, editor2, list, string, string2);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        return this.editor;
    }

    @Override
    @NotNull
    public List<RangeMarker> getRangeMarkers() {
        return this.rangeMarkers;
    }

    @Override
    @Nullable
    public String getHintText() {
        return this.hintText;
    }

    @Override
    @Nullable
    public String getDescriptionText() {
        return this.descriptionText;
    }

    @NotNull
    protected final EditorSuggestionControl.Listener getListeners() {
        EventListener eventListener = this.eventDispatcher.getMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)eventListener, (String)"getMulticaster(...)");
        return (EditorSuggestionControl.Listener)eventListener;
    }

    @Override
    @RequiresEdt
    public boolean isVisible() {
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ EditorSuggestionControlBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke() {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    Rectangle visibleArea = StickyLinesAwareVisibleAreaKt.visibleAreaWithoutStickyLines(this.this$0.getEditor());
                    Iterable iterable = this.this$0.getRangeMarkers();
                    EditorSuggestionControlBase editorSuggestionControlBase = this.this$0;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            RangeMarker it = (RangeMarker)element$iv;
                            boolean bl2 = false;
                            if (!EditorSuggestionControlBase.access$contains(editorSuggestionControlBase, visibleArea, it)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final List<TextRange> doFold() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getRangeMarkers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            RangeMarker rangeMarker = (RangeMarker)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getTextRange());
        }
        List hiddenTextRanges = (List)destination$iv$iv;
        for (TextRange hiddenTextRange : hiddenTextRanges) {
            CodeFolder folder;
            if (hiddenTextRange.isEmpty()) continue;
            Editor editor2 = this.getEditor();
            Intrinsics.checkNotNull((Object)hiddenTextRange);
            if (CodeFolder.Companion.create(this.project, editor2, hiddenTextRange) == null) {
                return null;
            }
            Disposer.register((Disposable)this, (Disposable)folder);
        }
        return hiddenTextRanges;
    }

    @Override
    public void addListener(@NotNull EditorSuggestionControl.Listener listener2, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (parentDisposable == null) {
            this.eventDispatcher.addListener((EventListener)listener2);
        } else {
            this.eventDispatcher.addListener((EventListener)listener2, parentDisposable);
        }
    }

    @Override
    public void removeListener(@NotNull EditorSuggestionControl.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.eventDispatcher.removeListener((EventListener)listener2);
    }

    @Override
    public void accept() {
        if (this.resolved.compareAndSet(false, true)) {
            this.getListeners().onAccept();
        }
    }

    @Override
    public void reject() {
        if (this.resolved.compareAndSet(false, true)) {
            this.getListeners().onReject();
        }
    }

    @Override
    @Nullable
    public Rectangle getVisualBoundsInEditorComponent() {
        return null;
    }

    @Override
    @NotNull
    public LogicalPosition getLogicalPosition() {
        Iterable iterable = this.getRangeMarkers();
        Editor editor2 = this.getEditor();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        RangeMarker it = (RangeMarker)iterator.next();
        boolean bl = false;
        int n = it.getTextRange().getStartOffset();
        while (iterator.hasNext()) {
            RangeMarker it2 = (RangeMarker)iterator.next();
            $i$a$-minOf-EditorSuggestionControlBase$getLogicalPosition$1 = false;
            int n2 = it2.getTextRange().getStartOffset();
            if (n <= n2) continue;
            n = n2;
        }
        int n3 = n;
        LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(n3);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        return logicalPosition;
    }

    @Override
    public final boolean show() {
        if (!this.hasBeenShown.compareAndSet(false, true)) {
            return true;
        }
        Iterable $this$forEach$iv = this.getRangeMarkers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeMarker it = (RangeMarker)element$iv;
            boolean bl = false;
            Editor editor2 = this.getEditor();
            TextRange textRange = it.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            CodeFolder.Companion.ensureExpanded(editor2, textRange);
        }
        return this.doShow();
    }

    @Override
    @NotNull
    public abstract HintKind getHintKind();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean movesCodeOnShow() {
        TextRange textRange;
        Editor editor2;
        if (this.insertsInlaysInEditor()) return true;
        Iterable $this$any$iv = this.getRangeMarkers();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            RangeMarker it = (RangeMarker)element$iv;
            boolean bl = false;
            editor2 = this.getEditor();
            textRange = it.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        } while (!CodeFolder.Companion.isInFoldedRegion(editor2, textRange));
        return true;
    }

    protected abstract boolean doShow();

    @Override
    public int caretOffsetForMove() {
        Iterator iterator = ((Iterable)this.getRangeMarkers()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        RangeMarker it = (RangeMarker)iterator.next();
        boolean bl = false;
        int n = it.getStartOffset();
        while (iterator.hasNext()) {
            RangeMarker it2 = (RangeMarker)iterator.next();
            $i$a$-minOf-EditorSuggestionControlBase$caretOffsetForMove$1 = false;
            int n2 = it2.getStartOffset();
            if (n <= n2) continue;
            n = n2;
        }
        return n;
    }

    @RequiresEdt
    private final boolean contains(Rectangle $this$contains, RangeMarker rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        return this.getEditor().offsetToXY((int)rangeMarker.getEndOffset()).y >= $this$contains.y && this.getEditor().offsetToXY((int)rangeMarker.getStartOffset()).y <= $this$contains.y + $this$contains.height;
    }

    public static final /* synthetic */ boolean access$contains(EditorSuggestionControlBase $this, Rectangle $receiver, RangeMarker rangeMarker) {
        return $this.contains($receiver, rangeMarker);
    }
}

