/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.settings;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ActiveOnboardingProvider;
import com.android.studio.ml.Authenticator;
import com.android.studio.ml.ConfigurableContributor;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.configuration.ContextSharingMode;
import com.android.studio.ml.bot.configuration.StudioBotAppSettings;
import com.android.studio.ml.bot.configuration.StudioBotProjectSettings;
import com.android.studio.ml.bot.configuration.StudioBotProjectSettingsImpl;
import com.android.studio.ml.bot.ui.onboarding.OnboardingState;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\"H\u0016J\b\u0010&\u001a\u00020\"H\u0016J\f\u0010'\u001a\u00020\u001a*\u00020$H\u0002J\f\u0010(\u001a\u00020\"*\u00020$H\u0002J\u0014\u0010)\u001a\u00020**\u00020$2\u0006\u0010+\u001a\u00020\u0013H\u0002J\f\u0010,\u001a\u00020\"*\u00020$H\u0002J\f\u0010-\u001a\u00020\u001a*\u00020$H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u0019\u0010.\u001a\u00070/\u00a2\u0006\u0002\b0X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u001eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u00066"}, d2={"Lcom/android/studio/ml/settings/ContextAwarenessConfigurableComponent;", "Lcom/android/studio/ml/ConfigurableContributor$SectionConfigurableContributorComponent;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "appSettings", "Lcom/android/studio/ml/bot/configuration/StudioBotAppSettings;", "getAppSettings", "()Lcom/android/studio/ml/bot/configuration/StudioBotAppSettings;", "projectSettings", "Lcom/android/studio/ml/bot/configuration/StudioBotProjectSettings;", "getProjectSettings", "()Lcom/android/studio/ml/bot/configuration/StudioBotProjectSettings;", "isContextSharingAvailable", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "onboardingState", "Lcom/android/studio/ml/bot/ui/onboarding/OnboardingState;", "onboardingCompleted", "isAuthorized", "isAskPerProject", "notOnboardedWarningRow", "Lcom/intellij/ui/dsl/builder/Row;", "settingsButtonGroup", "Lcom/intellij/ui/dsl/builder/ButtonsGroup;", "isVisible", "", "invoker", "Lcom/android/studio/ml/ConfigurableContributor$Invoker;", "setupUi", "", "builder", "Lcom/intellij/ui/dsl/builder/Panel;", "showUi", "hideUi", "shareContextRadioButton", "allowContextCheckboxes", "useContextFromThisProject", "Lcom/intellij/ui/components/JBCheckBox;", "isAlwaysShareMode", "previewAttachmentPermission", "neverShareRadioButton", "title", "", "Lorg/jetbrains/annotations/Nls;", "getTitle", "()Ljava/lang/String;", "isCollapsible", "()Z", "Companion", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nContextAwarenessConfigurableComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextAwarenessConfigurableComponent.kt\ncom/android/studio/ml/settings/ContextAwarenessConfigurableComponent\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,305:1\n24#2:306\n30#3,2:307\n30#3,2:312\n40#4,3:309\n*S KotlinDebug\n*F\n+ 1 ContextAwarenessConfigurableComponent.kt\ncom/android/studio/ml/settings/ContextAwarenessConfigurableComponent\n*L\n53#1:306\n72#1:307,2\n59#1:312,2\n56#1:309,3\n*E\n"})
public final class ContextAwarenessConfigurableComponent
implements ConfigurableContributor.SectionConfigurableContributorComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBooleanProperty isContextSharingAvailable;
    @NotNull
    private final OnboardingState onboardingState;
    @NotNull
    private final AtomicBooleanProperty onboardingCompleted;
    @NotNull
    private final AtomicBooleanProperty isAuthorized;
    @NotNull
    private final AtomicBooleanProperty isAskPerProject;
    private Row notOnboardedWarningRow;
    private ButtonsGroup settingsButtonGroup;
    @NotNull
    private final String title;
    private final boolean isCollapsible;
    public static final int $stable = 8;

    public ContextAwarenessConfigurableComponent(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        ContextAwarenessConfigurableComponent $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ContextAwarenessConfigurableComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.isContextSharingAvailable = new AtomicBooleanProperty(this.getAppSettings().getContextSharingMode() != ContextSharingMode.NeverShare && this.getAppSettings().getContextSharingMode() != ContextSharingMode.Unknown);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ActiveOnboardingProvider> serviceClass$iv = ActiveOnboardingProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.onboardingState = (OnboardingState)((ActiveOnboardingProvider)object).getOnboardingState().getValue();
        StateFlow<OnboardingState.State> stateFlow = this.onboardingState;
        this.onboardingCompleted = new AtomicBooleanProperty((stateFlow != null && (stateFlow = stateFlow.getCurrentState()) != null ? (OnboardingState.State)((Object)stateFlow.getValue()) : null) == OnboardingState.State.ONBOARDED);
        this.isAuthorized = new AtomicBooleanProperty(Authenticator.Companion.current().isAuthorized());
        this.isAskPerProject = new AtomicBooleanProperty(this.getAppSettings().getContextSharingMode() == ContextSharingMode.AskPerProject);
        this.title = SmlBundle.message("sml.studiobot.settings.codeSharing.title", new Object[0]);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final StudioBotAppSettings getAppSettings() {
        boolean $i$f$service = false;
        Class<StudioBotAppSettings> serviceClass$iv = StudioBotAppSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (StudioBotAppSettings)object;
    }

    private final StudioBotProjectSettings getProjectSettings() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<StudioBotProjectSettings> serviceClass$iv = StudioBotProjectSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (StudioBotProjectSettings)object;
    }

    @Override
    public boolean isVisible(@NotNull ConfigurableContributor.Invoker invoker) {
        Intrinsics.checkNotNullParameter((Object)((Object)invoker), (String)"invoker");
        return ConfigurableContributor.SectionConfigurableContributorComponent.super.isVisible(invoker) && invoker == ConfigurableContributor.Invoker.STUDIO_BOT_SETTINGS;
    }

    @Override
    public void setupUi(@NotNull Panel builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Panel $this$setupUi_u24lambda_u240 = builder;
        boolean bl = false;
        this.notOnboardedWarningRow = Panel.row$default((Panel)$this$setupUi_u24lambda_u240, null, ContextAwarenessConfigurableComponent::setupUi$lambda$0$0, (int)1, null).bottomGap(BottomGap.SMALL).visibleIf(PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.onboardingCompleted)));
        this.settingsButtonGroup = Panel.buttonsGroup$default((Panel)$this$setupUi_u24lambda_u240, null, (boolean)false, arg_0 -> ContextAwarenessConfigurableComponent.setupUi$lambda$0$1(this, arg_0), (int)3, null);
        ButtonsGroup buttonsGroup = this.settingsButtonGroup;
        if (buttonsGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settingsButtonGroup");
            buttonsGroup = null;
        }
    }

    @Override
    public void showUi() {
        Row row = this.notOnboardedWarningRow;
        if (row == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notOnboardedWarningRow");
            row = null;
        }
        row.visibleIf(PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.onboardingCompleted)));
        ButtonsGroup buttonsGroup = this.settingsButtonGroup;
        if (buttonsGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settingsButtonGroup");
            buttonsGroup = null;
        }
        buttonsGroup.visible(true);
    }

    @Override
    public void hideUi() {
        Row row = this.notOnboardedWarningRow;
        if (row == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notOnboardedWarningRow");
            row = null;
        }
        row.visible(false);
        ButtonsGroup buttonsGroup = this.settingsButtonGroup;
        if (buttonsGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settingsButtonGroup");
            buttonsGroup = null;
        }
        buttonsGroup.visible(false);
    }

    private final Row shareContextRadioButton(Panel $this$shareContextRadioButton) {
        return Panel.row$default((Panel)$this$shareContextRadioButton, null, arg_0 -> ContextAwarenessConfigurableComponent.shareContextRadioButton$lambda$0(this, arg_0), (int)1, null);
    }

    private final void allowContextCheckboxes(Panel $this$allowContextCheckboxes) {
        AtomicBooleanProperty isAlwaysShareMode = new AtomicBooleanProperty(this.getAppSettings().getContextSharingMode() == ContextSharingMode.AlwaysShare);
        Ref.ObjectRef contextFromProjectCheckbox = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$allowContextCheckboxes, null, arg_0 -> ContextAwarenessConfigurableComponent.allowContextCheckboxes$lambda$0(this, isAlwaysShareMode, contextFromProjectCheckbox, arg_0), (int)1, null);
        $this$allowContextCheckboxes.indent(arg_0 -> ContextAwarenessConfigurableComponent.allowContextCheckboxes$lambda$1(contextFromProjectCheckbox, this, isAlwaysShareMode, arg_0));
        this.previewAttachmentPermission($this$allowContextCheckboxes);
    }

    private final JBCheckBox useContextFromThisProject(Panel $this$useContextFromThisProject, AtomicBooleanProperty isAlwaysShareMode) {
        Ref.ObjectRef checkbox = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$useContextFromThisProject, null, arg_0 -> ContextAwarenessConfigurableComponent.useContextFromThisProject$lambda$0(checkbox, this, isAlwaysShareMode, arg_0), (int)1, null);
        Object object = checkbox.element;
        Intrinsics.checkNotNull((Object)object);
        return (JBCheckBox)object;
    }

    private final void previewAttachmentPermission(Panel $this$previewAttachmentPermission) {
        Panel.row$default((Panel)$this$previewAttachmentPermission, null, arg_0 -> ContextAwarenessConfigurableComponent.previewAttachmentPermission$lambda$0(this, arg_0), (int)1, null).bottomGap(BottomGap.MEDIUM);
    }

    private final Row neverShareRadioButton(Panel $this$neverShareRadioButton) {
        return Panel.row$default((Panel)$this$neverShareRadioButton, null, arg_0 -> ContextAwarenessConfigurableComponent.neverShareRadioButton$lambda$0(this, arg_0), (int)1, null);
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isCollapsible() {
        return this.isCollapsible;
    }

    private static final Unit setupUi$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)SmlBundle.message("sml.studiobot.settings.notOnboarded.info.html", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setupUi$lambda$0$1(ContextAwarenessConfigurableComponent this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        this$0.shareContextRadioButton($this$buttonsGroup);
        $this$buttonsGroup.indent(arg_0 -> ContextAwarenessConfigurableComponent.setupUi$lambda$0$1$0(this$0, arg_0));
        this$0.neverShareRadioButton($this$buttonsGroup);
        return Unit.INSTANCE;
    }

    private static final Unit setupUi$lambda$0$1$0(ContextAwarenessConfigurableComponent this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        this$0.allowContextCheckboxes($this$indent);
        return Unit.INSTANCE;
    }

    private static final Unit shareContextRadioButton$lambda$0(ContextAwarenessConfigurableComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)Cell.comment$default((Cell)Row.radioButton$default((Row)$this$row, (String)SmlBundle.message("sml.studiobot.settings.codeSharing.simplified.allowSharing.title.html", new Object[0]), null, (int)2, null), (String)SmlBundle.message("sml.studiobot.settings.codeSharing.simplified.allowSharing.comment.html", new Object[0]), (int)0, null, (int)6, null), () -> ContextAwarenessConfigurableComponent.shareContextRadioButton$lambda$0$0(this$0), arg_0 -> ContextAwarenessConfigurableComponent.shareContextRadioButton$lambda$0$1(this$0, arg_0)).onChanged(arg_0 -> ContextAwarenessConfigurableComponent.shareContextRadioButton$lambda$0$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean shareContextRadioButton$lambda$0$0(ContextAwarenessConfigurableComponent this$0) {
        return this$0.getAppSettings().getContextSharingMode() == ContextSharingMode.AskPerProject || this$0.getAppSettings().getContextSharingMode() == ContextSharingMode.AlwaysShare;
    }

    private static final Unit shareContextRadioButton$lambda$0$1(ContextAwarenessConfigurableComponent this$0, boolean isSelected) {
        if (isSelected) {
            ContextSharingMode mode = this$0.isAskPerProject.get() != false ? ContextSharingMode.AskPerProject : ContextSharingMode.AlwaysShare;
            this$0.getAppSettings().setContextSharingMode(mode);
            this$0.logger.info("ContextSharingMode changed to " + mode);
        }
        return Unit.INSTANCE;
    }

    private static final Unit shareContextRadioButton$lambda$0$2(ContextAwarenessConfigurableComponent this$0, JBRadioButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isSelected()) {
            this$0.isContextSharingAvailable.set(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit allowContextCheckboxes$lambda$0(ContextAwarenessConfigurableComponent this$0, AtomicBooleanProperty $isAlwaysShareMode, Ref.ObjectRef $contextFromProjectCheckbox, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Ref.BooleanRef pendingContextFromProjectChecked = new Ref.BooleanRef();
        pendingContextFromProjectChecked.element = this$0.getProjectSettings().getProjectContextSharing() == StudioBotProjectSettingsImpl.ProjectContextSharing.OptedIn;
        ButtonKt.bindSelected((Cell)$this$row.checkBox(SmlBundle.message("sml.studiobot.settings.codeSharing.simplified.allowSharing.dontAskAgain.html", new Object[0])), () -> ContextAwarenessConfigurableComponent.allowContextCheckboxes$lambda$0$0(this$0), arg_0 -> ContextAwarenessConfigurableComponent.allowContextCheckboxes$lambda$0$1(this$0, arg_0)).onChanged(arg_0 -> ContextAwarenessConfigurableComponent.allowContextCheckboxes$lambda$0$2($isAlwaysShareMode, $contextFromProjectCheckbox, pendingContextFromProjectChecked, arg_0)).onReset(() -> ContextAwarenessConfigurableComponent.allowContextCheckboxes$lambda$0$3(pendingContextFromProjectChecked, this$0)).enabledIf((ObservableProperty)this$0.isContextSharingAvailable);
        return Unit.INSTANCE;
    }

    private static final boolean allowContextCheckboxes$lambda$0$0(ContextAwarenessConfigurableComponent this$0) {
        return this$0.getAppSettings().getContextSharingMode() == ContextSharingMode.AlwaysShare;
    }

    private static final Unit allowContextCheckboxes$lambda$0$1(ContextAwarenessConfigurableComponent this$0, boolean isSelected) {
        this$0.getAppSettings().setContextSharingMode(isSelected ? ContextSharingMode.AlwaysShare : ContextSharingMode.AskPerProject);
        this$0.logger.info("ContextSharingMode changed to " + this$0.getAppSettings().getContextSharingMode());
        return Unit.INSTANCE;
    }

    private static final Unit allowContextCheckboxes$lambda$0$2(AtomicBooleanProperty $isAlwaysShareMode, Ref.ObjectRef $contextFromProjectCheckbox, Ref.BooleanRef $pendingContextFromProjectChecked, JBCheckBox dontAskAgainCheckbox) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dontAskAgainCheckbox, (String)"dontAskAgainCheckbox");
        $isAlwaysShareMode.set(dontAskAgainCheckbox.isSelected());
        Object object = $contextFromProjectCheckbox.element;
        Intrinsics.checkNotNull((Object)object);
        JBCheckBox jBCheckBox = (JBCheckBox)object;
        if (!dontAskAgainCheckbox.isSelected()) {
            bl = $pendingContextFromProjectChecked.element;
        } else {
            Object object2 = $contextFromProjectCheckbox.element;
            Intrinsics.checkNotNull((Object)object2);
            $pendingContextFromProjectChecked.element = ((JBCheckBox)object2).isSelected();
            bl = true;
        }
        jBCheckBox.setSelected(bl);
        return Unit.INSTANCE;
    }

    private static final Unit allowContextCheckboxes$lambda$0$3(Ref.BooleanRef $pendingContextFromProjectChecked, ContextAwarenessConfigurableComponent this$0) {
        $pendingContextFromProjectChecked.element = this$0.getProjectSettings().getProjectContextSharing() == StudioBotProjectSettingsImpl.ProjectContextSharing.OptedIn;
        return Unit.INSTANCE;
    }

    private static final Unit allowContextCheckboxes$lambda$1(Ref.ObjectRef $contextFromProjectCheckbox, ContextAwarenessConfigurableComponent this$0, AtomicBooleanProperty $isAlwaysShareMode, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $contextFromProjectCheckbox.element = this$0.useContextFromThisProject($this$indent, $isAlwaysShareMode);
        return Unit.INSTANCE;
    }

    private static final Unit useContextFromThisProject$lambda$0(Ref.ObjectRef $checkbox, ContextAwarenessConfigurableComponent this$0, AtomicBooleanProperty $isAlwaysShareMode, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this$0.project.getName(), (String)"getName(...)");
        $checkbox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(SmlBundle.message("sml.studiobot.settings.codeSharing.simplified.allowSharing.dontAskAgain.useForThisProject.html", objectArray)), () -> ContextAwarenessConfigurableComponent.useContextFromThisProject$lambda$0$0(this$0), arg_0 -> ContextAwarenessConfigurableComponent.useContextFromThisProject$lambda$0$1(this$0, arg_0)).enabledIf(PropertyOperationUtil.and((ObservableProperty)((ObservableProperty)this$0.isContextSharingAvailable), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)$isAlwaysShareMode)))).getComponent();
        Icon icon2 = AllIcons.General.ProjectConfigurable;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ProjectConfigurable");
        $this$row.icon(icon2).applyToComponent(ContextAwarenessConfigurableComponent::useContextFromThisProject$lambda$0$2);
        return Unit.INSTANCE;
    }

    private static final boolean useContextFromThisProject$lambda$0$0(ContextAwarenessConfigurableComponent this$0) {
        return this$0.getProjectSettings().getProjectContextSharing() == StudioBotProjectSettingsImpl.ProjectContextSharing.OptedIn;
    }

    private static final Unit useContextFromThisProject$lambda$0$1(ContextAwarenessConfigurableComponent this$0, boolean isSelected) {
        StudioBotProjectSettingsImpl.ProjectContextSharing sharing = isSelected ? StudioBotProjectSettingsImpl.ProjectContextSharing.OptedIn : StudioBotProjectSettingsImpl.ProjectContextSharing.OptedOut;
        this$0.getProjectSettings().setProjectContextSharing(sharing);
        this$0.logger.info("ProjectContextSharing changed to " + sharing);
        return Unit.INSTANCE;
    }

    private static final Unit useContextFromThisProject$lambda$0$2(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        Object[] objectArray = new Object[]{new Object[0]};
        $this$applyToComponent.setToolTipText(IdeUICustomization.getInstance().projectMessage("configurable.current.project.tooltip", objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit previewAttachmentPermission$lambda$0(ContextAwarenessConfigurableComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = ButtonKt.bindSelected((Cell)$this$row.checkBox(SmlBundle.message("sml.studiobot.settings.previewAttachment.title", new Object[0])), () -> ContextAwarenessConfigurableComponent.previewAttachmentPermission$lambda$0$0(this$0), arg_0 -> ContextAwarenessConfigurableComponent.previewAttachmentPermission$lambda$0$1(this$0, arg_0)).enabledIf((ObservableProperty)this$0.isContextSharingAvailable);
        Object object = StudioFlags.COMPOSE_PREVIEW_TRANSFORM_UI_WITH_AI.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        cell.visibleIf((ObservableProperty)new AtomicBooleanProperty(((Boolean)object).booleanValue()));
        return Unit.INSTANCE;
    }

    private static final boolean previewAttachmentPermission$lambda$0$0(ContextAwarenessConfigurableComponent this$0) {
        return this$0.getAppSettings().isPreviewAttachmentEnabled();
    }

    private static final Unit previewAttachmentPermission$lambda$0$1(ContextAwarenessConfigurableComponent this$0, boolean it) {
        this$0.getAppSettings().setPreviewAttachmentEnabled(it);
        this$0.logger.info("PreviewAttachmentEnabled changed to " + it);
        return Unit.INSTANCE;
    }

    private static final Unit neverShareRadioButton$lambda$0(ContextAwarenessConfigurableComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)Cell.comment$default((Cell)Row.radioButton$default((Row)$this$row, (String)SmlBundle.message("sml.studiobot.settings.codeSharing.simplified.neverShare.title.html", new Object[0]), null, (int)2, null), (String)SmlBundle.message("sml.studiobot.settings.codeSharing.simplified.neverShare.comment.html", new Object[0]), (int)0, null, (int)6, null), () -> ContextAwarenessConfigurableComponent.neverShareRadioButton$lambda$0$0(this$0), arg_0 -> ContextAwarenessConfigurableComponent.neverShareRadioButton$lambda$0$1(this$0, arg_0)).onChanged(arg_0 -> ContextAwarenessConfigurableComponent.neverShareRadioButton$lambda$0$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean neverShareRadioButton$lambda$0$0(ContextAwarenessConfigurableComponent this$0) {
        return this$0.getAppSettings().getContextSharingMode() == ContextSharingMode.NeverShare;
    }

    private static final Unit neverShareRadioButton$lambda$0$1(ContextAwarenessConfigurableComponent this$0, boolean it) {
        this$0.getAppSettings().setContextSharingMode(ContextSharingMode.NeverShare);
        this$0.logger.info("ContextSharingMode changed to NeverShare");
        return Unit.INSTANCE;
    }

    private static final Unit neverShareRadioButton$lambda$0$2(ContextAwarenessConfigurableComponent this$0, JBRadioButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isSelected()) {
            this$0.isContextSharingAvailable.set(false);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/android/studio/ml/settings/ContextAwarenessConfigurableComponent$Companion;", "", "<init>", "()V", "getSearchableOptions", "", "", "aiplugin.android"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Collection<String> getSearchableOptions() {
            Object[] objectArray = new String[]{"Context Awareness", "Use all Gemini features (recommended)", "Allow project context use to get full access to all Gemini features.", "Apply to all projects", "Use context from this project", "Use chat only, without project context", "Don't allow project context use and get limited access to Gemini features."};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

