/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.releasenotes.fetchers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.gradle.Version;
import com.android.studio.ml.releasenotes.ReleaseNotes;
import com.android.studio.ml.releasenotes.ReleaseNotesContentProvider;
import com.android.studio.ml.releasenotes.ReleaseNotesQuery;
import com.android.studio.ml.releasenotes.fetchers.GithubChangeLogUrlResolver;
import com.android.studio.ml.releasenotes.fetchers.ReleaseNotesFetcher;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/releasenotes/fetchers/GithubChangeLogFetcher;", "Lcom/android/studio/ml/releasenotes/fetchers/ReleaseNotesFetcher;", "<init>", "()V", "getReleaseNotesUrl", "Ljava/net/URL;", "query", "Lcom/android/studio/ml/releasenotes/ReleaseNotesQuery;", "fetch", "", "Lcom/android/studio/ml/releasenotes/ReleaseNotes;", "request", "contentProvider", "Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProvider;", "getReleasesFromMarkdownChangelogUrl", "changelogUrl", "newVersion", "", "oldVersion", "extractReleasesFromMarkdownChangelog", "markdown", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class GithubChangeLogFetcher
implements ReleaseNotesFetcher {
    public static final int $stable;

    @Override
    @Nullable
    public URL getReleaseNotesUrl(@NotNull ReleaseNotesQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return GithubChangeLogUrlResolver.INSTANCE.getUrl(query.getLibrary().getGroup(), query.getLibrary().getArtifact());
    }

    @Override
    @Nullable
    public List<ReleaseNotes> fetch(@NotNull ReleaseNotesQuery request2, @NotNull ReleaseNotesContentProvider contentProvider) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)contentProvider, (String)"contentProvider");
        String newVersion = request2.getTargetVersion();
        Version oldVersion = request2.getLibrary().getVersion();
        URL uRL = GithubChangeLogUrlResolver.INSTANCE.getUrl(request2.getLibrary().getGroup(), request2.getLibrary().getArtifact());
        if (uRL == null) {
            return null;
        }
        URL changeLog = uRL;
        return this.getReleasesFromMarkdownChangelogUrl(changeLog, newVersion, oldVersion.toString(), contentProvider);
    }

    private final List<ReleaseNotes> getReleasesFromMarkdownChangelogUrl(URL changelogUrl, String newVersion, String oldVersion, ReleaseNotesContentProvider contentProvider) {
        Object object = contentProvider.getReleaseNotes(changelogUrl);
        if (object == null || (object = ((ReleaseNotesContentProvider.ReleaseNotesContent)object).getContent()) == null) {
            object = "";
        }
        Object markdown2 = object;
        return this.extractReleasesFromMarkdownChangelog((String)markdown2, newVersion, oldVersion);
    }

    @NotNull
    public final List<ReleaseNotes> extractReleasesFromMarkdownChangelog(@NotNull String markdown2, @NotNull String newVersion, @NotNull String oldVersion) {
        Intrinsics.checkNotNullParameter((Object)markdown2, (String)"markdown");
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        Intrinsics.checkNotNullParameter((Object)oldVersion, (String)"oldVersion");
        List list = new ArrayList();
        Version fromVersion = Version.Companion.parse(oldVersion);
        Version toVersion = Version.Companion.parse(newVersion);
        Ref.ObjectRef currentVersion = new Ref.ObjectRef();
        List currentText = new ArrayList();
        List lines = StringsKt.lines((CharSequence)markdown2);
        for (int lineNo = 0; lineNo < lines.size(); ++lineNo) {
            String line = (String)lines.get(lineNo);
            if (StringsKt.startsWith$default((String)line, (String)"## ", (boolean)false, (int)2, null) && line.length() > 3 || lineNo < lines.size() - 1 && StringsKt.startsWith$default((String)((String)lines.get(lineNo + 1)), (String)"===", (boolean)false, (int)2, null)) {
                GithubChangeLogFetcher.extractReleasesFromMarkdownChangelog$flush((Ref.ObjectRef<Version>)currentVersion, list, currentText);
                Version version = GithubChangeLogFetcher.extractReleasesFromMarkdownChangelog$getVersion(line);
                if (version == null || version.compareTo(fromVersion) <= 0 || version.compareTo(toVersion) > 0) continue;
                currentVersion.element = version;
                if (StringsKt.startsWith$default((String)line, (String)"## ", (boolean)false, (int)2, null)) continue;
                ++lineNo;
                continue;
            }
            if (currentVersion.element == null) continue;
            currentText.add(line);
        }
        GithubChangeLogFetcher.extractReleasesFromMarkdownChangelog$flush((Ref.ObjectRef<Version>)currentVersion, list, currentText);
        return list;
    }

    private static final void extractReleasesFromMarkdownChangelog$flush(Ref.ObjectRef<Version> currentVersion, List<ReleaseNotes> list, List<String> currentText) {
        if (currentVersion.element != null) {
            Object object = currentVersion.element;
            Intrinsics.checkNotNull((Object)object);
            list.add(new ReleaseNotes((Version)object, ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)currentText, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))).toString()));
            currentText.clear();
            currentVersion.element = null;
        }
    }

    private static final Version extractReleasesFromMarkdownChangelog$getVersion(String line) {
        String line2 = StringsKt.removeSurrounding((String)StringsKt.substringBefore$default((String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)StringsKt.removePrefix((String)line, (CharSequence)"## "), (CharSequence)"Version "))).toString(), (String)" ", null, (int)2, null), (CharSequence)"[", (CharSequence)"]");
        if (((CharSequence)line2).length() > 0 && Character.isDigit(line2.charAt(0))) {
            return Version.Companion.parse(line2);
        }
        return null;
    }
}

