/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.npa.tools;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.npa.tools.MemoryItem;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.tools.DeclarativeToolSet;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolFunction;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0003J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0007J\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\u0006\u0010\u001d\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/studio/ml/npa/tools/MemoryTools;", "Lcom/google/aiplugin/agents/tools/DeclarativeToolSet;", "prefix", "", "maxKeys", "", "persistentMemoryPath", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getMaxKeys", "()I", "memoryItems", "Ljava/util/LinkedHashMap;", "Lcom/android/studio/ml/npa/tools/MemoryItem;", "Lkotlin/collections/LinkedHashMap;", "loadPersistentMemory", "", "noteDown", "Lcom/google/aiplugin/agents/Response;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "key", "value", "sticky", "", "creator", "recall", "delete", "evictOldestByPriority", "peekAsPrompt", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMemoryTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryTools.kt\ncom/android/studio/ml/npa/tools/MemoryTools\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1869#2,2:180\n774#2:183\n865#2,2:184\n1869#2,2:186\n774#2:188\n865#2,2:189\n1#3:182\n*S KotlinDebug\n*F\n+ 1 MemoryTools.kt\ncom/android/studio/ml/npa/tools/MemoryTools\n*L\n73#1:180,2\n165#1:183\n165#1:184,2\n165#1:186,2\n168#1:188\n168#1:189,2\n*E\n"})
public final class MemoryTools
extends DeclarativeToolSet {
    @NotNull
    private final String prefix;
    private final int maxKeys;
    @Nullable
    private final String persistentMemoryPath;
    @NotNull
    private LinkedHashMap<String, MemoryItem> memoryItems;
    public static final int $stable = 8;

    public MemoryTools(@NotNull String prefix, int maxKeys, @Nullable String persistentMemoryPath) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        super(prefix);
        this.prefix = prefix;
        this.maxKeys = maxKeys;
        this.persistentMemoryPath = persistentMemoryPath;
        this.memoryItems = new LinkedHashMap();
        if (!(this.maxKeys > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.loadPersistentMemory();
    }

    public /* synthetic */ MemoryTools(String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "memory";
        }
        if ((n2 & 2) != 0) {
            n = 500;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        this(string, n, string2);
    }

    public final int getMaxKeys() {
        return this.maxKeys;
    }

    private final void loadPersistentMemory() {
        if (this.persistentMemoryPath == null) {
            return;
        }
        Gson gson = new Gson();
        Type type2 = new TypeToken<List<? extends MemoryItem>>(){}.getType();
        try {
            File persistentMemoryFile = new File(this.persistentMemoryPath);
            if (persistentMemoryFile.exists()) {
                String json = FilesKt.readText$default((File)persistentMemoryFile, null, (int)1, null);
                Object object = gson.fromJson(json, type2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                List persistentMemory = (List)object;
                Iterable $this$forEach$iv = persistentMemory;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MemoryItem item = (MemoryItem)element$iv;
                    boolean bl = false;
                    if (this.memoryItems.size() >= this.maxKeys) continue;
                    ((Map)this.memoryItems).put(item.getKey(), item);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final Response noteDown(@NotNull ToolContext context2, @NotNull String key, @NotNull String value, boolean sticky, @NotNull String creator) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        if (this.memoryItems.containsKey(key)) {
            MemoryItem memoryItem = this.memoryItems.get(key);
            Intrinsics.checkNotNull((Object)memoryItem);
            if (Intrinsics.areEqual((Object)memoryItem.getCreator(), (Object)"persistent")) {
                return new Response(null, "Never overwrite persistent memory", null, null, null, 29, null);
            }
            this.memoryItems.remove(key);
        } else if (this.memoryItems.size() >= this.maxKeys) {
            this.evictOldestByPriority();
        }
        if (this.memoryItems.size() >= this.maxKeys) {
            return new Response(null, "Memory is full. Could not add new keys.", null, null, null, 29, null);
        }
        ((Map)this.memoryItems).put(key, new MemoryItem(key, value, System.currentTimeMillis(), sticky, creator));
        return new Response(null, null, null, null, Response.ToolExecutionStatus.OK, 15, null);
    }

    public static /* synthetic */ Response noteDown$default(MemoryTools memoryTools, ToolContext toolContext, String string, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string3 = "";
        }
        return memoryTools.noteDown(toolContext, string, string2, bl, string3);
    }

    @ToolFunction(name="recall", description="\n      Fetches a note from memory.\n\n      Args:\n        key: The key to recall.\n      ", displayText="Fetching note with key {key} from memory")
    @NotNull
    public final Response recall(@NotNull ToolContext context2, @NotNull String key) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MemoryItem item = (MemoryItem)this.memoryItems.remove(key);
        if (item != null) {
            ((Map)this.memoryItems).put(key, item);
            Response.ToolExecutionStatus toolExecutionStatus = Response.ToolExecutionStatus.OK;
            String string = new Gson().toJson((Object)item.getValue());
            response2 = new Response(string, null, null, null, toolExecutionStatus, 14, null);
        } else {
            response2 = new Response(null, "No note found for key: " + key, null, null, null, 29, null);
        }
        return response2;
    }

    @NotNull
    public final Response delete(@NotNull ToolContext context2, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MemoryItem removed2 = (MemoryItem)this.memoryItems.remove(key);
        return removed2 != null ? new Response("Deleted note with key: " + key, null, null, null, Response.ToolExecutionStatus.OK, 14, null) : new Response(null, "No note found with key: " + key, null, null, null, 29, null);
    }

    private final void evictOldestByPriority() {
        Map.Entry entry;
        Object v1;
        block3: {
            if (this.memoryItems.isEmpty()) {
                return;
            }
            Set<Map.Entry<String, MemoryItem>> set = this.memoryItems.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!(!((MemoryItem)it.getValue()).getSticky())) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        if ((entry = (Map.Entry)v1) == null) {
            Set<Map.Entry<String, MemoryItem>> set = this.memoryItems.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Object object = CollectionsKt.first((Iterable)set);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            entry = (Map.Entry)object;
        }
        Map.Entry entryToRemove = entry;
        this.memoryItems.remove(entryToRemove.getKey());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String peekAsPrompt() {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv2;
        long now = System.currentTimeMillis();
        List lines = new ArrayList();
        if (this.memoryItems.values().isEmpty()) {
            return "";
        }
        lines.add("## " + this.prefix);
        lines.add("");
        Collection<MemoryItem> collection = this.memoryItems.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            MemoryItem it = (MemoryItem)element$iv$iv;
            boolean bl = false;
            if (!it.getSticky()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            MemoryItem v = (MemoryItem)element$iv2;
            boolean bl = false;
            lines.add("* " + v.getKey() + " : " + v.getValue());
        }
        Collection<MemoryItem> collection2 = this.memoryItems.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        Iterable $this$filter$iv2 = collection2;
        boolean $i$f$filter2 = false;
        element$iv2 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MemoryItem it = (MemoryItem)element$iv$iv;
            boolean bl = false;
            if (!(!it.getSticky())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nonSticky = (List)destination$iv$iv2;
        if (!((Collection)nonSticky).isEmpty()) {
            for (Object e : nonSticky) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                MemoryItem v = (MemoryItem)e;
                lines.add("* " + v.getKey() + " : <values accessible via `" + this.prefix + "_recall(\"" + v.getKey() + "\")` tool call>");
            }
        }
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public MemoryTools() {
        this(null, 0, null, 7, null);
    }
}

