/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.npa.logs;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.npa.logs.SessionLogger;
import com.google.aiplugin.agents.logs.AgentLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Disposer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\tH\u0007J$\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/studio/ml/npa/logs/AgentLoggerFactory;", "", "<init>", "()V", "sessionLoggers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/studio/ml/npa/logs/SessionLogger;", "baseLogPathForTesting", "Ljava/nio/file/Path;", "setBaseLogPathForTesting", "", "path", "startSession", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "sessionId", "sessionPrefix", "endSession", "getLogger", "Lcom/google/aiplugin/agents/logs/AgentLogger;", "agentName", "generateSessionName", "prefix", "Companion", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class AgentLoggerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, SessionLogger> sessionLoggers = new ConcurrentHashMap();
    @Nullable
    private Path baseLogPathForTesting;
    public static final int $stable = 8;
    @NotNull
    private static final AgentLoggerFactory INSTANCE = new AgentLoggerFactory();

    private AgentLoggerFactory() {
    }

    @TestOnly
    public final void setBaseLogPathForTesting(@Nullable Path path2) {
        this.baseLogPathForTesting = path2;
    }

    @NotNull
    public final String startSession(@NotNull Disposable parentDisposable, @Nullable String sessionId, @NotNull String sessionPrefix) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)sessionPrefix, (String)"sessionPrefix");
        String string = sessionId;
        if (string == null) {
            string = this.generateSessionName(sessionPrefix);
        }
        String idToUse = string;
        this.sessionLoggers.computeIfAbsent(idToUse, arg_0 -> AgentLoggerFactory.startSession$lambda$1(arg_0 -> AgentLoggerFactory.startSession$lambda$0(this, parentDisposable, arg_0), arg_0));
        return idToUse;
    }

    public static /* synthetic */ String startSession$default(AgentLoggerFactory agentLoggerFactory, Disposable disposable, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = "agent_session";
        }
        return agentLoggerFactory.startSession(disposable, string, string2);
    }

    public final void endSession(@NotNull String sessionId) {
        block0: {
            SessionLogger sessionLogger;
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            SessionLogger sessionLogger2 = sessionLogger = this.sessionLoggers.remove(sessionId);
            if (sessionLogger2 == null) break block0;
            sessionLogger2.close();
        }
    }

    @NotNull
    public final AgentLogger getLogger(@NotNull String agentName, @NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        SessionLogger sessionLogger = this.sessionLoggers.get(sessionId);
        if (sessionLogger == null) {
            throw new IllegalStateException("Session not found for ID: " + sessionId);
        }
        SessionLogger sessionLogger2 = sessionLogger;
        return sessionLogger2.getAgentLogger(agentName);
    }

    private final String generateSessionName(String prefix) {
        long timestamp = Instant.now().toEpochMilli();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        int n = 0;
        int n2 = 4;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String uuid = string3;
        return prefix + "_" + timestamp + "_" + uuid;
    }

    private static final SessionLogger startSession$lambda$0(AgentLoggerFactory this$0, Disposable $parentDisposable, String newSessionId) {
        Intrinsics.checkNotNullParameter((Object)newSessionId, (String)"newSessionId");
        Path path2 = this$0.baseLogPathForTesting;
        if (path2 == null) {
            path2 = Paths.get(PathManager.getLogPath(), new String[0]);
        }
        Path path3 = path2;
        Intrinsics.checkNotNull((Object)path3);
        SessionLogger newSessionLogger = new SessionLogger(newSessionId, path3);
        Disposer.register((Disposable)$parentDisposable, () -> AgentLoggerFactory.startSession$lambda$0$0(this$0, newSessionId));
        return newSessionLogger;
    }

    private static final void startSession$lambda$0$0(AgentLoggerFactory this$0, String $newSessionId) {
        Intrinsics.checkNotNull((Object)$newSessionId);
        this$0.endSession($newSessionId);
    }

    private static final SessionLogger startSession$lambda$1(Function1 $tmp0, Object p0) {
        return (SessionLogger)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/studio/ml/npa/logs/AgentLoggerFactory$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/android/studio/ml/npa/logs/AgentLoggerFactory;", "getInstance", "aiplugin.android"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AgentLoggerFactory getInstance() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

