/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.logcat;

import com.android.tools.idea.logcat.message.LogcatMessage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"extractStudioBotContent", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "TOP_FRAME_COUNT", "", "extractRelevant", "message", "pickStack", "isCrashFrame", "", "line", "aiplugin.android"})
public final class LogcatStudioBotKt {
    private static final int TOP_FRAME_COUNT = 5;

    @NotNull
    public static final String extractStudioBotContent(@NotNull LogcatMessage $this$extractStudioBotContent) {
        Intrinsics.checkNotNullParameter((Object)$this$extractStudioBotContent, (String)"<this>");
        return LogcatStudioBotKt.extractRelevant($this$extractStudioBotContent.getMessage()) + " with tag " + $this$extractStudioBotContent.getHeader().getTag();
    }

    private static final String extractRelevant(String message) {
        if (LogcatStudioBotKt.isCrashFrame(message)) {
            String stack = LogcatStudioBotKt.pickStack(message);
            List frames = StringsKt.lines((CharSequence)stack);
            List top = frames.subList(0, Math.min(frames.size(), 5));
            return CollectionsKt.joinToString$default((Iterable)top, (CharSequence)"\n", null, null, (int)0, null, LogcatStudioBotKt::extractRelevant$lambda$0, (int)30, null);
        }
        return ((Object)StringsKt.trim((CharSequence)message)).toString();
    }

    private static final String pickStack(String message) {
        if (!LogcatStudioBotKt.isCrashFrame(message)) {
            return message;
        }
        String[] stringArray = new String[]{"Caused by: "};
        List chains = StringsKt.split$default((CharSequence)message, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String trace : chains) {
            int start2;
            int stack = StringsKt.indexOf$default((CharSequence)trace, (String)"\tat ", (int)0, (boolean)false, (int)6, null);
            if (stack == -1 || !StringsKt.startsWith$default((String)trace, (String)"java.", (int)(start2 = stack + 4), (boolean)false, (int)4, null) && !StringsKt.startsWith$default((String)trace, (String)"android.", (int)start2, (boolean)false, (int)4, null) && !StringsKt.startsWith$default((String)trace, (String)"org.apache.", (int)start2, (boolean)false, (int)4, null) && !StringsKt.startsWith$default((String)trace, (String)"org.json.", (int)start2, (boolean)false, (int)4, null) && !StringsKt.startsWith$default((String)trace, (String)"com.google.", (int)start2, (boolean)false, (int)4, null) && !StringsKt.startsWith$default((String)trace, (String)"com.android.internal", (int)start2, (boolean)false, (int)4, null)) continue;
            return trace;
        }
        return message;
    }

    private static final boolean isCrashFrame(String line) {
        return StringsKt.contains$default((CharSequence)line, (CharSequence)"\tat ", (boolean)false, (int)2, null);
    }

    private static final CharSequence extractRelevant$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }
}

