/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.recorder.dataprocessors;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/journeys/recorder/dataprocessors/BufferedImageCache;", "", "<init>", "()V", "lastDimension", "Ljava/awt/Dimension;", "lastImageType", "", "cachedBufferedImages", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/lang/ref/SoftReference;", "Ljava/awt/image/BufferedImage;", "getBufferedImage", "dimension", "imageType", "getBufferedImage$aiplugin_android_journeys", "returnBufferedImage", "", "image", "returnBufferedImage$aiplugin_android_journeys", "aiplugin.android.journeys"})
@StabilityInferred(parameters=0)
public final class BufferedImageCache {
    @NotNull
    private Dimension lastDimension = new Dimension(-1, -1);
    private int lastImageType = -1;
    @NotNull
    private final ConcurrentLinkedDeque<SoftReference<BufferedImage>> cachedBufferedImages = new ConcurrentLinkedDeque();
    public static final int $stable = 8;

    @NotNull
    public final synchronized BufferedImage getBufferedImage$aiplugin_android_journeys(@NotNull Dimension dimension, int imageType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        if (!Intrinsics.areEqual((Object)this.lastDimension, (Object)dimension) || imageType != this.lastImageType) {
            this.cachedBufferedImages.clear();
            this.lastDimension = dimension;
            this.lastImageType = imageType;
        }
        if ((object = this.cachedBufferedImages.pollLast()) == null || (object = ((SoftReference)object).get()) == null) {
            object = new BufferedImage(this.lastDimension.width, this.lastDimension.height, this.lastImageType);
        }
        return object;
    }

    public final synchronized void returnBufferedImage$aiplugin_android_journeys(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image.getWidth() != this.lastDimension.width || image.getHeight() != this.lastDimension.height || image.getType() != this.lastImageType) {
            return;
        }
        this.cachedBufferedImages.add(new SoftReference<BufferedImage>(image));
    }
}

