/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle.buildsystem;

import com.android.studio.ml.buildsystem.BuildEvent;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.FilePosition;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0018\u0010\n\u001a\u00020\u000b*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"BUILD_FINISHED_PREFIX", "", "BUILD_FAILURE_PREFIX", "BUILD_SUCCESSFUL_SUFFIX", "BUILD_ERROR_SUFFIX", "MAX_CONSOLE_LINES", "", "formatErrorForLlm", "evt", "Lcom/android/studio/ml/buildsystem/BuildEvent$Message;", "replaceLastLineWith", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "replacement", "aiplugin.android.gradle"})
public final class GradleBuildToolKt {
    @NotNull
    private static final String BUILD_FINISHED_PREFIX = "Build finished";
    @NotNull
    private static final String BUILD_FAILURE_PREFIX = "Build Failed";
    @NotNull
    private static final String BUILD_SUCCESSFUL_SUFFIX = "successfully";
    @NotNull
    private static final String BUILD_ERROR_SUFFIX = "with errors";
    private static final int MAX_CONSOLE_LINES = 1000;

    @VisibleForTesting
    @NotNull
    public static final String formatErrorForLlm(@NotNull BuildEvent.Message evt) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        StringBuilder $this$formatErrorForLlm_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (evt.getDetails() != null) {
            $this$formatErrorForLlm_u24lambda_u240.append(evt.getSeverity().name() + ":").append('\n');
            $this$formatErrorForLlm_u24lambda_u240.append(evt.getDetails());
        } else {
            FilePosition filePosition = evt.getFilePosition();
            if (filePosition != null) {
                FilePosition it = filePosition;
                boolean bl2 = false;
                int startLine = it.getStartLine();
                int endLine = it.getEndLine();
                String line = endLine > startLine ? "at lines " + startLine + "-" + endLine : "at line " + startLine;
                File file = it.getFile();
                Intrinsics.checkNotNull((Object)file);
                $this$formatErrorForLlm_u24lambda_u240.append("In " + file.getPath() + ", " + line + ": ");
            }
            $this$formatErrorForLlm_u24lambda_u240.append(evt.getSeverity().name() + ": " + evt.getMessage());
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    public static final void replaceLastLineWith(@NotNull StringBuilder $this$replaceLastLineWith, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceLastLineWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        int lastLineStartIndex = $this$replaceLastLineWith.lastIndexOf("\n");
        StringBuilder stringBuilder = lastLineStartIndex >= 0 ? $this$replaceLastLineWith.replace(lastLineStartIndex + 1, $this$replaceLastLineWith.length(), replacement) : $this$replaceLastLineWith.replace(0, $this$replaceLastLineWith.length(), replacement);
    }
}

