/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle.buildsystem;

import com.android.studio.ml.gradle.buildsystem.ArtifactCoordinate;
import com.android.studio.ml.gradle.buildsystem.GradleTool;
import com.android.studio.ml.gradle.buildsystem.GradleToolsUtilsKt;
import com.android.studio.ml.gradle.buildsystem.ProjectData;
import com.android.studio.ml.gradle.buildsystem.SourceSetModuleData;
import com.android.tools.idea.gradle.model.IdeSourceProvider;
import com.android.tools.idea.gradle.model.impl.FileImpl;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.util.FileExtensions;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.gson.Gson;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@ToolDescription(summary="Returns the source folders for the provided artifact if it exists", instructions="The input should not be inferred from path and other data. It should be based on returned values of get_gradle_artifact_from_file.", examples={})
@ToolResult(description="An array of folders")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetSourceFoldersForArtifact;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;", "Lcom/android/studio/ml/gradle/buildsystem/GradleTool;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Companion", "Handler", "aiplugin.android.gradle"})
public final class GetSourceFoldersForArtifact
implements Tool<ArtifactCoordinate>,
GradleTool<ArtifactCoordinate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "get_source_folders_for_artifact";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull ArtifactCoordinate args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Finding source folders for " + args.getSubproject_path() + ":" + args.getArtifact_name();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull ArtifactCoordinate args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Found source folders for " + args.getSubproject_path() + ":" + args.getArtifact_name();
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ArtifactCoordinate args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetSourceFoldersForArtifact$Companion;", "", "<init>", "()V", "NAME", "", "aiplugin.android.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetSourceFoldersForArtifact$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;)V", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryHandleAndroidModule", "projectData", "Lcom/android/studio/ml/gradle/buildsystem/ProjectData;", "gradleModel", "Lcom/android/tools/idea/gradle/project/model/GradleAndroidModel;", "tryHandleAsNonAndroidModule", "aiplugin.android.gradle"})
    @SourceDebugExtension(value={"SMAP\nGetSourceFoldersForArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetSourceFoldersForArtifact.kt\ncom/android/studio/ml/gradle/buildsystem/GetSourceFoldersForArtifact$Handler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,113:1\n1#2:114\n1374#3:115\n1460#3,5:116\n1563#3:121\n1634#3,3:122\n11228#4:125\n11563#4,3:126\n*S KotlinDebug\n*F\n+ 1 GetSourceFoldersForArtifact.kt\ncom/android/studio/ml/gradle/buildsystem/GetSourceFoldersForArtifact$Handler\n*L\n98#1:115\n98#1:116,5\n101#1:121\n101#1:122,3\n109#1:125\n109#1:126,3\n*E\n"})
    private static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final ArtifactCoordinate args;

        public Handler(@NotNull ToolContext context2, @NotNull ArtifactCoordinate args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            return CoroutinesKt.readAction(() -> Handler.handle$lambda$0(this), $completion);
        }

        /*
         * WARNING - void declaration
         */
        private final Response tryHandleAndroidModule(ProjectData projectData, GradleAndroidModel gradleModel) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list;
            Object v0;
            Object it;
            Iterable iterable;
            block6: {
                iterable = projectData.getSourceSetModules();
                for (Object t : iterable) {
                    it = (SourceSetModuleData)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((SourceSetModuleData)it).getSourceSetName(), (Object)this.args.getArtifact_name())) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            SourceSetModuleData sourceSetModuleData = v0;
            if (sourceSetModuleData == null) {
                return GradleToolsUtilsKt.errorArtifactNotFoundInProject(this.args.getArtifact_name(), this.args.getSubproject_path());
            }
            SourceSetModuleData sourceSetModule = sourceSetModuleData;
            List<IdeSourceProvider> list2 = sourceSetModule.retrieveSourceProviders(gradleModel);
            if (list2 != null) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = list2;
                boolean $i$f$flatMap = false;
                it = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    IdeSourceProvider it2 = (IdeSourceProvider)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it2.getKotlinDirectories();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List folders = list;
            iterable = folders;
            Gson gson = GradleToolsUtilsKt.createGson();
            boolean $i$f$map = false;
            void $i$f$flatMap = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Object element$iv$iv;
                element$iv$iv = (FileImpl)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it3.toURI());
            }
            String string = gson.toJson((Object)((List)destination$iv$iv));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return GradleToolsUtilsKt.successResponse(string);
        }

        /*
         * WARNING - void declaration
         */
        private final Response tryHandleAsNonAndroidModule(ProjectData projectData) {
            void $this$map$iv;
            VirtualFile[] folders;
            Object v0;
            VirtualFile[] virtualFileArray;
            block3: {
                virtualFileArray = (VirtualFile[])projectData.getSourceSetModules();
                for (Object t2 : virtualFileArray) {
                    SourceSetModuleData it = (SourceSetModuleData)t2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSourceSetName(), (Object)this.args.getArtifact_name())) continue;
                    v0 = t2;
                    break block3;
                }
                v0 = null;
            }
            SourceSetModuleData sourceSetModuleData = v0;
            if (sourceSetModuleData == null) {
                return GradleToolsUtilsKt.errorArtifactNotFoundInProject(this.args.getArtifact_name(), this.args.getSubproject_path());
            }
            SourceSetModuleData module2 = sourceSetModuleData;
            virtualFileArray = folders = ProjectRootsUtilKt.getSourceRoots((Module)module2.getModule());
            Gson gson = GradleToolsUtilsKt.createGson();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)var6_6).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var12_15 = item$iv$iv = var6_6[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileExtensions.toIoFile((VirtualFile)it).toURI());
            }
            String string = gson.toJson((Object)((List)destination$iv$iv));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return GradleToolsUtilsKt.successResponse(string);
        }

        private static final Response handle$lambda$0(Handler this$0) {
            Project project2 = this$0.context.getProject();
            return GradleToolsUtilsKt.handleCheckingSyncState(project2, (Function0<Response>)((Function0)() -> Handler.handle$lambda$0$0(project2, this$0)));
        }

        private static final Response handle$lambda$0$0(Project $project, Handler this$0) {
            ModuleManager moduleManager = ModuleManager.Companion.getInstance($project);
            Module[] modules = moduleManager.getModules();
            if (modules.length == 0) {
                return GradleToolsUtilsKt.errorNoModules();
            }
            Map<String, ProjectData> modulesByGradlePath = GradleToolsUtilsKt.buildModulesMap($project);
            ProjectData projectData = modulesByGradlePath.get(this$0.args.getSubproject_path());
            if (projectData == null) {
                return GradleToolsUtilsKt.errorModuleNotFound(this$0.args.getSubproject_path());
            }
            ProjectData requestedProjectData = projectData;
            GradleAndroidModel gradleModel = GradleAndroidModel.Companion.get(requestedProjectData.getRootModule().getModule());
            return gradleModel != null ? this$0.tryHandleAndroidModule(requestedProjectData, gradleModel) : this$0.tryHandleAsNonAndroidModule(requestedProjectData);
        }
    }
}

