/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.device;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.sdklib.deviceprovisioner.DeviceProvisioner;
import com.android.studio.ml.device.DeviceSnapshot;
import com.android.studio.ml.device.DevicesKt;
import com.android.studio.ml.device.ListDevicesToolKt;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.android.tools.idea.deviceprovisioner.DeviceProvisionerService;
import com.google.aiplugin.agents.NoArgs;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.gson.Gson;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Lists the available Android devices", description="Shows all devices which are already connected, plus emulators and remote devices which can be made available using the connect_device tool.", examples={})
@ToolResult(description="Returns a JSON array containing descriptions of the connected and available devices. Some fields include: \n - id: the Device ID that can be used to identify the device to other tools, mostly for machine use\n - name: a human-readable name\n - adbSerialNumber: the token to use to identify the device to ADB\n - isConnected: if false, the connect_device tool must be used to activate the device before use\n - isRemote: if true, this device is rented from a device lab and likely costs money to use")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/device/ListDevicesTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/NoArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/android/studio/ml/icons/AndroidToolIcon;", "getIcon", "()Lcom/android/studio/ml/icons/AndroidToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class ListDevicesTool
implements Tool<NoArgs> {
    @NotNull
    public static final ListDevicesTool INSTANCE = new ListDevicesTool();
    @NotNull
    private static final String name = "list_devices";
    @NotNull
    private static final AndroidToolIcon icon = AndroidToolIcon.DEVICE;
    public static final int $stable;

    private ListDevicesTool() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Listing available devices";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Listed available devices";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ToolHandler(context2){
            final /* synthetic */ ToolContext $context;
            {
                this.$context = $context;
            }

            /*
             * WARNING - void declaration
             */
            public Object handle(Continuation<? super Response> $completion) {
                void $this$mapTo$iv$iv;
                ComponentManager $this$service$iv = (ComponentManager)this.$context.getProject();
                boolean $i$f$service = false;
                Class<DeviceProvisionerService> serviceClass$iv = DeviceProvisionerService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                DeviceProvisioner deviceProvisioner = ((DeviceProvisionerService)object).getDeviceProvisioner();
                List<DeviceSnapshot> snapshots = DevicesKt.deviceSnapshots(deviceProvisioner);
                Iterable $this$map$iv = DevicesKt.assignUniqueNames(snapshots);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String name = (String)pair.component1();
                    DeviceSnapshot snapshot = (DeviceSnapshot)pair.component2();
                    collection.add(ListDevicesToolKt.access$toListDevicesOutput(snapshot, name));
                }
                List output = (List)destination$iv$iv;
                return new Response(new Gson().toJson((Object)output), null, null, null, null, 30, null);
            }
        };
    }
}

