/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.device;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.studio.ml.device.AdbShellInputArgs;
import com.android.studio.ml.device.AdbShellInputTool;
import com.android.studio.ml.device.Command;
import com.android.studio.ml.device.DevicesKt;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.android.tools.idea.ui.input.ShellCommandInputProvider;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="This tool invokes `adb shell input <args>` for the currently selected Android device to interact with the current application on the screen", description="\nThe commands and default sources are:\n* text <string> (Default: touchscreen)\n* keyevent [--longpress|--doubletap] <key code number or name> ... (Default: keyboard)\n* tap <x> <y> (Default: touchscreen)\n* swipe <x1> <y1> <x2> <y2> [duration(ms)] (Default: touchscreen)\n* draganddrop <x1> <y1> <x2> <y2> [duration(ms)] (Default: touchscreen)\n* press (Default: trackball)\n* roll <dx> <dy> (Default: trackball)\n* motionevent <DOWN|UP|MOVE|CANCEL> <x> <y> (Default: touchscreen)\n* keycombination <key code 1> <key code 2> ... (Default: keyboard)\n\nKeep in mind input to running application will almost certainly change the UI of the\napplication. Actively check the running device's UI between consecutive input events.\n\nWhen scrolling, SCROLL SLOWLY. Consider scrolling half a page each time based on the device's\nresolution. Navigation with scrolling can require scrolling multiple times. To do that,\nscroll once, check what is shown on the UI of the application, check for the visible UI\nelement and repeat until it is found or we can no longer scroll.\n\nIf you want to input text in a textbox, make sure you click on that textbox first. It is\npossible that the text box has prefilled text in it. If it is not what we are looking for, delete\nthe prefilled text first and then you can use \"input text\" and remember to follow by \"enter\" event\nafterwards.\n\nWhen deleting existing text, delete characters one by one. Do verify that the text box is\nexactly what you expected before continuing.\n\nBefore interacting with an element such as tapping, make sure that the element has nothing on top\nof it. The Android system can draw elements on top each other by listing other elements\nlater in the UI node tree. If that's the case, scroll a bit further to make sure it is no\nlonger covered up by another node's bounding box.\n", examples={})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/studio/ml/device/AdbShellInputTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/device/AdbShellInputArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/android/studio/ml/icons/AndroidToolIcon;", "getIcon", "()Lcom/android/studio/ml/icons/AndroidToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "describe", "pastTense", "", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class AdbShellInputTool
implements Tool<AdbShellInputArgs> {
    @NotNull
    public static final AdbShellInputTool INSTANCE = new AdbShellInputTool();
    @NotNull
    private static final String name = "adb_shell_input";
    @NotNull
    private static final AndroidToolIcon icon = AndroidToolIcon.ADB;
    public static final int $stable;

    private AdbShellInputTool() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull AdbShellInputArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.describe(args, false);
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull AdbShellInputArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.describe(args, true);
    }

    private final String describe(AdbShellInputArgs args, boolean pastTense) {
        return switch (WhenMappings.$EnumSwitchMapping$0[args.getCommand().ordinal()]) {
            case 1 -> (pastTense ? "Entered" : "Entering") + " text into currently focused text field";
            case 2 -> (pastTense ? "Pressed" : "Pressing") + " a hardware or software button";
            case 3 -> (pastTense ? "Tapped" : "Tapping") + " a specific point on the screen";
            case 4 -> (pastTense ? "Swiped" : "Swiping") + " from one coordinate to another";
            case 5 -> (pastTense ? "Executed" : "Executing") + " a drag-and-drop gesture";
            case 6 -> (pastTense ? "Clicked" : "Clicking") + " the trackball";
            case 7 -> (pastTense ? "Rolled" : "Rolling") + " the trackball";
            case 8 -> (pastTense ? "Injected" : "Injecting") + " raw motion data into the input system";
            case 9 -> (pastTense ? "Pressed" : "Pressing") + " multiple keys simultaneously";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull AdbShellInputArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ToolHandler(context2, args){
            final /* synthetic */ ToolContext $context;
            final /* synthetic */ AdbShellInputArgs $args;
            {
                this.$context = $context;
                this.$args = $args;
            }

            /*
             * Unable to fully structure code
             */
            public Object handle(Continuation<? super Response> $completion) {
                if (!($completion instanceof createHandler.handle.1)) ** GOTO lbl-1000
                var4_2 = $completion;
                if ((var4_2.label & -2147483648) != 0) {
                    var4_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        /* synthetic */ Object result;
                        final /* synthetic */ createHandler.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.handle((Continuation<? super Response>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.label = 1;
                        v0 = DevicesKt.currentRunningDevices(this.$context.getProject(), (Continuation<? super List<? extends DeviceHandle>>)$continuation);
                        if (v0 == var5_4) {
                            return var5_4;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        devices = (List)v0;
                        $continuation.label = 2;
                        v1 = DevicesKt.withExactlyOneDevice(devices, (Function2<? super DeviceHandle, ? super Continuation<? super Response>, ? extends Object>)((Function2)new Function2<DeviceHandle, Continuation<? super Response>, Object>(this, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ createHandler.1 this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        DeviceHandle it = (DeviceHandle)this.L$0;
                                        this.label = 1;
                                        Object object3 = createHandler.1.access$handle(this.this$0, it, (Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(DeviceHandle p1, Continuation<? super Response> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<? super Response>)$continuation);
                        if (v1 == var5_4) {
                            return var5_4;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            private final Object handle(DeviceHandle var1_1, Continuation<? super Response> $completion) {
                if (!($completion instanceof createHandler.handle.3)) ** GOTO lbl-1000
                var5_3 = $completion;
                if ((var5_3.label & -2147483648) != 0) {
                    var5_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        /* synthetic */ Object result;
                        final /* synthetic */ createHandler.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return createHandler.1.access$handle(this.this$0, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 /* !! */  = device.getState().getConnectedDevice();
                        if (v0 /* !! */  == null || (v0 /* !! */  = ConnectedDeviceKt.getSerialNumber((ConnectedDevice)v0 /* !! */ )) == null) {
                            return new Response(null, "Device disconnected unexpectedly", null, null, null, 29, null);
                        }
                        serialNumber /* !! */  = v0 /* !! */ ;
                        $continuation.label = 1;
                        v1 = new ShellCommandInputProvider().input(this.$context.getProject(), (String)var3_6, this.$args.getSource().toString(), this.$args.getDisplayId(), this.$args.getCommand().toString(), this.$args.getArgs(), (Continuation)$continuation);
                        if (v1 == var13_5) {
                            return var13_5;
                        }
                        ** GOTO lbl24
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        var6_7 = null;
                        var7_8 = 30;
                        var8_9 = null;
                        var9_10 = null;
                        var10_11 = null;
                        var11_12 = null;
                        var12_13 = (String)v1;
                        return new Response(var12_13, var11_12, var10_11, var9_10, var8_9, var7_8, var6_7);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public static final /* synthetic */ Object access$handle(createHandler.1 $this, DeviceHandle device, Continuation $completion) {
                return $this.handle(device, (Continuation<? super Response>)$completion);
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Command.values().length];
            try {
                nArray[Command.text.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.keyevent.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.tap.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.swipe.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.draganddrop.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.press.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.roll.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.motionevent.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.keycombination.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

