/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.agents.tools;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.designer.compose.preview.agents.tools.ComposePreviewToolArgs;
import com.android.studio.ml.designer.compose.preview.agents.tools.ComposeRenderer;
import com.android.studio.ml.designer.compose.preview.agents.tools.RenderComposePreviewTool;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.render.RenderStatus;
import com.google.aiplugin.agents.tools.render.RenderToolHandler;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Renders a Compose Preview and returns whether the render was successful", description="This tool only compiles the given file before rendering. All other files are assumed to have been successfully compiled from a successful project build.\nAssumes the given file contains the given composable, and that the Composable is annotated with @Preview or a Multipreview annotation.", examples={})
@ToolResult(description="Success, or an error containing the failure reason or render error stack trace")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/tools/RenderComposePreviewTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/designer/compose/preview/agents/tools/ComposePreviewToolArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/android/studio/ml/icons/AndroidToolIcon;", "getIcon", "()Lcom/android/studio/ml/icons/AndroidToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Handler", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class RenderComposePreviewTool
implements Tool<ComposePreviewToolArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final AndroidToolIcon icon = AndroidToolIcon.COMPOSE_PREVIEW;
    public static final int $stable;

    public RenderComposePreviewTool() {
        this.name = "render_compose_preview";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull ComposePreviewToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Rendering Compose preview for " + args.getComposableName();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull ComposePreviewToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Rendered Compose preview for " + args.getComposableName();
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ComposePreviewToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/tools/RenderComposePreviewTool$Handler;", "Lcom/google/aiplugin/agents/tools/render/RenderToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/android/studio/ml/designer/compose/preview/agents/tools/ComposePreviewToolArgs;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/android/studio/ml/designer/compose/preview/agents/tools/ComposePreviewToolArgs;)V", "renderTarget", "", "getRenderTarget", "()Ljava/lang/String;", "_status", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/google/aiplugin/agents/tools/render/RenderStatus;", "renderStatus", "Lkotlinx/coroutines/flow/StateFlow;", "getRenderStatus", "()Lkotlinx/coroutines/flow/StateFlow;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setErrorStatusAndReturnResponse", "errorMessage", "executionStatus", "Lcom/google/aiplugin/agents/Response$ToolExecutionStatus;", "aiplugin.android"})
    private static final class Handler
    implements RenderToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final ComposePreviewToolArgs args;
        @NotNull
        private final String renderTarget;
        @NotNull
        private final MutableStateFlow<RenderStatus> _status;
        @NotNull
        private final StateFlow<RenderStatus> renderStatus;

        public Handler(@NotNull ToolContext context2, @NotNull ComposePreviewToolArgs args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
            this.renderTarget = this.args.getComposableName();
            this._status = StateFlowKt.MutableStateFlow((Object)new RenderStatus.NotStarted());
            MutableStateFlow<RenderStatus> mutableStateFlow = this._status;
            Intrinsics.checkNotNull(mutableStateFlow, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.StateFlow<com.google.aiplugin.agents.tools.render.RenderStatus>");
            this.renderStatus = (StateFlow)mutableStateFlow;
        }

        @Override
        @NotNull
        public String getRenderTarget() {
            return this.renderTarget;
        }

        @Override
        @NotNull
        public StateFlow<RenderStatus> getRenderStatus() {
            return this.renderStatus;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            if (!($completion instanceof handle.1)) ** GOTO lbl-1000
            var8_2 = $completion;
            if ((var8_2.label & -2147483648) != 0) {
                var8_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Handler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handle((Continuation<? super Response>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    project = this.context.getProject();
                    composableName = this.args.getComposableName();
                    v0 = VfsUtil.findFile((Path)Paths.get(this.args.getFilePath(), new String[0]), (boolean)true);
                    if (v0 == null) {
                        return this.setErrorStatusAndReturnResponse("File could not be found", Response.ToolExecutionStatus.ERR_FILE_NOT_FOUND);
                    }
                    virtualFile = v0;
                    $continuation.L$0 = project;
                    $continuation.L$1 = composableName;
                    $continuation.L$2 = virtualFile;
                    $continuation.label = 1;
                    v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handle$lambda$0(com.intellij.openapi.project.Project com.intellij.openapi.vfs.VirtualFile ), ()Ljava/lang/Boolean;)((Project)project, (VirtualFile)virtualFile), (Continuation)$continuation);
                    if (v1 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl32
                }
                case 1: {
                    virtualFile = (VirtualFile)$continuation.L$2;
                    composableName = (String)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl32:
                    // 2 sources

                    if (((Boolean)v1).booleanValue()) {
                        return this.setErrorStatusAndReturnResponse("File blocked by aiexclude", Response.ToolExecutionStatus.ERR_FILE_BLOCKED_BY_AI_EXCLUDE);
                    }
                    this._status.setValue((Object)new RenderStatus.InProgress());
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.label = 2;
                    v2 = ComposeRenderer.render$default(ComposeRenderer.INSTANCE, (Project)var2_5, (String)var3_6, virtualFile, true, false, false, null, null, (Continuation)$continuation, 240, null);
                    if (v2 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl46
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl46:
                    // 2 sources

                    if ((var6_9 = (response = (ComposeRenderer.ComposeRendererResponse)v2)) instanceof ComposeRenderer.ComposeRendererResponse.Error) {
                        v3 = this.setErrorStatusAndReturnResponse(((ComposeRenderer.ComposeRendererResponse.Error)response).getErrorMessage(), Response.ToolExecutionStatus.ERROR_OCCURRED);
                    } else if (var6_9 instanceof ComposeRenderer.ComposeRendererResponse.Success) {
                        this._status.setValue((Object)new RenderStatus.Success(((ComposeRenderer.ComposeRendererResponse.Success)response).getRenderResult().getRenderedImage().getCopy()));
                        v3 = new Response(((ComposeRenderer.ComposeRendererResponse.Success)response).getSuccessMessage(), null, null, null, Response.ToolExecutionStatus.OK, 14, null);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    return v3;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Response setErrorStatusAndReturnResponse(String errorMessage, Response.ToolExecutionStatus executionStatus) {
            this._status.setValue((Object)new RenderStatus.Fail(errorMessage, null, 2, null));
            return new Response(null, errorMessage, null, null, executionStatus, 13, null);
        }

        private static final boolean handle$lambda$0(Project $project, VirtualFile $virtualFile) {
            return AiExcludeService.Companion.getInstance($project).isFileExcluded($virtualFile);
        }
    }
}

