/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.debugger;

import com.android.studio.ml.debugger.ExceptionAwareHandler;
import com.android.studio.ml.debugger.State;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u00a6@\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/debugger/HandlerForSession;", "Lcom/android/studio/ml/debugger/ExceptionAwareHandler;", "project", "Lcom/intellij/openapi/project/Project;", "requiredState", "Lcom/android/studio/ml/debugger/State;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/studio/ml/debugger/State;)V", "handle", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/xdebugger/XDebugSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryHandle", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.android"})
abstract class HandlerForSession
extends ExceptionAwareHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final State requiredState;

    public HandlerForSession(@NotNull Project project2, @NotNull State requiredState) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)requiredState), (String)"requiredState");
        this.project = project2;
        this.requiredState = requiredState;
    }

    @Nullable
    public abstract Object handle(@NotNull XDebugSession var1, @NotNull Continuation<? super String> var2);

    @Override
    @Nullable
    public final Object tryHandle(@NotNull Continuation<? super String> $completion) {
        State state2;
        XDebuggerManager manager = XDebuggerManager.getInstance((Project)this.project);
        XDebugSession xDebugSession = manager.getCurrentSession();
        if (xDebugSession == null) {
            throw new IllegalStateException("There is no debugger session".toString());
        }
        XDebugSession session2 = xDebugSession;
        State state3 = state2 = session2.isPaused() ? State.PAUSED : State.RUNNING;
        if (state2 != this.requiredState) {
            throw new IllegalStateException(("The debugger session is not " + this.requiredState).toString());
        }
        return this.handle(session2, $completion);
    }
}

