/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.debugger;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.debugger.DebuggerStackFrame;
import com.android.studio.ml.debugger.GetStackFramesArgs;
import com.android.studio.ml.debugger.HandlerForSessionKt;
import com.android.studio.ml.debugger.StackFrameCollectorKt;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.xdebugger.XDebugSession;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Gets all stack frames from a paused debugger session as a Json string.", instructions="\n      This tool is part of a group of tools allowing interaction with the debugger. The available\n      tools are:\n        add_line_breakpoint:  Add a breakpoint at a line for code.\n        debugger_pause: Pause a running session.\n        debugger_resume: Resume a paused session.\n        debugger_step Step through the code.\n        deploy:  Start the debugger by deploying in debug mode.\n        evaluate_expression: Evaluate an expression.\n        get_debugger_state:  Check if the debugger is running, paused or not-started.\n        get_frame_variables: Get the variables in a frame.\n        get_stack_frames: Get a list of stack frames of a thread in a paused session.\n        get_threads: Get a list of threads in a paused session.\n        remove_line_breakpoint:  Remove a breakpoint.\n    ", examples={"get_stack_frames(thread = { name=main, group=main, id=1, state=RUNNING })", "get_stack_frames()"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/studio/ml/debugger/GetStackFramesTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/debugger/GetStackFramesArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class GetStackFramesTool
implements Tool<GetStackFramesArgs> {
    @NotNull
    private final String name;
    public static final int $stable;

    public GetStackFramesTool() {
        this.name = "get_stack_frames";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull GetStackFramesArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return HandlerForSessionKt.handleWithPausedSession(context2.getProject(), (Function2<? super XDebugSession, ? super Continuation<? super String>, ? extends Object>)((Function2)new Function2<XDebugSession, Continuation<? super String>, Object>(args, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ GetStackFramesArgs $args;
            {
                this.$args = $args;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        it = (XDebugSession)this.L$0;
                        gson = new GsonBuilder().setPrettyPrinting().create();
                        this.label = 1;
                        v0 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(gson, it, this.$args, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ Gson $gson;
                            final /* synthetic */ XDebugSession $it;
                            final /* synthetic */ GetStackFramesArgs $args;
                            {
                                this.$gson = $gson;
                                this.$it = $it;
                                this.$args = $args;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Gson gson = this.$gson;
                                        this.L$0 = gson;
                                        this.label = 1;
                                        Object object3 = StackFrameCollectorKt.getDebuggerStackFrames(this.$it, this.$args.getThread(), (Continuation<? super List<DebuggerStackFrame>>)((Continuation)this));
                                        if (object3 != object2) return gson.toJson(object3);
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        Gson gson = (Gson)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return gson.toJson(object3);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"withTimeout-KLykuaI(...)");
                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(XDebugSession p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }
}

