/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.debugger;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.debugger.ExceptionAwareHandler;
import com.android.studio.ml.debugger.GetDebuggerStateTool;
import com.android.studio.ml.debugger.GetDebuggerStateToolKt;
import com.google.aiplugin.agents.NoArgs;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Gets the State of The Debugger.", description="\n      Reports if the debugger is running, paused or not-started.\n      If the debugger is paused, the response will also contain the state of the threads in the app.\n    ", instructions="\n      This tool is part of a group of tools allowing interaction with the debugger. The available\n      tools are:\n        add_line_breakpoint:  Add a breakpoint at a line for code.\n        debugger_pause: Pause a running session.\n        debugger_resume: Resume a paused session.\n        debugger_step Step through the code.\n        deploy:  Start the debugger by deploying in debug mode.\n        evaluate_expression: Evaluate an expression.\n        get_debugger_state:  Check if the debugger is running, paused or not-started.\n        get_frame_variables: Get the variables in a frame.\n        get_stack_frames: Get a list of stack frames of a thread in a paused session.\n        get_threads: Get a list of threads in a paused session.\n        remove_line_breakpoint:  Remove a breakpoint.\n    ", examples={})
@ToolResult(description="\n  The state of the debugger for example:\n    {\n      \"state\": \"PAUSED\",\n      \"threads\": {\n        \"threads\": [\n          {\n            \"thread\": {\n              \"name\": \"main\",\n              \"group\": \"main\",\n              \"id\": 1,\n              \"state\": \"RUNNING\"\n            },\n            \"frames\": [\n              {\n                \"file\": \"MainActivity.kt\",\n                \"line\": 43,\n                \"type\": \"com.example.app.MainActivity\",\n                \"method\": \"onCreate\"\n              },\n              ...\n            ]\n          },\n          ...\n        ],\n        \"activeThread\": {\n          \"name\": \"main\",\n          \"group\": \"main\",\n          \"id\": 1,\n          \"state\": \"RUNNING\"\n        }\n      }\n    }\n  ")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/studio/ml/debugger/GetDebuggerStateTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/NoArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class GetDebuggerStateTool
implements Tool<NoArgs> {
    @NotNull
    private final String name;
    public static final int $stable;

    public GetDebuggerStateTool() {
        this.name = "get_debugger_state";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ExceptionAwareHandler(context2){
            private final Gson gson;
            final /* synthetic */ ToolContext $context;
            {
                this.$context = $context;
                this.gson = new GsonBuilder().setPrettyPrinting().create();
            }

            public final Gson getGson() {
                return this.gson;
            }

            /*
             * Unable to fully structure code
             */
            public Object tryHandle(Continuation<? super String> $completion) {
                if (!($completion instanceof createHandler.tryHandle.1)) ** GOTO lbl-1000
                var4_2 = $completion;
                if ((var4_2.label & -2147483648) != 0) {
                    var4_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ createHandler.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.tryHandle((Continuation<? super String>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_5 = this.gson;
                        $continuation.L$0 = var2_5;
                        $continuation.label = 1;
                        v0 = GetDebuggerStateToolKt.access$getDebuggerState(this.$context.getProject(), (Continuation)$continuation);
                        if (v0 == var5_4) {
                            return var5_4;
                        }
                        ** GOTO lbl23
                    }
                    case 1: {
                        var2_5 = (Gson)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl23:
                        // 2 sources

                        return var2_5.toJson(v0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        };
    }
}

