/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.debugger;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.debugger.DebuggerStepArgs;
import com.android.studio.ml.debugger.DebuggerStepToolKt;
import com.android.studio.ml.debugger.HandlerForSessionKt;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.xdebugger.XDebugSession;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Issue a Step command to a paused debugger", description="\n      A Step command can be STEP_INTO, STEP_OVER or STEP_OUT_OF and can only be issued when a\n      debugger is in a Paused state.\n    ", instructions="\n      This tool is part of a group of tools allowing interaction with the debugger. The available\n      tools are:\n        add_line_breakpoint:  Add a breakpoint at a line for code.\n        debugger_pause: Pause a running session.\n        debugger_resume: Resume a paused session.\n        debugger_step Step through the code.\n        deploy:  Start the debugger by deploying in debug mode.\n        evaluate_expression: Evaluate an expression.\n        get_debugger_state:  Check if the debugger is running, paused or not-started.\n        get_frame_variables: Get the variables in a frame.\n        get_stack_frames: Get a list of stack frames of a thread in a paused session.\n        get_threads: Get a list of threads in a paused session.\n        remove_line_breakpoint:  Remove a breakpoint.\n    ", examples={"debugger_step(type=STEP_INTO)", "debugger_step(type=STEP_OVER)", "debugger_step(type=STEP_OUT_OF)"})
@ToolResult(description="\n      Returns confirmation that the step command was sent and includes the current source position\n    ")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/studio/ml/debugger/DebuggerStepTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/debugger/DebuggerStepArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class DebuggerStepTool
implements Tool<DebuggerStepArgs> {
    @NotNull
    private final String name;
    public static final int $stable;

    public DebuggerStepTool() {
        this.name = "debugger_step";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull DebuggerStepArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return HandlerForSessionKt.handleWithPausedSession(context2.getProject(), (Function2<? super XDebugSession, ? super Continuation<? super String>, ? extends Object>)((Function2)new Function2<XDebugSession, Continuation<? super String>, Object>(args, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DebuggerStepArgs $args;
            {
                this.$args = $args;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        XDebugSession it = (XDebugSession)this.L$0;
                        this.label = 1;
                        Object object3 = DebuggerStepToolKt.access$step(it, this.$args.getType(), (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(XDebugSession p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }
}

