/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.timeline;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.ui.compose.timeline.PathStore;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u000eJ \u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003J*\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u0016J8\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u0002H&0%\"\u0004\b\u0000\u0010&*\b\u0012\u0004\u0012\u0002H&0\u0014R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/studio/ml/bot/ui/compose/timeline/PathStore;", "", "maxPaths", "", "(I)V", "filesInRecencyOrder", "Ljava/util/LinkedHashSet;", "Ljava/io/File;", "Lkotlin/collections/LinkedHashSet;", "getMaxPaths", "()I", "setMaxPaths", "nameToFiles", "", "", "", "add", "", "file", "getTrackedFiles", "", "isNotEmpty", "", "matchFilename", "fileName", "string", "start", "end", "matchRelativePath", "ignoreCase", "pathRegionMatches", "str", "strStart", "other", "otherStart", "len", "reversedSequence", "Lkotlin/sequences/Sequence;", "T", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class PathStore {
    private int maxPaths;
    @NotNull
    private final LinkedHashSet<File> filesInRecencyOrder;
    @NotNull
    private final Map<String, List<File>> nameToFiles;
    public static final int $stable = 8;

    public PathStore(int maxPaths) {
        this.maxPaths = maxPaths;
        this.filesInRecencyOrder = new LinkedHashSet();
        this.nameToFiles = new LinkedHashMap();
    }

    public /* synthetic */ PathStore(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 200;
        }
        this(n);
    }

    public final int getMaxPaths() {
        return this.maxPaths;
    }

    public final void setMaxPaths(int n) {
        this.maxPaths = n;
    }

    @NotNull
    public final List<File> getTrackedFiles() {
        return CollectionsKt.toList((Iterable)this.filesInRecencyOrder);
    }

    public final void add(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.filesInRecencyOrder.remove(file);
        this.filesInRecencyOrder.add(file);
        List list = this.nameToFiles.computeIfAbsent(file.getName(), arg_0 -> PathStore.add$lambda$0(add.files.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
        List files2 = list;
        files2.remove(file);
        files2.add(0, file);
        if (this.filesInRecencyOrder.size() > this.maxPaths) {
            List<File> filesForName;
            File oldest = (File)CollectionsKt.first((Iterable)this.filesInRecencyOrder);
            this.filesInRecencyOrder.remove(oldest);
            List<File> list2 = filesForName = this.nameToFiles.get(oldest.getName());
            if (list2 != null) {
                list2.remove(oldest);
            }
            List<File> list3 = filesForName;
            boolean bl = list3 != null ? list3.isEmpty() : false;
            if (bl) {
                this.nameToFiles.remove(oldest.getName());
            }
        }
    }

    @Nullable
    public final File matchFilename(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        List<File> list = this.nameToFiles.get(fileName);
        return list != null ? (File)CollectionsKt.firstOrNull(list) : null;
    }

    @Nullable
    public final File matchFilename(@NotNull String string, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int n = end - 1;
        for (int i2 = start2; i2 < n; ++i2) {
            if (string.charAt(i2) != '.') continue;
            int i3 = end;
            if (string.charAt(i3 - 1) == '.' || string.charAt(i3 - 1) == ':') {
                --i3;
            }
            String string2 = string.substring(start2, i3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String fileName = string2;
            return this.matchFilename(fileName);
        }
        return null;
    }

    @NotNull
    public final <T> Sequence<T> reversedSequence(@NotNull List<? extends T> $this$reversedSequence) {
        Intrinsics.checkNotNullParameter($this$reversedSequence, (String)"<this>");
        Ref.IntRef index = new Ref.IntRef();
        index.element = CollectionsKt.getLastIndex($this$reversedSequence);
        return SequencesKt.generateSequence((Function0)new Function0<T>(index, $this$reversedSequence){
            final /* synthetic */ Ref.IntRef $index;
            final /* synthetic */ List<T> $this_reversedSequence;
            {
                this.$index = $index;
                this.$this_reversedSequence = $receiver;
                super(0);
            }

            public final T invoke() {
                T t;
                if (this.$index.element >= 0) {
                    int n = this.$index.element;
                    this.$index.element = n + -1;
                    t = this.$this_reversedSequence.get(n);
                } else {
                    t = null;
                }
                return t;
            }
        });
    }

    @Nullable
    public final File matchRelativePath(@NotNull String string, int start2, int end, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int i2 = end;
        int n = start2 + 1;
        if (n <= i2) {
            while (true) {
                char c = string.charAt(i2 - 1);
                switch (c) {
                    case '/': 
                    case '\\': {
                        String string2 = string.substring(i2, end);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        String fileName = string2;
                        List<File> list = this.nameToFiles.get(fileName);
                        if (list == null) {
                            return null;
                        }
                        List<File> files2 = list;
                        int length = end - start2;
                        for (File file : files2) {
                            char separator;
                            String path2 = file.getPath();
                            if (path2.length() < length || path2.length() > length && (separator = path2.charAt(path2.length() - length - 1)) != '/' && separator != '\\') continue;
                            Intrinsics.checkNotNull((Object)path2);
                            if (!this.pathRegionMatches(string, start2, path2, path2.length() - length, length, ignoreCase)) continue;
                            return file;
                        }
                        return null;
                    }
                }
                if (i2 == n) break;
                --i2;
            }
        }
        return null;
    }

    public static /* synthetic */ File matchRelativePath$default(PathStore pathStore, String string, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return pathStore.matchRelativePath(string, n, n2, bl);
    }

    private final boolean pathRegionMatches(String str, int strStart, String other, int otherStart, int len, boolean ignoreCase) {
        for (int i2 = 0; i2 < len; ++i2) {
            boolean c2IsSeparator;
            char c1 = str.charAt(strStart + i2);
            char c2 = other.charAt(otherStart + i2);
            boolean c1IsSeparator = c1 == '/' || c1 == '\\';
            boolean bl = c2IsSeparator = c2 == '/' || c2 == '\\';
            if (c1IsSeparator && c2IsSeparator) continue;
            if (c1IsSeparator != c2IsSeparator) {
                return false;
            }
            if (CharsKt.equals((char)c1, (char)c2, (boolean)ignoreCase)) continue;
            return false;
        }
        return true;
    }

    public final boolean isNotEmpty() {
        return !((Collection)this.filesInRecencyOrder).isEmpty();
    }

    private static final List add$lambda$0(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public PathStore() {
        this(0, 1, null);
    }
}

