/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.ui.AvatarType;
import com.android.studio.ml.bot.ui.UserAvatarService;
import com.android.studio.ml.util.SwingUtilKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.RoundedIcon;
import com.intellij.ui.SizedIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import icons.SmlIcons;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0017J\u0014\u0010\u001f\u001a\u00020\u0013*\u00020 2\u0006\u0010\u0002\u001a\u00020!H\u0002R$\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/studio/ml/bot/ui/ProfilePicture;", "Ljavax/swing/JLabel;", "size", "", "disposable", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "avatarType", "Lcom/android/studio/ml/bot/ui/AvatarType;", "(ILcom/intellij/openapi/Disposable;Lkotlinx/coroutines/CoroutineScope;Lcom/android/studio/ml/bot/ui/AvatarType;)V", "value", "getAvatarType", "()Lcom/android/studio/ml/bot/ui/AvatarType;", "setAvatarType", "(Lcom/android/studio/ml/bot/ui/AvatarType;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "rawAvatar", "Ljavax/swing/Icon;", "getMaximumSize", "Ljava/awt/Dimension;", "getMinimumSize", "getPreferredSize", "isOpaque", "", "loadNewIcon", "refreshIcon", "", "setIcon", "icon", "scaleToSize", "Lcom/intellij/openapi/util/ScalableIcon;", "", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nProfilePicture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilePicture.kt\ncom/android/studio/ml/bot/ui/ProfilePicture\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,151:1\n24#2:152\n40#3,3:153\n40#3,3:156\n*S KotlinDebug\n*F\n+ 1 ProfilePicture.kt\ncom/android/studio/ml/bot/ui/ProfilePicture\n*L\n45#1:152\n66#1:153,3\n123#1:156,3\n*E\n"})
public final class ProfilePicture
extends JLabel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    @NotNull
    private final Logger logger;
    @NotNull
    private AvatarType avatarType;
    @Nullable
    private Icon rawAvatar;
    public static final int $stable = 8;
    private static final float SCALE_EPSILON = 1.0E-4f;

    public ProfilePicture(int size, @NotNull Disposable disposable, @NotNull CoroutineScope scope2, final @NotNull AvatarType avatarType) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)((Object)avatarType), (String)"avatarType");
        this.size = size;
        ProfilePicture $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ProfilePicture.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.avatarType = avatarType;
        this.setBorder((Border)JBUI.Borders.empty());
        this.setLayout(null);
        this.refreshIcon();
        SwingUtilKt.afterLaFChanges(disposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                logger.debug("[" + this.hashCode() + "] LaF changed, refreshing icon");
                this.refreshIcon();
                logger.debug("[" + this.hashCode() + "] New raw icon: " + rawAvatar);
            }
        }));
        boolean $i$f$service = false;
        Class<UserAvatarService> serviceClass$iv = UserAvatarService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)FlowKt.onStart((Flow)((Flow)((UserAvatarService)object).getAvatarChanges()), (Function2)((Function2)new Function2<FlowCollector<? super Unit>, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ProfilePicture this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.logger.debug("[" + this.this$0.hashCode() + "] Listening for avatar changes");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(FlowCollector<? super Unit> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ProfilePicture this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.logger.debug("[" + this.this$0.hashCode() + "] Avatar changed, refreshing icon");
                        this.this$0.refreshIcon();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)scope2);
        SwingUtilKt.registerUiInspectorInfoProvider(this, (Function0<? extends Map<String, ? extends Object>>)((Function0)new Function0<Map<String, ? extends Object>>(){

            public final Map<String, Object> invoke() {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"rawAvatar", (Object)rawAvatar), TuplesKt.to((Object)"debugIdentifier", (Object)this.hashCode()), TuplesKt.to((Object)"avatarType", (Object)((Object)avatarType)), TuplesKt.to((Object)"size", (Object)size)};
                return MapsKt.mapOf((Pair[])pairArray);
            }
        }));
    }

    public /* synthetic */ ProfilePicture(int n, Disposable disposable, CoroutineScope coroutineScope, AvatarType avatarType, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            avatarType = AvatarType.Bot;
        }
        this(n, disposable, coroutineScope, avatarType);
    }

    @NotNull
    public final AvatarType getAvatarType() {
        return this.avatarType;
    }

    public final void setAvatarType(@NotNull AvatarType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.avatarType = value;
        this.logger.debug("[" + this.hashCode() + "] Avatar type set to " + value.name());
        this.refreshIcon();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return (Dimension)new JBDimension(this.size, this.size);
    }

    private final void refreshIcon() {
        Icon icon2;
        Icon newIcon = this.loadNewIcon();
        this.logger.debug("[" + this.hashCode() + "] refreshIcon(): newIcon is " + newIcon);
        if (newIcon instanceof ScalableIcon) {
            float tweakedSize = (float)this.size - 1.0E-4f;
            icon2 = this.scaleToSize((ScalableIcon)newIcon, tweakedSize);
        } else {
            icon2 = (Icon)new SizedIcon(newIcon, this.size, this.size);
        }
        Icon resizedIcon = icon2;
        RoundedIcon roundedIcon = !(resizedIcon instanceof RoundedIcon) ? new RoundedIcon(resizedIcon, 1.0) : (RoundedIcon)resizedIcon;
        this.rawAvatar = newIcon;
        super.setIcon((Icon)roundedIcon);
    }

    private final Icon loadNewIcon() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.avatarType.ordinal()]) {
            case 1 -> {
                boolean $i$f$service = false;
                Class<UserAvatarService> serviceClass$iv = UserAvatarService.class;
                Object v0 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (v0 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                yield ((UserAvatarService)v0).getUserAvatar();
            }
            case 2 -> {
                if (this.size > SmlIcons.BotAvatar.getIconWidth()) {
                    yield SmlIcons.BotAvatarLarge;
                }
                yield SmlIcons.BotAvatar;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @Deprecated(message="The icon is derived from the avatarType, don't set it directly", replaceWith=@ReplaceWith(expression="avatarType = AvatarType.User", imports={}), level=DeprecationLevel.ERROR)
    public void setIcon(@Nullable Icon icon2) {
        if (icon2 != null) {
            throw new UnsupportedOperationException("The icon is derived from the avatarType, don't set it directly");
        }
    }

    private final Icon scaleToSize(ScalableIcon $this$scaleToSize, float size) {
        Icon icon2;
        if (Math.abs(size - (float)$this$scaleToSize.getIconWidth()) > 1.0E-4f) {
            Icon icon3 = $this$scaleToSize.scale(size / (float)$this$scaleToSize.getIconWidth());
            Intrinsics.checkNotNull((Object)icon3);
            icon2 = icon3;
        } else {
            icon2 = (Icon)$this$scaleToSize;
        }
        return icon2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/studio/ml/bot/ui/ProfilePicture$Companion;", "", "()V", "SCALE_EPSILON", "", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AvatarType.values().length];
            try {
                nArray[AvatarType.User.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AvatarType.Bot.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

