/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.testgeneration;

import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.UtilsKt;
import com.android.studio.ml.bot.testgeneration.BaseScenarioPromptBuilderKt;
import com.android.studio.ml.bot.testgeneration.TestScenarioPromptBuilder;
import com.android.tools.idea.studiobot.MimeType;
import com.android.tools.idea.studiobot.mimetype.MimeTypeUtilsKt;
import com.android.tools.idea.studiobot.prompts.PromptBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/studio/ml/bot/testgeneration/BaseScenarioPromptBuilder;", "Lcom/android/studio/ml/bot/testgeneration/TestScenarioPromptBuilder;", "<init>", "()V", "testScenarioPrompt", "", "promptInput", "Lcom/android/studio/ml/bot/testgeneration/TestScenarioPromptBuilder$TestScenarioPromptInput;", "aiplugin.lang.kotlin"})
@SourceDebugExtension(value={"SMAP\nBaseScenarioPromptBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseScenarioPromptBuilder.kt\ncom/android/studio/ml/bot/testgeneration/BaseScenarioPromptBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,156:1\n1137#2,2:157\n*S KotlinDebug\n*F\n+ 1 BaseScenarioPromptBuilder.kt\ncom/android/studio/ml/bot/testgeneration/BaseScenarioPromptBuilder\n*L\n63#1:157,2\n*E\n"})
public final class BaseScenarioPromptBuilder
implements TestScenarioPromptBuilder {
    @Override
    public void testScenarioPrompt(@NotNull TestScenarioPromptBuilder.TestScenarioPromptInput promptInput) {
        Intrinsics.checkNotNullParameter((Object)promptInput, (String)"promptInput");
        PromptBuilder promptBuilder = promptInput.getPromptBuilder();
        Project project2 = promptInput.getProject();
        PsiDirectory destinationDirectory = promptInput.getDestinationDirectory();
        List<String> selectedMethods = promptInput.getSelectedMethods();
        boolean mergeWithExistingTests = promptInput.getMergeWithExistingTests();
        String destinationClassName = promptInput.getDestinationClassName();
        PsiClass containingClass = promptInput.getContainingClass();
        String language2 = promptInput.getLanguage-i_3W7CY();
        Function5<Project, String, Boolean, String, String, Object> errorLogger = promptInput.getErrorLogger();
        String errorTitle = SmlBundle.message("sml.studiobot.testGeneration.notification.title", new Object[0]);
        promptBuilder.systemMessage((Function1<? super PromptBuilder.MessageBuilder, Unit>)((Function1)BaseScenarioPromptBuilder::testScenarioPrompt$lambda$0));
        promptBuilder.userMessage((Function1<? super PromptBuilder.UserMessageBuilder, Unit>)((Function1)arg_0 -> BaseScenarioPromptBuilder.testScenarioPrompt$lambda$1(language2, errorLogger, project2, errorTitle, selectedMethods, containingClass, mergeWithExistingTests, destinationDirectory, destinationClassName, arg_0)));
    }

    private static final Unit testScenarioPrompt$lambda$0(PromptBuilder.MessageBuilder $this$systemMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$systemMessage, (String)"$this$systemMessage");
        PromptBuilder.MessageBuilder.text$default($this$systemMessage, BaseScenarioPromptBuilderKt.access$getTEST_SCENARIO_GENERATION_PROMPT$p(), CollectionsKt.emptyList(), null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit testScenarioPrompt$lambda$1(String $language, Function5 $errorLogger, Project $project, String $errorTitle, List $selectedMethods, PsiClass $containingClass, boolean $mergeWithExistingTests, PsiDirectory $destinationDirectory, String $destinationClassName, PromptBuilder.UserMessageBuilder $this$userMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$userMessage, (String)"$this$userMessage");
        String languageName = MimeTypeUtilsKt.markdownLanguageName-qru2Y28($language);
        if (languageName == null) {
            $errorLogger.invoke((Object)$project, (Object)(MimeType.toString-impl($language) + " does not have a valid markdown language name"), (Object)true, (Object)$errorTitle, (Object)"");
            return Unit.INSTANCE;
        }
        PromptBuilder.MessageBuilder.text$default($this$userMessage, (String)BaseScenarioPromptBuilderKt.access$getTEST_SCENARIO_PREFIX$p().invoke((Object)languageName, (Object)$selectedMethods), CollectionsKt.emptyList(), null, 4, null);
        PromptBuilder.MessageBuilder messageBuilder = $this$userMessage;
        String string = $containingClass.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Language language2 = $containingClass.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        PromptBuilder.MessageBuilder.code-caxhWIk$default(messageBuilder, string, MimeTypeUtilsKt.fromLanguage$default(MimeType.Companion, language2, null, null, 6, null), CollectionsKt.listOf((Object)$containingClass.getContainingFile().getVirtualFile()), null, 8, null);
        if ($mergeWithExistingTests) {
            PromptBuilder.MessageBuilder.text$default($this$userMessage, BaseScenarioPromptBuilderKt.access$getMERGE_WITH_EXISTING_PREFIX$p(), CollectionsKt.emptyList(), null, 4, null);
            try {
                Object element$iv2;
                block8: {
                    VirtualFile[] virtualFileArray = $destinationDirectory.getVirtualFile().getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                    Object[] $this$first$iv = virtualFileArray;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        VirtualFile it = (VirtualFile)element$iv2;
                        boolean bl = false;
                        String string2 = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)$destinationClassName, (boolean)false, (int)2, null)) {
                            continue;
                        }
                        break block8;
                    }
                    throw new NoSuchElementException("Array contains no element matching the predicate.");
                }
                VirtualFile testClass = (VirtualFile)element$iv2;
                Intrinsics.checkNotNull((Object)testClass);
                PsiFile testPsiFile = UtilsKt.getPsiFile(testClass, $project);
                if (testPsiFile == null) {
                    $errorLogger.invoke((Object)$project, (Object)("Failed to process PSI for class " + testClass.getName()), (Object)true, (Object)$errorTitle, (Object)"");
                    return Unit.INSTANCE;
                }
                PromptBuilder.MessageBuilder messageBuilder2 = $this$userMessage;
                String string3 = testPsiFile.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                PromptBuilder.MessageBuilder.code-caxhWIk$default(messageBuilder2, string3, null, CollectionsKt.listOf((Object)testClass), null, 8, null);
            }
            catch (Exception e) {
                String string4 = "Error reading from " + $destinationClassName;
                Boolean bl = true;
                String string5 = e.getMessage();
                if (string5 == null) {
                    string5 = "";
                }
                $errorLogger.invoke((Object)$project, (Object)string4, (Object)bl, (Object)$errorTitle, (Object)string5);
                return Unit.INSTANCE;
            }
        }
        PromptBuilder.MessageBuilder.text$default($this$userMessage, BaseScenarioPromptBuilderKt.access$getPROMPT_ENDING$p(), CollectionsKt.emptyList(), null, 4, null);
        return Unit.INSTANCE;
    }
}

