/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.configuration;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ModelProvider;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.configuration.ContextSharingMode;
import com.android.studio.ml.bot.configuration.StudioBotAppSettings;
import com.android.studio.ml.bot.configuration.StudioBotConfigurable;
import com.android.studio.ml.bot.configuration.StudioBotProjectSettings;
import com.android.studio.ml.bot.configuration.StudioBotProjectSettingsImpl;
import com.android.studio.ml.bot.ui.onboarding.OnboardingProvider;
import com.android.studio.ml.bot.ui.onboarding.OnboardingState;
import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import icons.SmlIcons;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/bot/configuration/NotifyUserToShareContextActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showNotificationIfNecessary", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNotifyUserToShareContextActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotifyUserToShareContextActivity.kt\ncom/android/studio/ml/bot/configuration/NotifyUserToShareContextActivity\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,106:1\n24#2:107\n40#3,3:108\n30#4,2:111\n*S KotlinDebug\n*F\n+ 1 NotifyUserToShareContextActivity.kt\ncom/android/studio/ml/bot/configuration/NotifyUserToShareContextActivity\n*L\n34#1:107\n55#1:108,3\n61#1:111,2\n*E\n"})
public final class NotifyUserToShareContextActivity
implements ProjectActivity {
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;

    public NotifyUserToShareContextActivity() {
        NotifyUserToShareContextActivity $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(NotifyUserToShareContextActivity.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Nullable
    public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
        this.logger.debug("Checking the need to prompt about context sharing for " + project2.getName());
        this.showNotificationIfNecessary(project2);
        return Unit.INSTANCE;
    }

    private final void showNotificationIfNecessary(Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.logger.info("Not showing prompt for " + project2.getName() + ": in unit test mode");
            return;
        }
        OnboardingProvider onboardingProvider2 = ModelProvider.Companion.activeModelProvider().createOnboardingProvider(project2);
        if (onboardingProvider2.getOnboardingState().getCurrentState().getValue() != OnboardingState.State.ONBOARDED) {
            this.logger.info("Not showing prompt for " + project2.getName() + ": onboarding visible");
            return;
        }
        boolean $i$f$service = false;
        Class<StudioBotAppSettings> serviceClass$iv = StudioBotAppSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ContextSharingMode sharingMode = ((StudioBotAppSettings)object).getContextSharingMode();
        if (sharingMode != ContextSharingMode.AskPerProject) {
            this.logger.info("Not showing prompt for " + project2.getName() + ": context sharing mode is " + sharingMode);
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service2 = false;
        Class<StudioBotProjectSettings> serviceClass$iv2 = StudioBotProjectSettings.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv2);
        }
        StudioBotProjectSettings projectSettings = (StudioBotProjectSettings)object2;
        StudioBotProjectSettingsImpl.ProjectContextSharing projectSharing = projectSettings.getProjectContextSharing();
        if (projectSharing != StudioBotProjectSettingsImpl.ProjectContextSharing.Unknown) {
            this.logger.info("Not showing prompt for " + project2.getName() + ": project sharing mode is " + projectSharing);
            return;
        }
        this.logger.info("Showing prompt for " + project2.getName() + "...");
        NotificationGroupManager.getInstance().getNotificationGroup("Gemini - Select context sharing setting").createNotification(SmlBundle.message("sml.studiobot.settings.codeSharing.notification.text", new Object[0]), NotificationType.INFORMATION).setImportant(true).setTitle(SmlBundle.message("sml.studiobot.settings.codeSharing.notification.title", new Object[0])).setIcon(SmlIcons.BotToolWindow).addAction((AnAction)NotificationAction.create((String)SmlBundle.message("sml.studiobot.settings.codeSharing.notification.yes", new Object[0]), (arg_0, arg_1) -> NotifyUserToShareContextActivity.showNotificationIfNecessary$lambda$0((Function2)new Function2<AnActionEvent, Notification, Unit>(projectSettings){
            final /* synthetic */ StudioBotProjectSettings $projectSettings;
            {
                this.$projectSettings = $projectSettings;
                super(2);
            }

            public final void invoke(AnActionEvent anActionEvent, Notification notification) {
                this.$projectSettings.setProjectContextSharing(StudioBotProjectSettingsImpl.ProjectContextSharing.OptedIn);
                notification.hideBalloon();
            }
        }, arg_0, arg_1))).addAction((AnAction)NotificationAction.create((String)SmlBundle.message("sml.studiobot.settings.codeSharing.notification.no", new Object[0]), (arg_0, arg_1) -> NotifyUserToShareContextActivity.showNotificationIfNecessary$lambda$1((Function2)new Function2<AnActionEvent, Notification, Unit>(projectSettings){
            final /* synthetic */ StudioBotProjectSettings $projectSettings;
            {
                this.$projectSettings = $projectSettings;
                super(2);
            }

            public final void invoke(AnActionEvent anActionEvent, Notification notification) {
                this.$projectSettings.setProjectContextSharing(StudioBotProjectSettingsImpl.ProjectContextSharing.OptedOut);
                notification.hideBalloon();
            }
        }, arg_0, arg_1))).addAction((AnAction)NotificationAction.create((String)SmlBundle.message("sml.studiobot.settings.codeSharing.notification.configure", new Object[0]), (arg_0, arg_1) -> NotifyUserToShareContextActivity.showNotificationIfNecessary$lambda$2((Function2)new Function2<AnActionEvent, Notification, Unit>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2);
            }

            public final void invoke(AnActionEvent anActionEvent, Notification notification) {
                notification.hideBalloon();
                ShowSettingsUtil.getInstance().showSettingsDialog(this.$project, StudioBotConfigurable.class);
            }
        }, arg_0, arg_1))).notify(project2);
    }

    private static final void showNotificationIfNecessary$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void showNotificationIfNecessary$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void showNotificationIfNecessary$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

