/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.action;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.action.CodeSelectionExtractor;
import com.android.studio.ml.bot.action.CodeSelectionUtils;
import com.android.tools.idea.studiobot.MimeType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/bot/action/XmlCodeSelectionExtractor;", "Lcom/android/studio/ml/bot/action/CodeSelectionExtractor;", "()V", "languages", "", "Lcom/android/tools/idea/studiobot/MimeType;", "getLanguages", "()Ljava/util/List;", "extractSurroundingPsiElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractSurroundingXmlTags", "getApplicableCodeFrom", "", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nXmlCodeSelectionExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlCodeSelectionExtractor.kt\ncom/android/studio/ml/bot/action/XmlCodeSelectionExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1#2:143\n774#3:144\n865#3,2:145\n*S KotlinDebug\n*F\n+ 1 XmlCodeSelectionExtractor.kt\ncom/android/studio/ml/bot/action/XmlCodeSelectionExtractor\n*L\n119#1:144\n119#1:145,2\n*E\n"})
public final class XmlCodeSelectionExtractor
implements CodeSelectionExtractor {
    @NotNull
    private final List<MimeType> languages = CollectionsKt.listOf((Object)MimeType.box-impl(MimeType.Companion.getXML-i_3W7CY()));
    public static final int $stable = 8;

    @Override
    @NotNull
    public List<MimeType> getLanguages() {
        return this.languages;
    }

    @Override
    @Nullable
    public String getApplicableCodeFrom(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        String selectedText = CodeSelectionUtils.INSTANCE.getSelectedTextOrNull(editor2);
        CharSequence charSequence = selectedText;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string;
            PsiElement element = this.extractSurroundingPsiElement(editor2);
            Object object = element;
            if (object != null && (object = object.getText()) != null) {
                Object it = object;
                boolean bl = false;
                string = CodeSelectionUtils.INSTANCE.removeIndentFrom((String)it);
            } else {
                string = null;
            }
            return string;
        }
        return selectedText;
    }

    @Override
    @Nullable
    public PsiElement extractSurroundingPsiElement(@NotNull Editor editor2) {
        PsiElement element;
        PsiElement target;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (CodeSelectionUtils.INSTANCE.getCurrentElement(editor2) == null) {
            return null;
        }
        for (target = element = (v195975); target != null && !(target instanceof XmlTag) && !(target instanceof PsiFile); target = target.getParent()) {
        }
        return target;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiElement> extractSurroundingXmlTags(@NotNull Editor editor2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return CollectionsKt.emptyList();
        }
        Project project3 = project2;
        VirtualFile virtualFile2 = editor2.getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile3 = virtualFile2;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project3).findFile(virtualFile3);
        if (!(psiFile2 instanceof XmlFile)) {
            return CollectionsKt.emptyList();
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        int startOffset = selectionModel2.getSelectionStart();
        int endOffset = selectionModel2.getSelectionEnd();
        int selectionStart = startOffset;
        int selectionEnd = startOffset == endOffset ? startOffset + 1 : endOffset;
        int fileLength = editor2.getDocument().getTextLength();
        int adjustedSelectionEnd = RangesKt.coerceAtMost((int)selectionEnd, (int)fileLength);
        TextRange selectionRange = new TextRange(selectionStart, adjustedSelectionEnd);
        PsiElement startElement = psiFile2.findElementAt(selectionStart);
        PsiElement endElement = psiFile2.findElementAt(RangesKt.coerceAtLeast((int)(adjustedSelectionEnd - 1), (int)selectionStart));
        if (startElement != null && endElement != null) {
            psiElement = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
            if (psiElement == null) {
                psiElement = (PsiElement)psiFile2;
            }
        } else {
            psiElement = (PsiElement)psiFile2;
        }
        PsiElement commonAncestor = psiElement;
        Object object = new Class[]{XmlTag.class};
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)commonAncestor, (Class[])object);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectElementsOfType(...)");
        Collection tags = collection;
        object = tags;
        boolean $i$f$filter = false;
        void var20_19 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XmlTag tag = (XmlTag)element$iv$iv;
            boolean bl = false;
            TextRange tagRange = tag.getTextRange();
            if (!(tagRange.getStartOffset() < selectionRange.getEndOffset() && tagRange.getEndOffset() > selectionRange.getStartOffset())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List overlappingTags = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (!((Collection)overlappingTags).isEmpty()) {
            return overlappingTags;
        }
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)commonAncestor, XmlTag.class, (boolean)false);
        if (parentTag != null && parentTag.getTextRange().contains(selectionRange)) {
            return CollectionsKt.listOf((Object)parentTag);
        }
        return CollectionsKt.emptyList();
    }
}

