/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.backends.openai;

import com.android.studio.ml.backends.ChatApi;
import com.android.studio.ml.backends.openai.ErrorType;
import com.android.studio.ml.backends.openai.OpenAiChatImpl;
import com.android.studio.ml.backends.openai.OpenAiCompletionApi;
import com.android.studio.ml.backends.openai.OpenAiResponsesApi;
import com.android.studio.ml.backends.openai.OpenAiToolsKt;
import com.android.tools.idea.studiobot.Content;
import com.android.tools.idea.studiobot.GenerationConfig;
import com.android.tools.idea.studiobot.ModelConfig;
import com.android.tools.idea.studiobot.prompts.Prompt;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.stream.MalformedJsonException;
import com.openai.client.OpenAIClientAsync;
import com.openai.core.http.AsyncStreamResponse;
import com.openai.errors.BadRequestException;
import com.openai.errors.NotFoundException;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionChunk;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.models.responses.ResponseCreateParams;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 32\u00020\u0001:\u00013B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\u000b\u0010\fJ.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0015\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0001\u00a2\u0006\u0002\b$J.\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0005H\u0002J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0005H\u0002J&\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J&\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\"\u0010*\u001a\b\u0012\u0004\u0012\u0002H+0\u0018\"\u0004\b\u0000\u0010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0-H\u0002J\"\u0010.\u001a\u0002H+\"\u0004\b\u0000\u0010+2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H+00H\u0086@\u00a2\u0006\u0002\u00101J\"\u0010*\u001a\b\u0012\u0004\u0012\u0002H+0\u0018\"\u0004\b\u0000\u0010+2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H+00H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0011\u001aB\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00050\u0005 \u0014* \u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0015\u001aB\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00050\u0005 \u0014* \u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0016\u001aB\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00050\u0005 \u0014* \u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/studio/ml/backends/openai/OpenAiChatImpl;", "Lcom/android/studio/ml/backends/ChatApi;", "client", "Lcom/openai/client/OpenAIClientAsync;", "forceRequireAllToolParameters", "", "addToolParametersEvenIfEmpty", "includeToolInRequest", "Lkotlin/Function2;", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Function;", "Lcom/android/tools/idea/studiobot/ModelConfig;", "<init>", "(Lcom/openai/client/OpenAIClientAsync;ZZLkotlin/jvm/functions/Function2;)V", "completionApi", "Lcom/android/studio/ml/backends/openai/OpenAiCompletionApi;", "responsesApi", "Lcom/android/studio/ml/backends/openai/OpenAiResponsesApi;", "nonStreamingModels", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "", "kotlin.jvm.PlatformType", "responsesApiModels", "systemMessageModels", "generateContent", "Lkotlinx/coroutines/flow/Flow;", "Lcom/android/tools/idea/studiobot/Content;", "modelId", "prompt", "Lcom/android/tools/idea/studiobot/prompts/Prompt;", "modelConfig", "config", "Lcom/android/tools/idea/studiobot/GenerationConfig;", "detectErrorType", "Lcom/android/studio/ml/backends/openai/ErrorType;", "e", "", "detectErrorType$aiplugin_backends_third_party", "generateWithCompletionStreaming", "useSystemMessage", "generateWithCompletionBlocking", "generateWithResponsesStreaming", "generateWithResponsesBlocking", "toFlow", "T", "streamResponse", "Lcom/openai/core/http/AsyncStreamResponse;", "awaitCompletableFuture", "future", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/util/concurrent/CompletableFuture;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "responseFuture", "Companion", "aiplugin.backends.third-party"})
@SourceDebugExtension(value={"SMAP\nOpenAiChatImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiChatImpl.kt\ncom/android/studio/ml/backends/openai/OpenAiChatImpl\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,295:1\n426#2,11:296\n*S KotlinDebug\n*F\n+ 1 OpenAiChatImpl.kt\ncom/android/studio/ml/backends/openai/OpenAiChatImpl\n*L\n234#1:296,11\n*E\n"})
public final class OpenAiChatImpl
implements ChatApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OpenAIClientAsync client;
    @NotNull
    private final OpenAiCompletionApi completionApi;
    @NotNull
    private final OpenAiResponsesApi responsesApi;
    private final ConcurrentHashMap.KeySetView<String, Boolean> nonStreamingModels;
    private final ConcurrentHashMap.KeySetView<String, Boolean> responsesApiModels;
    private final ConcurrentHashMap.KeySetView<String, Boolean> systemMessageModels;
    @NotNull
    private static final Gson GSON;
    @NotNull
    private static final Regex INVALID_ROLE_ERROR_PATTERN;

    public OpenAiChatImpl(@NotNull OpenAIClientAsync client2, boolean forceRequireAllToolParameters, boolean addToolParametersEvenIfEmpty, @NotNull Function2<? super Prompt.Function, ? super ModelConfig, Boolean> includeToolInRequest) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter(includeToolInRequest, (String)"includeToolInRequest");
        this.client = client2;
        this.completionApi = new OpenAiCompletionApi(forceRequireAllToolParameters, addToolParametersEvenIfEmpty, includeToolInRequest);
        this.responsesApi = new OpenAiResponsesApi(forceRequireAllToolParameters, includeToolInRequest);
        this.nonStreamingModels = ConcurrentHashMap.newKeySet();
        this.responsesApiModels = ConcurrentHashMap.newKeySet();
        this.systemMessageModels = ConcurrentHashMap.newKeySet();
    }

    public /* synthetic */ OpenAiChatImpl(OpenAIClientAsync openAIClientAsync, boolean bl, boolean bl2, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            function2 = OpenAiChatImpl::_init_$lambda$0;
        }
        this(openAIClientAsync, bl, bl2, (Function2<? super Prompt.Function, ? super ModelConfig, Boolean>)function2);
    }

    @Override
    @NotNull
    public Flow<Content> generateContent(@NotNull String modelId, @NotNull Prompt prompt2, @NotNull ModelConfig modelConfig, @NotNull GenerationConfig config2) {
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)modelConfig, (String)"modelConfig");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        boolean nonStreamingModel = this.nonStreamingModels.contains(modelId);
        boolean responsesAPIModel = this.responsesApiModels.contains(modelId);
        boolean useSystemMessage = this.systemMessageModels.contains(modelId);
        return FlowKt.catch(nonStreamingModel && responsesAPIModel ? this.generateWithResponsesBlocking(modelId, prompt2, modelConfig) : (nonStreamingModel && !responsesAPIModel ? this.generateWithCompletionBlocking(modelId, prompt2, modelConfig, useSystemMessage) : (!nonStreamingModel && responsesAPIModel ? this.generateWithResponsesStreaming(modelId, prompt2, modelConfig) : this.generateWithCompletionStreaming(modelId, prompt2, modelConfig, useSystemMessage))), (Function3)((Function3)new Function3<FlowCollector<? super Content>, Throwable, Continuation<? super Unit>, Object>(this, nonStreamingModel, modelId, prompt2, modelConfig, config2, responsesAPIModel, useSystemMessage, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ OpenAiChatImpl this$0;
            final /* synthetic */ boolean $nonStreamingModel;
            final /* synthetic */ String $modelId;
            final /* synthetic */ Prompt $prompt;
            final /* synthetic */ ModelConfig $modelConfig;
            final /* synthetic */ GenerationConfig $config;
            final /* synthetic */ boolean $responsesAPIModel;
            final /* synthetic */ boolean $useSystemMessage;
            {
                this.this$0 = $receiver;
                this.$nonStreamingModel = $nonStreamingModel;
                this.$modelId = $modelId;
                this.$prompt = $prompt;
                this.$modelConfig = $modelConfig;
                this.$config = $config;
                this.$responsesAPIModel = $responsesAPIModel;
                this.$useSystemMessage = $useSystemMessage;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                block9: {
                    Throwable e;
                    block11: {
                        void $result;
                        ErrorType errorType;
                        FlowCollector $this$catch;
                        Object object2;
                        block10: {
                            object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    $this$catch = (FlowCollector)this.L$0;
                                    e = (Throwable)this.L$1;
                                    errorType = this.this$0.detectErrorType$aiplugin_backends_third_party(e);
                                    if (errorType != ErrorType.STREAMING_NOT_SUPPORTED || this.$nonStreamingModel) break;
                                    OpenAiChatImpl.access$getNonStreamingModels$p(this.this$0).add(this.$modelId);
                                    this.L$0 = null;
                                    this.label = 1;
                                    Object object3 = FlowKt.emitAll((FlowCollector)$this$catch, this.this$0.generateContent(this.$modelId, this.$prompt, this.$modelConfig, this.$config), (Continuation)((Continuation)this));
                                    if (object3 == object2) {
                                        return object2;
                                    }
                                    break block9;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    break block9;
                                }
                            }
                            if (errorType != ErrorType.COMPLETION_NOT_SUPPORTED || this.$responsesAPIModel) break block10;
                            OpenAiChatImpl.access$getResponsesApiModels$p(this.this$0).add(this.$modelId);
                            this.L$0 = null;
                            this.label = 2;
                            Object object4 = FlowKt.emitAll((FlowCollector)$this$catch, this.this$0.generateContent(this.$modelId, this.$prompt, this.$modelConfig, this.$config), (Continuation)((Continuation)this));
                            if (object4 == object2) {
                                return object2;
                            }
                            break block9;
                            {
                                case 2: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    object4 = $result;
                                    break block9;
                                }
                            }
                        }
                        if (errorType != ErrorType.INVALID_MESSAGE_ROLE || this.$useSystemMessage) break block11;
                        OpenAiChatImpl.access$getSystemMessageModels$p(this.this$0).add(this.$modelId);
                        this.L$0 = null;
                        this.label = 3;
                        Object object5 = FlowKt.emitAll((FlowCollector)$this$catch, this.this$0.generateContent(this.$modelId, this.$prompt, this.$modelConfig, this.$config), (Continuation)((Continuation)this));
                        if (object5 == object2) {
                            return object2;
                        }
                        break block9;
                        {
                            case 3: {
                                ResultKt.throwOnFailure((Object)$result);
                                object5 = $result;
                                break block9;
                            }
                        }
                    }
                    throw e;
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(FlowCollector<? super Content> p1, Throwable p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @VisibleForTesting
    @NotNull
    public final ErrorType detectErrorType$aiplugin_backends_third_party(@NotNull Throwable e) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Throwable cause = e;
        while (cause instanceof CompletionException && ((CompletionException)cause).getCause() != null && !Intrinsics.areEqual((Object)((CompletionException)cause).getCause(), (Object)cause)) {
            cause = ((CompletionException)cause).getCause();
        }
        Throwable throwable = cause;
        BadRequestException badRequestException = throwable instanceof BadRequestException ? (BadRequestException)throwable : null;
        if (badRequestException != null) {
            it = badRequestException;
            boolean bl = false;
            String string = it.getMessage();
            boolean bl2 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"must be verified to stream", (boolean)false, (int)2, null) : false;
            if (bl2) {
                return ErrorType.STREAMING_NOT_SUPPORTED;
            }
            String string2 = it.getMessage();
            if (string2 != null) {
                String message = string2;
                boolean bl3 = false;
                if (INVALID_ROLE_ERROR_PATTERN.matches((CharSequence)message)) {
                    return ErrorType.INVALID_MESSAGE_ROLE;
                }
            }
        }
        throwable = cause;
        NotFoundException notFoundException = throwable instanceof NotFoundException ? (NotFoundException)throwable : null;
        if (notFoundException != null) {
            it = notFoundException;
            boolean bl = false;
            String string = it.getMessage();
            boolean bl4 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"model is only supported in v1/responses", (boolean)false, (int)2, null) : false;
            if (bl4) {
                return ErrorType.COMPLETION_NOT_SUPPORTED;
            }
            String string3 = it.getMessage();
            boolean bl5 = string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)"not supported in the v1/chat/completions endpoint. Did you mean to use v1/completions?", (boolean)false, (int)2, null) : false;
            if (bl5) {
                return ErrorType.COMPLETION_NOT_SUPPORTED;
            }
        }
        return ErrorType.OTHER;
    }

    private final Flow<Content> generateWithCompletionStreaming(String modelId, Prompt prompt2, ModelConfig modelConfig, boolean useSystemMessage) {
        ChatCompletionCreateParams request2 = this.completionApi.createParams(modelId, prompt2, modelConfig, useSystemMessage);
        AsyncStreamResponse streamResponse = this.client.chat().completions().createStreaming(request2);
        return this.completionApi.assembleResponseChunks((Flow<ChatCompletionChunk>)FlowKt.flowOn(this.toFlow(streamResponse), (CoroutineContext)((CoroutineContext)Dispatchers.getIO())));
    }

    private final Flow<Content> generateWithCompletionBlocking(String modelId, Prompt prompt2, ModelConfig modelConfig, boolean useSystemMessage) {
        ChatCompletionCreateParams request2 = this.completionApi.createParams(modelId, prompt2, modelConfig, useSystemMessage);
        CompletableFuture response2 = this.client.chat().completions().create(request2);
        return this.completionApi.processResponse((Flow<ChatCompletion>)FlowKt.flowOn(this.toFlow(response2), (CoroutineContext)((CoroutineContext)Dispatchers.getIO())));
    }

    private final Flow<Content> generateWithResponsesStreaming(String modelId, Prompt prompt2, ModelConfig modelConfig) {
        ResponseCreateParams params = this.responsesApi.createParams(modelId, prompt2, modelConfig);
        AsyncStreamResponse streamResponse = this.client.responses().createStreaming(params);
        return this.responsesApi.assembleResponseChunks(this.toFlow(streamResponse));
    }

    private final Flow<Content> generateWithResponsesBlocking(String modelId, Prompt prompt2, ModelConfig modelConfig) {
        ResponseCreateParams params = this.responsesApi.createParams(modelId, prompt2, modelConfig);
        CompletableFuture response2 = this.client.responses().create(params);
        return this.responsesApi.processResponse(this.toFlow(response2));
    }

    private final <T> Flow<T> toFlow(AsyncStreamResponse<T> streamResponse) {
        return FlowKt.callbackFlow((Function2)new Function2<ProducerScope<? super T>, Continuation<? super Unit>, Object>(streamResponse, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AsyncStreamResponse<T> $streamResponse;
            {
                this.$streamResponse = $streamResponse;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        Ref.ObjectRef responseError = new Ref.ObjectRef();
                        AsyncStreamResponse.Handler<T> responseHandler2 = new AsyncStreamResponse.Handler<T>($this$callbackFlow, (Ref.ObjectRef<Throwable>)responseError){
                            final /* synthetic */ ProducerScope<T> $$this$callbackFlow;
                            final /* synthetic */ Ref.ObjectRef<Throwable> $responseError;
                            {
                                this.$$this$callbackFlow = $$this$callbackFlow;
                                this.$responseError = $responseError;
                            }

                            public void onNext(T value) {
                                ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), value);
                            }

                            public void onComplete(Optional<Throwable> error) {
                                Intrinsics.checkNotNullParameter(error, (String)"error");
                                error.ifPresent(arg_0 -> toFlow.responseHandler.1.onComplete$lambda$1(arg_0 -> toFlow.responseHandler.1.onComplete$lambda$0(this.$responseError, arg_0), arg_0));
                                SendChannel.DefaultImpls.close$default((SendChannel)this.$$this$callbackFlow.getChannel(), null, (int)1, null);
                            }

                            private static final Unit onComplete$lambda$0(Ref.ObjectRef $responseError, Throwable it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                $responseError.element = it;
                                return Unit.INSTANCE;
                            }

                            private static final void onComplete$lambda$1(Function1 $tmp0, Object p0) {
                                $tmp0.invoke(p0);
                            }
                        };
                        this.$streamResponse.subscribe((AsyncStreamResponse.Handler)responseHandler2);
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, () -> toFlow.1.invokeSuspend$lambda$0(this.$streamResponse, responseError), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super T> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(AsyncStreamResponse $streamResponse, Ref.ObjectRef $responseError) {
                $streamResponse.close();
                Throwable throwable = (Throwable)$responseError.element;
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    throw it;
                }
                return Unit.INSTANCE;
            }
        });
    }

    @Nullable
    public final <T> Object awaitCompletableFuture(@NotNull CompletableFuture<T> future, @NotNull Continuation<? super T> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super T> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        Function2 function2 = new Function2<T, Throwable, Unit>(continuation){
            final /* synthetic */ CancellableContinuation<T> $continuation;
            {
                this.$continuation = $continuation;
            }

            public final void invoke(T value, Throwable throwable) {
                if (throwable != null) {
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                } else {
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl(value));
                }
            }
        };
        future.whenComplete(new BiConsumer(function2){
            private final /* synthetic */ Function2 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void accept(Object p0, Object p1) {
                this.function.invoke(p0, p1);
            }
        });
        continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(future){
            final /* synthetic */ CompletableFuture<T> $future;
            {
                this.$future = $future;
            }

            public final void invoke(Throwable it) {
                this.$future.cancel(true);
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final <T> Flow<T> toFlow(CompletableFuture<T> responseFuture) {
        return FlowKt.flow((Function2)new Function2<FlowCollector<? super T>, Continuation<? super Unit>, Object>(this, responseFuture, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ OpenAiChatImpl this$0;
            final /* synthetic */ CompletableFuture<T> $responseFuture;
            {
                this.this$0 = $receiver;
                this.$responseFuture = $responseFuture;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_4 = $this$flow = (FlowCollector)this.L$0;
                        this.L$0 = var3_4;
                        this.label = 1;
                        v0 = this.this$0.awaitCompletableFuture(this.$responseFuture, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        var3_4 = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = var3_4.emit(v0, (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(FlowCollector<? super T> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final boolean _init_$lambda$0(Prompt.Function function, ModelConfig modelConfig) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)modelConfig, (String)"<unused var>");
        return true;
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView access$getNonStreamingModels$p(OpenAiChatImpl $this) {
        return $this.nonStreamingModels;
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView access$getResponsesApiModels$p(OpenAiChatImpl $this) {
        return $this.responsesApiModels;
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView access$getSystemMessageModels$p(OpenAiChatImpl $this) {
        return $this.systemMessageModels;
    }

    static {
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
        INVALID_ROLE_ERROR_PATTERN = new Regex("(?i).*\\brole\\b.*must be one of.*");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/backends/openai/OpenAiChatImpl$Companion;", "", "<init>", "()V", "GSON", "Lcom/google/gson/Gson;", "getGSON$aiplugin_backends_third_party", "()Lcom/google/gson/Gson;", "INVALID_ROLE_ERROR_PATTERN", "Lkotlin/text/Regex;", "parseArguments", "", "", "rawArguments", "isValidJson", "", "s", "aiplugin.backends.third-party"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGSON$aiplugin_backends_third_party() {
            return GSON;
        }

        @NotNull
        public final Map<String, Object> parseArguments(@NotNull String rawArguments) {
            Intrinsics.checkNotNullParameter((Object)rawArguments, (String)"rawArguments");
            try {
                Type argumentsType2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
                Object object = this.getGSON$aiplugin_backends_third_party().fromJson(rawArguments, argumentsType2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                return (Map)object;
            }
            catch (JsonParseException e) {
                String maybeSanitized = OpenAiToolsKt.sanitizeMultilineString(rawArguments, this.getGSON$aiplugin_backends_third_party());
                if (maybeSanitized != null && this.isValidJson(maybeSanitized)) {
                    return this.parseArguments(maybeSanitized);
                }
                throw e;
            }
        }

        public final boolean isValidJson(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            try {
                this.getGSON$aiplugin_backends_third_party().fromJson(s, Map.class);
                return true;
            }
            catch (MalformedJsonException e) {
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

