/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.backends.openai;

import com.android.studio.ml.backends.openai.OpenAiApiError;
import com.openai.core.JsonObject;
import com.openai.core.JsonValue;
import com.openai.models.models.ModelListPageAsync;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0002J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/studio/ml/backends/openai/OpenAiApiResponseValidator;", "", "<init>", "()V", "ERROR_KEY", "", "ensureNoErrorsInProperties", "", "additionalProperties", "", "Lcom/openai/core/JsonValue;", "execute", "responsePage", "Lcom/openai/models/models/ModelListPageAsync;", "aiplugin.backends.third-party"})
public final class OpenAiApiResponseValidator {
    @NotNull
    public static final OpenAiApiResponseValidator INSTANCE = new OpenAiApiResponseValidator();
    @NotNull
    private static final String ERROR_KEY = "error";

    private OpenAiApiResponseValidator() {
    }

    private final void ensureNoErrorsInProperties(Map<String, ? extends JsonValue> additionalProperties) {
        String errorMessage;
        String string;
        JsonValue jsonValue = additionalProperties;
        if (jsonValue == null || (jsonValue = jsonValue.get(ERROR_KEY)) == null) {
            return;
        }
        JsonValue errorJsonValue = jsonValue;
        if (errorJsonValue instanceof JsonObject) {
            string = (JsonValue)((JsonObject)errorJsonValue).values().get("message");
            if (string == null || (string = string.toString()) == null) {
                string = ((JsonObject)errorJsonValue).toString();
            }
        } else {
            string = errorJsonValue.toString();
        }
        if (!StringsKt.isBlank((CharSequence)(errorMessage = string))) {
            throw new OpenAiApiError(errorMessage);
        }
    }

    public final void execute(@NotNull ModelListPageAsync responsePage2) {
        Intrinsics.checkNotNullParameter((Object)responsePage2, (String)"responsePage");
        Map properties = responsePage2.response()._additionalProperties();
        this.ensureNoErrorsInProperties(properties);
    }
}

