/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.aiexclude;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.aiexclude.AiExcludeInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntry;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\f\u0010\r\u001a\u00020\u000b*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/aiexclude/AiExcludeInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isEmpty", "Lcom/intellij/openapi/vcs/changes/ignore/psi/IgnoreFile;", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class AiExcludeInspection
extends LocalInspectionTool {
    public static final int $stable = 8;

    private final boolean isEmpty(IgnoreFile $this$isEmpty) {
        for (PsiElement curr = $this$isEmpty.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            if (!(curr instanceof IgnoreEntry)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        IgnoreFile ignoreFile = file instanceof IgnoreFile ? (IgnoreFile)file : null;
        if (ignoreFile == null) {
            return null;
        }
        IgnoreFile ignoreFile2 = ignoreFile;
        if (this.isEmpty(ignoreFile2)) {
            String message = "An empty .aiexclude file does not actually exclude anything. Use * instead.";
            TextRange range = ((IgnoreFile)file).getTextRange();
            LocalQuickFix fix2 = new LocalQuickFix(){

                public String getFamilyName() {
                    return "Exclude everything";
                }

                public void applyFix(Project project2, ProblemDescriptor descriptor) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    WriteCommandAction.runWriteCommandAction((Project)project2, () -> checkFile.fix.1.applyFix$lambda$0(project2, descriptor));
                }

                private static final void applyFix$lambda$0(Project $project, ProblemDescriptor $descriptor) {
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)$project);
                    Document document2 = documentManager.getDocument($descriptor.getStartElement().getContainingFile());
                    if (document2 != null) {
                        document2.insertString(document2.getTextLength(), (CharSequence)"\n#Exclude everything\n*\n");
                        documentManager.commitAllDocuments();
                    }
                }
            };
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix2};
            ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)file, range, message, ProblemHighlightType.WARNING, true, localQuickFixArray);
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
            ProblemDescriptor descriptor = problemDescriptor;
            ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[]{descriptor};
            return problemDescriptorArray;
        }
        return super.checkFile(file, manager, isOnTheFly);
    }
}

