/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.aida;

import aida.com.google.protobuf.util.Durations;
import aida.com.google.protobuf.util.Timestamps;
import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.SmlCodeCompletionEvent;
import com.android.studio.ml.SmlCodeCompletionEventListenerAdapter;
import com.android.studio.ml.SmlCodeCompletionResponse;
import com.android.studio.ml.aida.AidaMetrics;
import com.android.studio.ml.aida.AidaProtoUtils;
import com.google.labs.aida.proto.AIDAClient;
import com.google.labs.aida.proto.CompleteCodeClientEvent;
import com.google.labs.aida.proto.CompletionResponse;
import com.google.labs.aida.proto.GenerationSample;
import com.google.labs.aida.proto.RegisterClientEventRequest;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/studio/ml/aida/AidaCompletionEventListener;", "Lcom/android/studio/ml/SmlCodeCompletionEventListenerAdapter;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isEnabled", "", "onCompletionDisplayed", "", "event", "Lcom/android/studio/ml/SmlCodeCompletionEvent$CompletionDisplayed;", "onCompletionRevisionInfo", "Lcom/android/studio/ml/SmlCodeCompletionEvent$CompletionRevisionInfo;", "sendRegisterClientEventRequest", "eventTime", "Lkotlinx/datetime/Instant;", "rpcId", "", "completeCodeClientEvent", "Lcom/google/labs/aida/proto/CompleteCodeClientEvent$Builder;", "getAidaResponse", "Lcom/google/labs/aida/proto/CompletionResponse;", "Lcom/android/studio/ml/SmlCodeCompletionResponse;", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAidaCompletionEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AidaCompletionEventListener.kt\ncom/android/studio/ml/aida/AidaCompletionEventListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,126:1\n24#2:127\n*S KotlinDebug\n*F\n+ 1 AidaCompletionEventListener.kt\ncom/android/studio/ml/aida/AidaCompletionEventListener\n*L\n37#1:127\n*E\n"})
public final class AidaCompletionEventListener
implements SmlCodeCompletionEventListenerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;

    public AidaCompletionEventListener() {
        AidaCompletionEventListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AidaCompletionEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    public void onCompletionDisplayed(@NotNull SmlCodeCompletionEvent.CompletionDisplayed event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CompletionResponse completionResponse = this.getAidaResponse(event.getCompletionResponse());
        if (completionResponse == null) {
            return;
        }
        CompletionResponse aidaResponse = completionResponse;
        long rpcId = aidaResponse.getMetadata().getRpcGlobalId();
        for (SmlCodeCompletionEvent.CompletionDisplayed.SuggestionShownDetails suggestionShownDetails : event.getSuggestionsShownDetails()) {
            CompleteCodeClientEvent.UserImpression.Builder builder;
            CompleteCodeClientEvent.Builder builder2;
            int suggestionIndex = suggestionShownDetails.component1();
            String displayedSuggestion = suggestionShownDetails.component2();
            Instant shownStartTime = suggestionShownDetails.component3();
            long shownDuration = suggestionShownDetails.component4-UwyO8pc();
            if (Duration.equals-impl0((long)shownDuration, (long)Duration.Companion.getZERO-UwyO8pc())) continue;
            int sampleId = ((GenerationSample)aidaResponse.getGeneratedSamplesList().get(suggestionIndex)).getSampleId();
            CompleteCodeClientEvent.Builder $this$onCompletionDisplayed_u24lambda_u240 = builder2 = CompleteCodeClientEvent.newBuilder();
            boolean bl = false;
            CompleteCodeClientEvent.UserImpression.Builder $this$onCompletionDisplayed_u24lambda_u240_u240 = builder = $this$onCompletionDisplayed_u24lambda_u240.getUserImpressionBuilder();
            boolean bl2 = false;
            $this$onCompletionDisplayed_u24lambda_u240_u240.getLatencyBuilder().setDuration(Durations.fromMillis((long)Duration.getInWholeMilliseconds-impl((long)event.getLatencyToDisplay-UwyO8pc())));
            $this$onCompletionDisplayed_u24lambda_u240_u240.getShownDurationBuilder().setDuration(Durations.fromMillis((long)Duration.getInWholeMilliseconds-impl((long)shownDuration)));
            $this$onCompletionDisplayed_u24lambda_u240_u240.getSampleBuilder().setSampleId(sampleId);
            CompleteCodeClientEvent.Builder userImpressionEvent = builder2;
            Intrinsics.checkNotNull((Object)userImpressionEvent);
            this.sendRegisterClientEventRequest(shownStartTime, rpcId, userImpressionEvent);
        }
        if (event.getAcceptedSuggestionIndex() != null) {
            CompleteCodeClientEvent.Builder builder;
            int sampleId = ((GenerationSample)aidaResponse.getGeneratedSamplesList().get(event.getAcceptedSuggestionIndex())).getSampleId();
            CompleteCodeClientEvent.Builder $this$onCompletionDisplayed_u24lambda_u241 = builder = CompleteCodeClientEvent.newBuilder();
            boolean bl = false;
            $this$onCompletionDisplayed_u24lambda_u241.getUserAcceptanceBuilder().getSampleBuilder().setSampleId(sampleId);
            CompleteCodeClientEvent.Builder userAcceptanceBuilder = builder;
            Instant instant = event.getHideTime();
            Intrinsics.checkNotNull((Object)userAcceptanceBuilder);
            this.sendRegisterClientEventRequest(instant, rpcId, userAcceptanceBuilder);
        }
    }

    @Override
    public void onCompletionRevisionInfo(@NotNull SmlCodeCompletionEvent.CompletionRevisionInfo event) {
        CompleteCodeClientEvent.UserRevision.Builder builder;
        CompleteCodeClientEvent.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CompletionResponse completionResponse = this.getAidaResponse(event.getCompletionResponse());
        if (completionResponse == null) {
            return;
        }
        CompletionResponse aidaResponse = completionResponse;
        long rpcId = aidaResponse.getMetadata().getRpcGlobalId();
        int sampleId = ((GenerationSample)aidaResponse.getGeneratedSamplesList().get(event.getSuggestionIndex())).getSampleId();
        CompleteCodeClientEvent.Builder $this$onCompletionRevisionInfo_u24lambda_u240 = builder2 = CompleteCodeClientEvent.newBuilder();
        boolean bl = false;
        CompleteCodeClientEvent.UserRevision.Builder $this$onCompletionRevisionInfo_u24lambda_u240_u240 = builder = $this$onCompletionRevisionInfo_u24lambda_u240.getUserRevisionBuilder();
        boolean bl2 = false;
        $this$onCompletionRevisionInfo_u24lambda_u240_u240.getSampleBuilder().setSampleId(sampleId);
        $this$onCompletionRevisionInfo_u24lambda_u240_u240.setEditedSuggestion(event.getUpdatedText());
        $this$onCompletionRevisionInfo_u24lambda_u240_u240.setRevisionState(AidaProtoUtils.INSTANCE.toAidaRevisionState(event.getRevisionInfoTrigger()));
        CompleteCodeClientEvent.Builder completeCodeClientEvent = builder2;
        Instant instant = event.getEventTime();
        Intrinsics.checkNotNull((Object)completeCodeClientEvent);
        this.sendRegisterClientEventRequest(instant, rpcId, completeCodeClientEvent);
    }

    private final CompletionResponse getAidaResponse(SmlCodeCompletionResponse $this$getAidaResponse) {
        if (!($this$getAidaResponse.getMetaData() instanceof CompletionResponse)) {
            this.logger.error("Completion response is not CompletionResponse: " + $this$getAidaResponse.getMetaData());
            return null;
        }
        return (CompletionResponse)$this$getAidaResponse.getMetaData();
    }

    private final void sendRegisterClientEventRequest(Instant eventTime, long rpcId, CompleteCodeClientEvent.Builder completeCodeClientEvent) {
        RegisterClientEventRequest request2 = RegisterClientEventRequest.newBuilder().setClient(AIDAClient.ANDROID_STUDIO).setEventTime(Timestamps.fromMillis((long)eventTime.toEpochMilliseconds())).setCorrespondingAidaRpcGlobalId(rpcId).setCompleteCodeClientEvent(completeCodeClientEvent).build();
        Intrinsics.checkNotNull((Object)request2);
        AidaMetrics.INSTANCE.sendRegisterClientEventRequest(request2);
    }

    @Override
    public boolean isEnabled() {
        return AidaMetrics.INSTANCE.isAidaAnalyticsEnabled();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/studio/ml/aida/AidaCompletionEventListener$Companion;", "", "()V", "getInstance", "Lcom/android/studio/ml/aida/AidaCompletionEventListener;", "aiplugin.core.aicore"})
    @SourceDebugExtension(value={"SMAP\nAidaCompletionEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AidaCompletionEventListener.kt\ncom/android/studio/ml/aida/AidaCompletionEventListener$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,126:1\n40#2,3:127\n*S KotlinDebug\n*F\n+ 1 AidaCompletionEventListener.kt\ncom/android/studio/ml/aida/AidaCompletionEventListener$Companion\n*L\n123#1:127,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AidaCompletionEventListener getInstance() {
            boolean $i$f$service = false;
            Class<AidaCompletionEventListener> serviceClass$iv = AidaCompletionEventListener.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (AidaCompletionEventListener)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

