/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.writer;

import android.databinding.tool.LibTypes;
import android.databinding.tool.ext.ExtKt;
import android.databinding.tool.ext.Javapoet_extKt;
import android.databinding.tool.store.GenClassInfoLog;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.writer.BaseLayoutModel;
import android.databinding.tool.writer.CommonKt;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001aH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroid/databinding/tool/writer/BaseLayoutBinderWriter;", "", "model", "Landroid/databinding/tool/writer/BaseLayoutModel;", "libTypes", "Landroid/databinding/tool/LibTypes;", "<init>", "(Landroid/databinding/tool/writer/BaseLayoutModel;Landroid/databinding/tool/LibTypes;)V", "getModel", "()Landroid/databinding/tool/writer/BaseLayoutModel;", "getLibTypes", "()Landroid/databinding/tool/LibTypes;", "binderTypeName", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "viewDataBinding", "nonNull", "nullable", "dataBindingComponent", "dataBindingUtil", "bindable", "write", "Lcom/squareup/javapoet/JavaFile;", "createType", "Lcom/squareup/javapoet/TypeSpec;", "createStaticInflaters", "", "Lcom/squareup/javapoet/MethodSpec;", "createGettersAndSetters", "createConstructor", "generateClassInfo", "Landroid/databinding/tool/store/GenClassInfoLog$GenClass;", "createVariableFields", "Lcom/squareup/javapoet/FieldSpec;", "createBindingTargetFields", "Companion", "db-compilerCommon"})
@SourceDebugExtension(value={"SMAP\nBaseLayoutBinderWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseLayoutBinderWriter.kt\nandroid/databinding/tool/writer/BaseLayoutBinderWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1374#2:254\n1460#2,5:255\n1193#2,2:260\n1267#2,4:262\n1563#2:266\n1634#2,3:267\n774#2:270\n865#2,2:271\n1563#2:273\n1634#2,3:274\n774#2:277\n865#2,2:278\n1869#2,2:280\n774#2:282\n865#2,2:283\n1869#2,2:285\n*S KotlinDebug\n*F\n+ 1 BaseLayoutBinderWriter.kt\nandroid/databinding/tool/writer/BaseLayoutBinderWriter\n*L\n166#1:254\n166#1:255,5\n218#1:260,2\n218#1:262,4\n225#1:266\n225#1:267,3\n235#1:270\n235#1:271,2\n236#1:273\n236#1:274,3\n201#1:277\n201#1:278,2\n202#1:280,2\n207#1:282\n207#1:283,2\n207#1:285,2\n*E\n"})
public final class BaseLayoutBinderWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseLayoutModel model;
    @NotNull
    private final LibTypes libTypes;
    private final ClassName binderTypeName;
    @NotNull
    private final ClassName viewDataBinding;
    @NotNull
    private final ClassName nonNull;
    @NotNull
    private final ClassName nullable;
    private final ClassName dataBindingComponent;
    @NotNull
    private final ClassName dataBindingUtil;
    @NotNull
    private final ClassName bindable;
    private static final ClassName DEPRECATED = ClassName.get(Deprecated.class);
    @NotNull
    private static final String JAVADOC_BINDING_COMPONENT = "This method receives DataBindingComponent instance as type Object instead of\ntype DataBindingComponent to avoid causing too many compilation errors if\ncompilation fails for another reason.\nhttps://issuetracker.google.com/issues/116541301";

    public BaseLayoutBinderWriter(@NotNull BaseLayoutModel model, @NotNull LibTypes libTypes) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)libTypes, (String)"libTypes");
        this.model = model;
        this.libTypes = libTypes;
        this.binderTypeName = ClassName.get((String)this.model.getBindingClassPackage(), (String)this.model.getBindingClassName(), (String[])new String[0]);
        this.viewDataBinding = Javapoet_extKt.toClassName(this.libTypes.getViewDataBinding());
        this.nonNull = Javapoet_extKt.toClassName(this.libTypes.getNonNull());
        this.nullable = Javapoet_extKt.toClassName(this.libTypes.getNullable());
        this.dataBindingComponent = TypeName.OBJECT;
        this.dataBindingUtil = Javapoet_extKt.toClassName(this.libTypes.getDataBindingUtil());
        this.bindable = Javapoet_extKt.toClassName(this.libTypes.getBindable());
    }

    @NotNull
    public final BaseLayoutModel getModel() {
        return this.model;
    }

    @NotNull
    public final LibTypes getLibTypes() {
        return this.libTypes;
    }

    @NotNull
    public final JavaFile write() {
        String string = this.binderTypeName.packageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName(...)");
        return Javapoet_extKt.javaFile(string, this.createType(), (Function1<? super JavaFile.Builder, Unit>)((Function1)BaseLayoutBinderWriter::write$lambda$0));
    }

    private final TypeSpec createType() {
        ClassName className = this.binderTypeName;
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"binderTypeName");
        return Javapoet_extKt.classSpec(className, (Function1<? super TypeSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createType$lambda$0(this, arg_0)));
    }

    private final List<MethodSpec> createStaticInflaters() {
        ParameterSpec inflaterParam = Javapoet_extKt.parameterSpec((TypeName)CommonKt.getANDROID_LAYOUT_INFLATER(), "inflater", (Function1<? super ParameterSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createStaticInflaters$lambda$0(this, arg_0)));
        ParameterSpec viewGroupParam = Javapoet_extKt.parameterSpec((TypeName)CommonKt.getANDROID_VIEW_GROUP(), "root", (Function1<? super ParameterSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createStaticInflaters$lambda$1(this, arg_0)));
        ParameterSpec viewParam = Javapoet_extKt.parameterSpec((TypeName)CommonKt.getANDROID_VIEW(), "view", (Function1<? super ParameterSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createStaticInflaters$lambda$2(this, arg_0)));
        ClassName className = this.dataBindingComponent;
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"dataBindingComponent");
        ParameterSpec componentParam = Javapoet_extKt.parameterSpec((TypeName)className, "component", (Function1<? super ParameterSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createStaticInflaters$lambda$3(this, arg_0)));
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new String[]{"layout"};
        objectArray[0] = ClassName.get((String)this.model.getModulePackage(), (String)"R", (String[])objectArray2);
        objectArray[1] = this.model.getBaseFileName();
        CodeBlock rLayoutFile = CodeBlock.of((String)"$T.$N", (Object[])objectArray);
        TypeName typeName = TypeName.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"BOOLEAN");
        ParameterSpec attachToRootParam = Javapoet_extKt.parameterSpec$default(typeName, "attachToRoot", null, 4, null);
        objectArray2 = new MethodSpec[]{Javapoet_extKt.methodSpec("inflate", (Function1<? super MethodSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createStaticInflaters$lambda$4(inflaterParam, viewGroupParam, attachToRootParam, this, arg_0))), Javapoet_extKt.methodSpec("inflate", (Function1<? super MethodSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createStaticInflaters$lambda$5(inflaterParam, viewGroupParam, attachToRootParam, componentParam, this, rLayoutFile, arg_0))), Javapoet_extKt.methodSpec("inflate", (Function1<? super MethodSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createStaticInflaters$lambda$6(inflaterParam, this, arg_0))), Javapoet_extKt.methodSpec("inflate", (Function1<? super MethodSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createStaticInflaters$lambda$7(inflaterParam, componentParam, this, rLayoutFile, arg_0))), Javapoet_extKt.methodSpec("bind", (Function1<? super MethodSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createStaticInflaters$lambda$8(viewParam, this, arg_0))), Javapoet_extKt.methodSpec("bind", (Function1<? super MethodSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createStaticInflaters$lambda$9(viewParam, componentParam, this, rLayoutFile, arg_0)))};
        return CollectionsKt.listOf((Object[])objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MethodSpec> createGettersAndSetters() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.model.getVariables();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ResourceBundle.VariableDeclaration variable = (ResourceBundle.VariableDeclaration)element$iv$iv;
            boolean bl = false;
            String string = variable.type;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type");
            TypeName typeName = ExtKt.toTypeName(string, this.libTypes, this.model.getImportsByAlias());
            Object[] objectArray = new MethodSpec[]{Javapoet_extKt.methodSpec(this.model.setterName(variable), (Function1<? super MethodSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createGettersAndSetters$lambda$0$0(typeName, variable, this, arg_0))), Javapoet_extKt.methodSpec(this.model.getterName(variable), (Function1<? super MethodSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createGettersAndSetters$lambda$0$1(typeName, this, variable, arg_0)))};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MethodSpec createConstructor() {
        return Javapoet_extKt.constructorSpec((Function1<? super MethodSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createConstructor$lambda$0(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GenClassInfoLog.GenClass generateClassInfo() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        String string = this.binderTypeName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Iterable iterable = this.model.getVariables();
        String string2 = this.model.getModulePackage();
        String string3 = string;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var4_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ResourceBundle.VariableDeclaration it = (ResourceBundle.VariableDeclaration)element$iv$iv;
            boolean bl = false;
            String string4 = it.name;
            String string5 = it.type;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"type");
            Pair pair = new Pair((Object)string4, (Object)ExtKt.toTypeName(string5, this.libTypes, this.model.getImportsByAlias()).toString());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        Set<GenClassInfoLog.GenClassImpl> set = this.model.generateImplInfo();
        Map map2 = map;
        String string6 = string2;
        String string7 = string3;
        return new GenClassInfoLog.GenClass(string7, string6, map2, set);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldSpec> createVariableFields() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getVariables();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceBundle.VariableDeclaration variableDeclaration = (ResourceBundle.VariableDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.model.fieldName((ResourceBundle.VariableDeclaration)it);
            String string2 = it.type;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type");
            collection.add(Javapoet_extKt.fieldSpec(string, ExtKt.toTypeName(string2, this.libTypes, this.model.getImportsByAlias()), (Function1<? super FieldSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createVariableFields$lambda$0$0(this, arg_0))));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldSpec> createBindingTargetFields() {
        void $this$mapTo$iv$iv;
        ResourceBundle.BindingTargetBundle it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.model.getSortedTargets();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceBundle.BindingTargetBundle)element$iv$iv;
            boolean bl = false;
            if (!(it.getId() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResourceBundle.BindingTargetBundle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeName fieldType = ExtKt.toTypeName(CommonKt.getFieldType(it), this.libTypes, this.model.getImportsByAlias());
            collection.add(Javapoet_extKt.fieldSpec(this.model.fieldName(it), fieldType, (Function1<? super FieldSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createBindingTargetFields$lambda$1$0(it, this, arg_0))));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit write$lambda$0(JavaFile.Builder $this$javaFile) {
        Intrinsics.checkNotNullParameter((Object)$this$javaFile, (String)"$this$javaFile");
        $this$javaFile.addFileComment("Generated by data binding compiler. Do not edit!", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit createType$lambda$0(BaseLayoutBinderWriter this$0, TypeSpec.Builder $this$classSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$classSpec, (String)"$this$classSpec");
        $this$classSpec.superclass((TypeName)this$0.viewDataBinding);
        Modifier[] modifierArray = new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC};
        $this$classSpec.addModifiers(modifierArray);
        $this$classSpec.addFields((Iterable)this$0.createBindingTargetFields());
        $this$classSpec.addFields((Iterable)this$0.createVariableFields());
        $this$classSpec.addMethod(this$0.createConstructor());
        $this$classSpec.addMethods((Iterable)this$0.createGettersAndSetters());
        $this$classSpec.addMethods((Iterable)this$0.createStaticInflaters());
        return Unit.INSTANCE;
    }

    private static final Unit createStaticInflaters$lambda$0(BaseLayoutBinderWriter this$0, ParameterSpec.Builder $this$parameterSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$parameterSpec, (String)"$this$parameterSpec");
        $this$parameterSpec.addAnnotation(this$0.nonNull);
        return Unit.INSTANCE;
    }

    private static final Unit createStaticInflaters$lambda$1(BaseLayoutBinderWriter this$0, ParameterSpec.Builder $this$parameterSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$parameterSpec, (String)"$this$parameterSpec");
        $this$parameterSpec.addAnnotation(this$0.nullable);
        return Unit.INSTANCE;
    }

    private static final Unit createStaticInflaters$lambda$2(BaseLayoutBinderWriter this$0, ParameterSpec.Builder $this$parameterSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$parameterSpec, (String)"$this$parameterSpec");
        $this$parameterSpec.addAnnotation(this$0.nonNull);
        return Unit.INSTANCE;
    }

    private static final Unit createStaticInflaters$lambda$3(BaseLayoutBinderWriter this$0, ParameterSpec.Builder $this$parameterSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$parameterSpec, (String)"$this$parameterSpec");
        $this$parameterSpec.addAnnotation(this$0.nullable);
        return Unit.INSTANCE;
    }

    private static final Unit createStaticInflaters$lambda$4(ParameterSpec $inflaterParam, ParameterSpec $viewGroupParam, ParameterSpec $attachToRootParam, BaseLayoutBinderWriter this$0, MethodSpec.Builder $this$methodSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        $this$methodSpec.addModifiers(objectArray);
        $this$methodSpec.addParameter($inflaterParam);
        $this$methodSpec.addParameter($viewGroupParam);
        $this$methodSpec.addParameter($attachToRootParam);
        $this$methodSpec.returns((TypeName)this$0.binderTypeName);
        $this$methodSpec.addAnnotation(this$0.nonNull);
        objectArray = new Object[]{$inflaterParam, $viewGroupParam, $attachToRootParam, this$0.dataBindingUtil};
        $this$methodSpec.addStatement("return inflate($N, $N, $N, $T.getDefaultComponent())", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit createStaticInflaters$lambda$5(ParameterSpec $inflaterParam, ParameterSpec $viewGroupParam, ParameterSpec $attachToRootParam, ParameterSpec $componentParam, BaseLayoutBinderWriter this$0, CodeBlock $rLayoutFile, MethodSpec.Builder $this$methodSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        $this$methodSpec.addModifiers(objectArray);
        $this$methodSpec.addParameter($inflaterParam);
        $this$methodSpec.addParameter($viewGroupParam);
        $this$methodSpec.addParameter($attachToRootParam);
        $this$methodSpec.addParameter($componentParam);
        $this$methodSpec.returns((TypeName)this$0.binderTypeName);
        $this$methodSpec.addAnnotation(this$0.nonNull);
        $this$methodSpec.addAnnotation(DEPRECATED);
        $this$methodSpec.addJavadoc(JAVADOC_BINDING_COMPONENT, new Object[0]);
        objectArray = new Object[]{this$0.model.getBaseFileName(), $viewGroupParam, $attachToRootParam, $componentParam};
        $this$methodSpec.addJavadoc("\n@Deprecated Use DataBindingUtil.inflate(inflater, R.layout.$L, $N, $N, $N)\n", objectArray);
        objectArray = new Object[]{this$0.viewDataBinding, this$0.binderTypeName, $inflaterParam, $rLayoutFile, $viewGroupParam, $attachToRootParam, $componentParam};
        $this$methodSpec.addStatement("return $T.<$T>inflateInternal($N, $L, $N, $N, $N)", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit createStaticInflaters$lambda$6(ParameterSpec $inflaterParam, BaseLayoutBinderWriter this$0, MethodSpec.Builder $this$methodSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        $this$methodSpec.addModifiers(objectArray);
        $this$methodSpec.addParameter($inflaterParam);
        $this$methodSpec.returns((TypeName)this$0.binderTypeName);
        $this$methodSpec.addAnnotation(this$0.nonNull);
        objectArray = new Object[]{$inflaterParam, this$0.dataBindingUtil};
        $this$methodSpec.addStatement("return inflate($N, $T.getDefaultComponent())", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit createStaticInflaters$lambda$7(ParameterSpec $inflaterParam, ParameterSpec $componentParam, BaseLayoutBinderWriter this$0, CodeBlock $rLayoutFile, MethodSpec.Builder $this$methodSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        $this$methodSpec.addModifiers(objectArray);
        $this$methodSpec.addParameter($inflaterParam);
        $this$methodSpec.addParameter($componentParam);
        $this$methodSpec.returns((TypeName)this$0.binderTypeName);
        $this$methodSpec.addAnnotation(this$0.nonNull);
        $this$methodSpec.addAnnotation(DEPRECATED);
        $this$methodSpec.addJavadoc(JAVADOC_BINDING_COMPONENT, new Object[0]);
        objectArray = new Object[]{this$0.model.getBaseFileName(), $componentParam};
        $this$methodSpec.addJavadoc("\n@Deprecated Use DataBindingUtil.inflate(inflater, R.layout.$L, null, false, $N)\n", objectArray);
        objectArray = new Object[]{this$0.viewDataBinding, this$0.binderTypeName, $inflaterParam, $rLayoutFile, $componentParam};
        $this$methodSpec.addStatement("return $T.<$T>inflateInternal($N, $L, null, false, $N)", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit createStaticInflaters$lambda$8(ParameterSpec $viewParam, BaseLayoutBinderWriter this$0, MethodSpec.Builder $this$methodSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        $this$methodSpec.addModifiers(objectArray);
        $this$methodSpec.addParameter($viewParam);
        $this$methodSpec.returns((TypeName)this$0.binderTypeName);
        objectArray = new Object[]{$viewParam, this$0.dataBindingUtil};
        $this$methodSpec.addStatement("return bind($N, $T.getDefaultComponent())", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit createStaticInflaters$lambda$9(ParameterSpec $viewParam, ParameterSpec $componentParam, BaseLayoutBinderWriter this$0, CodeBlock $rLayoutFile, MethodSpec.Builder $this$methodSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        $this$methodSpec.addModifiers(objectArray);
        $this$methodSpec.addParameter($viewParam);
        $this$methodSpec.addParameter($componentParam);
        $this$methodSpec.returns((TypeName)this$0.binderTypeName);
        $this$methodSpec.addAnnotation(DEPRECATED);
        $this$methodSpec.addJavadoc(JAVADOC_BINDING_COMPONENT, new Object[0]);
        objectArray = new Object[]{$viewParam, $componentParam};
        $this$methodSpec.addJavadoc("\n@Deprecated Use DataBindingUtil.bind($N, $N)\n", objectArray);
        objectArray = new Object[]{this$0.binderTypeName, $componentParam, $viewParam, $rLayoutFile};
        $this$methodSpec.addStatement("return ($T)bind($N, $N, $L)", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit createGettersAndSetters$lambda$0$0(TypeName $typeName, ResourceBundle.VariableDeclaration $variable, BaseLayoutBinderWriter this$0, MethodSpec.Builder $this$methodSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        $this$methodSpec.addModifiers(modifierArray);
        String string = $variable.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        ParameterSpec param = Javapoet_extKt.parameterSpec($typeName, string, (Function1<? super ParameterSpec.Builder, Unit>)((Function1)arg_0 -> BaseLayoutBinderWriter.createGettersAndSetters$lambda$0$0$0($typeName, this$0, arg_0)));
        $this$methodSpec.returns(TypeName.VOID);
        $this$methodSpec.addParameter(param);
        Modifier[] modifierArray2 = new Modifier[]{Modifier.ABSTRACT};
        $this$methodSpec.addModifiers(modifierArray2);
        modifierArray2 = new Modifier[]{Modifier.PUBLIC};
        $this$methodSpec.addModifiers(modifierArray2);
        return Unit.INSTANCE;
    }

    private static final Unit createGettersAndSetters$lambda$0$0$0(TypeName $typeName, BaseLayoutBinderWriter this$0, ParameterSpec.Builder $this$parameterSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$parameterSpec, (String)"$this$parameterSpec");
        if (!$typeName.isPrimitive()) {
            $this$parameterSpec.addAnnotation(this$0.nullable);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createGettersAndSetters$lambda$0$1(TypeName $typeName, BaseLayoutBinderWriter this$0, ResourceBundle.VariableDeclaration $variable, MethodSpec.Builder $this$methodSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        $this$methodSpec.addModifiers(objectArray);
        $this$methodSpec.returns($typeName);
        if (!$typeName.isPrimitive()) {
            $this$methodSpec.addAnnotation(this$0.nullable);
        }
        objectArray = new Object[]{this$0.model.fieldName($variable)};
        $this$methodSpec.addStatement("return $L", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit createConstructor$lambda$0(BaseLayoutBinderWriter this$0, MethodSpec.Builder $this$constructorSpec) {
        Object[] $this$forEach$iv;
        ResourceBundle.BindingTargetBundle it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$constructorSpec, (String)"$this$constructorSpec");
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        $this$constructorSpec.addModifiers(modifierArray);
        ClassName className = this$0.dataBindingComponent;
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"dataBindingComponent");
        ParameterSpec componentParam = Javapoet_extKt.parameterSpec$default((TypeName)className, "_bindingComponent", null, 4, null);
        ParameterSpec viewParam = Javapoet_extKt.parameterSpec$default((TypeName)CommonKt.getANDROID_VIEW(), "_root", null, 4, null);
        TypeName typeName = TypeName.INT;
        Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"INT");
        ParameterSpec localFieldCountParam = Javapoet_extKt.parameterSpec$default(typeName, "_localFieldCount", null, 4, null);
        $this$constructorSpec.addParameter(componentParam);
        $this$constructorSpec.addParameter(viewParam);
        $this$constructorSpec.addParameter(localFieldCountParam);
        Iterable $this$filter$iv = this$0.model.getSortedTargets();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (ResourceBundle.BindingTargetBundle)element$iv$iv;
            boolean bl = false;
            if (!(it.getId() != null)) continue;
            collection.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            ResourceBundle.BindingTargetBundle it2 = (ResourceBundle.BindingTargetBundle)t;
            boolean bl = false;
            TypeName fieldType = ExtKt.toTypeName(CommonKt.getFieldType(it2), this$0.libTypes, this$0.model.getImportsByAlias());
            $this$constructorSpec.addParameter(Javapoet_extKt.parameterSpec$default(fieldType, this$0.model.fieldName(it2), null, 4, null));
        }
        $this$forEach$iv = new Object[]{componentParam, viewParam, localFieldCountParam};
        $this$constructorSpec.addStatement("super($N, $N, $N)", $this$forEach$iv);
        $this$filter$iv = this$0.model.getSortedTargets();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        Collection collection2 = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (ResourceBundle.BindingTargetBundle)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getId() != null)) continue;
            collection2.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection2;
        $i$f$forEach = false;
        for (Object e : $this$forEach$iv) {
            ResourceBundle.BindingTargetBundle it3 = (ResourceBundle.BindingTargetBundle)e;
            boolean bl3 = false;
            String fieldName = this$0.model.fieldName(it3);
            Object[] objectArray = new Object[]{fieldName};
            $this$constructorSpec.addStatement("this.$1L = $1L", objectArray);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createVariableFields$lambda$0$0(BaseLayoutBinderWriter this$0, FieldSpec.Builder $this$fieldSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$fieldSpec, (String)"$this$fieldSpec");
        $this$fieldSpec.addAnnotation(this$0.bindable);
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        $this$fieldSpec.addModifiers(modifierArray);
        return Unit.INSTANCE;
    }

    private static final Unit createBindingTargetFields$lambda$1$0(ResourceBundle.BindingTargetBundle $it, BaseLayoutBinderWriter this$0, FieldSpec.Builder $this$fieldSpec) {
        FieldSpec.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$fieldSpec, (String)"$this$fieldSpec");
        Modifier[] modifierArray = new Modifier[]{Modifier.FINAL};
        $this$fieldSpec.addModifiers(modifierArray);
        modifierArray = new Modifier[]{$it.getId() != null ? Modifier.PUBLIC : Modifier.PRIVATE};
        $this$fieldSpec.addModifiers(modifierArray);
        modifierArray = this$0.model.layoutConfigurationMembership($it);
        List present = (List)modifierArray.component1();
        List absent = (List)modifierArray.component2();
        if (!((Collection)absent).isEmpty()) {
            $this$fieldSpec.addJavadoc(CommonKt.renderConfigurationJavadoc(present, absent), new Object[0]);
            builder = $this$fieldSpec.addAnnotation(this$0.nullable);
        } else {
            builder = $this$fieldSpec.addAnnotation(this$0.nonNull);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroid/databinding/tool/writer/BaseLayoutBinderWriter$Companion;", "", "<init>", "()V", "DEPRECATED", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "JAVADOC_BINDING_COMPONENT", "", "db-compilerCommon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

