/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection.annotation;

import android.databinding.tool.BindableCompat;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.SdkUtil;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.reflection.annotation.AnnotationAnalyzer;
import android.databinding.tool.reflection.annotation.AnnotationClass;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class AnnotationMethod
extends ModelMethod {
    final ExecutableType mMethod;
    final DeclaredType mDeclaringType;
    final ExecutableElement mExecutableElement;
    int mApiLevel = -1;
    ModelClass mReceiverType;

    public AnnotationMethod(DeclaredType declaringType, ExecutableElement executableElement) {
        this.mDeclaringType = declaringType;
        this.mExecutableElement = executableElement;
        Types typeUtils = AnnotationAnalyzer.get().getTypeUtils();
        this.mMethod = (ExecutableType)typeUtils.asMemberOf(declaringType, executableElement);
    }

    @Override
    public ModelClass getReceiverType() {
        if (this.mReceiverType == null) {
            this.mReceiverType = this.findReceiverType(this.mDeclaringType);
            if (this.mReceiverType == null) {
                this.mReceiverType = new AnnotationClass(this.mDeclaringType);
            }
        }
        return this.mReceiverType;
    }

    @Override
    public ModelClass getDeclaringClass() {
        return new AnnotationClass(this.mDeclaringType);
    }

    private ModelClass findReceiverType(DeclaredType subType) {
        List<? extends TypeMirror> supers = AnnotationMethod.getTypeUtils().directSupertypes(subType);
        for (TypeMirror typeMirror : supers) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            ModelClass inSuper = this.findReceiverType(declaredType);
            if (inSuper != null) {
                return inSuper;
            }
            if (!this.hasExecutableMethod(declaredType)) continue;
            return new AnnotationClass(declaredType);
        }
        return null;
    }

    private boolean hasExecutableMethod(DeclaredType declaredType) {
        Elements elementUtils = AnnotationMethod.getElementUtils();
        TypeElement enclosing = (TypeElement)this.mExecutableElement.getEnclosingElement();
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement executableElement;
            if (element.getKind() != ElementKind.METHOD || !(executableElement = (ExecutableElement)element).equals(this.mExecutableElement) && !elementUtils.overrides(this.mExecutableElement, executableElement, enclosing)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModelClass[] getParameterTypes() {
        List<? extends TypeMirror> parameters = this.mMethod.getParameterTypes();
        ModelClass[] parameterTypes = new ModelClass[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            parameterTypes[i] = new AnnotationClass(parameters.get(i));
        }
        return parameterTypes;
    }

    @Override
    public String getName() {
        return this.mExecutableElement.getSimpleName().toString();
    }

    @Override
    public ModelClass getReturnType(List<ModelClass> args) {
        TypeMirror returnType = this.mMethod.getReturnType();
        return new AnnotationClass(returnType);
    }

    @Override
    public boolean isVoid() {
        return this.mMethod.getReturnType().getKind() == TypeKind.VOID;
    }

    @Override
    public boolean isPublic() {
        return this.mExecutableElement.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public boolean isProtected() {
        return this.mExecutableElement.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    @Override
    public boolean isStatic() {
        return this.mExecutableElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isAbstract() {
        return this.mExecutableElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public BindableCompat getBindableAnnotation() {
        return BindableCompat.extractFrom(this.mExecutableElement);
    }

    @Override
    public int getMinApi() {
        if (this.mApiLevel == -1) {
            this.mApiLevel = SdkUtil.get().getMinApi(this);
        }
        return this.mApiLevel;
    }

    @Override
    public String getJniDescription() {
        return TypeUtil.getInstance().getDescription(this);
    }

    @Override
    public boolean isVarArgs() {
        return this.mExecutableElement.isVarArgs();
    }

    private static Types getTypeUtils() {
        return AnnotationAnalyzer.get().mProcessingEnv.getTypeUtils();
    }

    private static Elements getElementUtils() {
        return AnnotationAnalyzer.get().mProcessingEnv.getElementUtils();
    }

    public String toString() {
        return "AnnotationMethod{mMethod=" + this.mMethod + ", mDeclaringType=" + this.mDeclaringType + ", mExecutableElement=" + this.mExecutableElement + ", mApiLevel=" + this.mApiLevel + '}';
    }
}

