/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.modules;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.EDT;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModulesHandler;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.modules.CidrDebuggerModuleData;
import com.jetbrains.cidr.execution.debugger.modules.CidrDebuggerModulesStorageKt;
import com.jetbrains.cidr.execution.debugger.modules.CidrDebuggerModulesStorageListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u001c\u001a\u00020\u0012J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000eH\u0002J\u0016\u0010%\u001a\u00020\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000eH\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020$0\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00190\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModulesStorage;", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "myLoadModuleHappened", "", "myEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModulesStorageListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "modulesList", "", "Lcom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModuleData;", "modulesPathToCounterMap", "", "", "", "loadingOrderCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "modulesNameToPathsMap", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "getModulesData", "getModulesPathByName", "moduleName", "addModulesListener", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "handleModulesLoaded", "modules", "Lcom/jetbrains/cidr/execution/debugger/backend/LLModule;", "handleModulesUnloaded", "removeInternalModules", "Companion", "CidrDebuggerModulesStoragePopulator", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrDebuggerModulesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDebuggerModulesStorage.kt\ncom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModulesStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n774#2:165\n865#2,2:166\n*S KotlinDebug\n*F\n+ 1 CidrDebuggerModulesStorage.kt\ncom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModulesStorage\n*L\n151#1:165\n151#1:166,2\n*E\n"})
public final class CidrDebuggerModulesStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CidrDebugProcess process;
    private boolean myLoadModuleHappened;
    @NotNull
    private final EventDispatcher<CidrDebuggerModulesStorageListener> myEventDispatcher;
    @NotNull
    private final List<CidrDebuggerModuleData> modulesList;
    @NotNull
    private final Map<String, Integer> modulesPathToCounterMap;
    @NotNull
    private final AtomicInteger loadingOrderCounter;
    @NotNull
    private AtomicReference<Map<String, List<String>>> modulesNameToPathsMap;

    private CidrDebuggerModulesStorage(CidrDebugProcess process) {
        this.process = process;
        EventDispatcher eventDispatcher = EventDispatcher.create(CidrDebuggerModulesStorageListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.myEventDispatcher = eventDispatcher;
        this.modulesList = new ArrayList();
        this.modulesPathToCounterMap = new LinkedHashMap();
        this.loadingOrderCounter = new AtomicInteger(1);
        this.modulesNameToPathsMap = new AtomicReference<Map>(MapsKt.emptyMap());
    }

    @NotNull
    public final List<CidrDebuggerModuleData> getModulesData() {
        EDT.assertIsEdt();
        return CollectionsKt.toList((Iterable)this.modulesList);
    }

    @NotNull
    public final List<String> getModulesPathByName(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        List list = this.modulesNameToPathsMap.get().get(moduleName);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void addModulesListener(@NotNull CidrDebuggerModulesStorageListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.myEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    private final void handleModulesLoaded(List<LLModule> modules) {
        if (modules.isEmpty()) {
            return;
        }
        this.myLoadModuleHappened = true;
        List<LLModule> localModuleList = this.removeInternalModules(modules);
        CoroutineScope coroutineScope = this.process.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(localModuleList, this, null){
            int label;
            final /* synthetic */ List<LLModule> $localModuleList;
            final /* synthetic */ CidrDebuggerModulesStorage this$0;
            {
                this.$localModuleList = $localModuleList;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        List addedModules = new ArrayList<E>();
                        Iterable iterable = this.$localModuleList;
                        CidrDebuggerModulesStorage cidrDebuggerModulesStorage = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Logger $this$trace$iv;
                            Logger logger;
                            Logger $this$trace$iv2;
                            LLModule changedModule = (LLModule)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)CidrDebuggerLog.LOG, (String)"LOG");
                            boolean $i$f$trace = false;
                            if ($this$trace$iv2.isTraceEnabled()) {
                                logger = $this$trace$iv2;
                                boolean bl2 = false;
                                logger.trace("Module " + changedModule.getName() + " loaded");
                            }
                            Integer loadedTimes = (Integer)CidrDebuggerModulesStorage.access$getModulesPathToCounterMap$p(cidrDebuggerModulesStorage).get(changedModule.getPath());
                            if (loadedTimes != null) {
                                Logger $this$trace$iv3;
                                CidrDebuggerModulesStorage.access$getModulesPathToCounterMap$p(cidrDebuggerModulesStorage).put(changedModule.getPath(), Boxing.boxInt((int)(loadedTimes + 1)));
                                Intrinsics.checkNotNullExpressionValue((Object)CidrDebuggerLog.LOG, (String)"LOG");
                                boolean $i$f$trace2 = false;
                                if (!$this$trace$iv3.isTraceEnabled()) continue;
                                logger = $this$trace$iv3;
                                boolean bl3 = false;
                                logger.trace("Module " + changedModule.getName() + " already loaded so incrementing loaded times to " + loadedTimes);
                                continue;
                            }
                            int loadOrder = CidrDebuggerModulesStorage.access$getLoadingOrderCounter$p(cidrDebuggerModulesStorage).getAndIncrement();
                            String string = changedModule.getName();
                            String string2 = changedModule.getPath();
                            UUID uUID = UUID.randomUUID();
                            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
                            CidrDebuggerModuleData cidrModule = new CidrDebuggerModuleData(string, string2, loadOrder, uUID);
                            CidrDebuggerModulesStorage.access$getModulesPathToCounterMap$p(cidrDebuggerModulesStorage).put(changedModule.getPath(), Boxing.boxInt((int)1));
                            addedModules.add(cidrModule);
                            Intrinsics.checkNotNullExpressionValue((Object)CidrDebuggerLog.LOG, (String)"LOG");
                            boolean $i$f$trace3 = false;
                            if (!$this$trace$iv.isTraceEnabled()) continue;
                            logger = $this$trace$iv;
                            boolean bl4 = false;
                            logger.trace("Module " + changedModule.getName() + " added to module list");
                        }
                        CidrDebuggerModulesStorage.access$getModulesList$p(this.this$0).addAll(addedModules);
                        V v = CidrDebuggerModulesStorage.access$getModulesNameToPathsMap$p(this.this$0).get();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
                        Map nameToPaths = MapsKt.toMutableMap((Map)((Map)v));
                        Iterable $this$forEach$iv2 = addedModules;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv2) {
                            CidrDebuggerModuleData it = (CidrDebuggerModuleData)element$iv;
                            boolean bl = false;
                            Object object = NioPathUtil.toNioPathOrNull((String)it.getPath());
                            if (object == null || (object = PathsKt.getInvariantSeparatorsPathString((Path)object)) == null) continue;
                            Object path = object;
                            nameToPaths.put(it.getName(), CollectionsKt.plus((Collection)nameToPaths.getOrDefault(it.getName(), CollectionsKt.emptyList()), (Object)path));
                        }
                        CidrDebuggerModulesStorage.access$getModulesNameToPathsMap$p(this.this$0).set(MapsKt.toMap((Map)nameToPaths));
                        $this$forEach$iv2 = addedModules;
                        CidrDebuggerModulesStorage cidrDebuggerModulesStorage2 = this.this$0;
                        boolean $i$f$forEach2 = false;
                        for (T element$iv : $this$forEach$iv2) {
                            CidrDebuggerModuleData it = (CidrDebuggerModuleData)element$iv;
                            boolean bl = false;
                            ((CidrDebuggerModulesStorageListener)CidrDebuggerModulesStorage.access$getMyEventDispatcher$p(cidrDebuggerModulesStorage2).getMulticaster()).handleCidrModuleAdded(it);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void handleModulesUnloaded(List<LLModule> modules) {
        if (modules.isEmpty()) {
            return;
        }
        List<LLModule> localModuleList = this.removeInternalModules(modules);
        CoroutineScope coroutineScope = this.process.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(localModuleList, this, null){
            int label;
            final /* synthetic */ List<LLModule> $localModuleList;
            final /* synthetic */ CidrDebuggerModulesStorage this$0;
            {
                this.$localModuleList = $localModuleList;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        List removedModules = new ArrayList<E>();
                        Iterable iterable = this.$localModuleList;
                        CidrDebuggerModulesStorage cidrDebuggerModulesStorage = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Logger logger;
                            Logger $this$trace$iv;
                            LLModule changedModule = (LLModule)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)CidrDebuggerLog.LOG, (String)"LOG");
                            boolean $i$f$trace = false;
                            if ($this$trace$iv.isTraceEnabled()) {
                                logger = $this$trace$iv;
                                boolean bl2 = false;
                                logger.trace("Module " + changedModule.getName() + " unloaded");
                            }
                            Integer loadedTimes = (Integer)CidrDebuggerModulesStorage.access$getModulesPathToCounterMap$p(cidrDebuggerModulesStorage).get(changedModule.getPath());
                            if (loadedTimes != null) {
                                Logger $this$trace$iv22;
                                Intrinsics.checkNotNullExpressionValue((Object)CidrDebuggerLog.LOG, (String)"LOG");
                                boolean $i$f$trace2 = false;
                                if ($this$trace$iv22.isTraceEnabled()) {
                                    logger = $this$trace$iv22;
                                    boolean bl3 = false;
                                    logger.trace("Module " + changedModule.getPath() + " found in module map");
                                }
                                int $this$trace$iv22 = 1;
                                if (loadedTimes == $this$trace$iv22) {
                                    T element$iv2;
                                    CidrDebuggerModuleData it;
                                    CidrDebuggerModulesStorage.access$getModulesPathToCounterMap$p(cidrDebuggerModulesStorage).remove(changedModule.getPath());
                                    Iterable $this$first$iv = CidrDebuggerModulesStorage.access$getModulesList$p(cidrDebuggerModulesStorage);
                                    boolean $i$f$first = false;
                                    Iterator<T> iterator = $this$first$iv.iterator();
                                    do {
                                        if (!iterator.hasNext()) {
                                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                                        }
                                        element$iv2 = iterator.next();
                                        it = (CidrDebuggerModuleData)element$iv2;
                                        boolean bl4 = false;
                                    } while (!Intrinsics.areEqual((Object)it.getPath(), (Object)changedModule.getPath()));
                                    CidrDebuggerModuleData cidrModule = (CidrDebuggerModuleData)element$iv2;
                                    Boxing.boxBoolean((boolean)removedModules.add(cidrModule));
                                    continue;
                                }
                                CidrDebuggerModulesStorage.access$getModulesPathToCounterMap$p(cidrDebuggerModulesStorage).put(changedModule.getPath(), Boxing.boxInt((int)(loadedTimes - 1)));
                                continue;
                            }
                            if (!CidrDebuggerModulesStorage.access$getMyLoadModuleHappened$p(cidrDebuggerModulesStorage)) continue;
                            CidrDebuggerLog.LOG.warn("Module " + changedModule.getName() + " not found in module map");
                        }
                        CidrDebuggerModulesStorage.access$getModulesList$p(this.this$0).removeAll(removedModules);
                        V v = CidrDebuggerModulesStorage.access$getModulesNameToPathsMap$p(this.this$0).get();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
                        Map nameToPaths = MapsKt.toMutableMap((Map)((Map)v));
                        Iterable $this$forEach$iv2 = removedModules;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv2) {
                            List pathsList;
                            Object object;
                            CidrDebuggerModuleData it = (CidrDebuggerModuleData)element$iv;
                            boolean bl = false;
                            if ((List)nameToPaths.get(it.getName()) == null || (object = NioPathUtil.toNioPathOrNull((String)it.getPath())) == null || (object = PathsKt.getInvariantSeparatorsPathString((Path)object)) == null) continue;
                            Object path = object;
                            List newPathsList = CollectionsKt.minus((Iterable)pathsList, (Object)path);
                            if (newPathsList.isEmpty()) {
                                nameToPaths.remove(it.getName());
                                continue;
                            }
                            nameToPaths.put(it.getName(), newPathsList);
                        }
                        CidrDebuggerModulesStorage.access$getModulesNameToPathsMap$p(this.this$0).set(MapsKt.toMap((Map)nameToPaths));
                        $this$forEach$iv2 = removedModules;
                        CidrDebuggerModulesStorage cidrDebuggerModulesStorage2 = this.this$0;
                        boolean $i$f$forEach2 = false;
                        Iterator<T> iterator = $this$forEach$iv2.iterator();
                        while (iterator.hasNext()) {
                            T element$iv = iterator.next();
                            CidrDebuggerModuleData it = (CidrDebuggerModuleData)element$iv;
                            boolean bl = false;
                            ((CidrDebuggerModulesStorageListener)CidrDebuggerModulesStorage.access$getMyEventDispatcher$p(cidrDebuggerModulesStorage2).getMulticaster()).handleCidrModuleRemoved(it);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LLModule> removeInternalModules(List<LLModule> modules) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = modules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LLModule it = (LLModule)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.startsWith$default((String)it.getName(), (String)"_$__lldb", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public /* synthetic */ CidrDebuggerModulesStorage(CidrDebugProcess process, DefaultConstructorMarker $constructor_marker) {
        this(process);
    }

    public static final /* synthetic */ List access$getModulesList$p(CidrDebuggerModulesStorage $this) {
        return $this.modulesList;
    }

    public static final /* synthetic */ AtomicReference access$getModulesNameToPathsMap$p(CidrDebuggerModulesStorage $this) {
        return $this.modulesNameToPathsMap;
    }

    public static final /* synthetic */ Map access$getModulesPathToCounterMap$p(CidrDebuggerModulesStorage $this) {
        return $this.modulesPathToCounterMap;
    }

    public static final /* synthetic */ AtomicInteger access$getLoadingOrderCounter$p(CidrDebuggerModulesStorage $this) {
        return $this.loadingOrderCounter;
    }

    public static final /* synthetic */ EventDispatcher access$getMyEventDispatcher$p(CidrDebuggerModulesStorage $this) {
        return $this.myEventDispatcher;
    }

    public static final /* synthetic */ boolean access$getMyLoadModuleHappened$p(CidrDebuggerModulesStorage $this) {
        return $this.myLoadModuleHappened;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModulesStorage$CidrDebuggerModulesStoragePopulator;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerModulesHandler;", "<init>", "()V", "handleModulesLoaded", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "modules", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLModule;", "handleModulesUnloaded", "intellij.cidr.debugger.core"})
    public static final class CidrDebuggerModulesStoragePopulator
    implements CidrDebuggerModulesHandler {
        @Override
        public void handleModulesLoaded(@NotNull CidrDebugProcess process, @NotNull List<LLModule> modules) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            Companion.getInstance(process).handleModulesLoaded(modules);
        }

        @Override
        public void handleModulesUnloaded(@NotNull CidrDebugProcess process, @NotNull List<LLModule> modules) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            Companion.getInstance(process).handleModulesUnloaded(modules);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModulesStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModulesStorage;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "intellij.cidr.debugger.core"})
    @SourceDebugExtension(value={"SMAP\nCidrDebuggerModulesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDebuggerModulesStorage.kt\ncom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModulesStorage$Companion\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n11#2:165\n12#2:167\n1#3:166\n*S KotlinDebug\n*F\n+ 1 CidrDebuggerModulesStorage.kt\ncom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModulesStorage$Companion\n*L\n27#1:165\n27#1:167\n27#1:166\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CidrDebuggerModulesStorage getInstance(@NotNull CidrDebugProcess process) {
            Object object;
            void $this$getOrCreateUserData$iv;
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            UserDataHolderEx userDataHolderEx = process;
            Key key$iv = CidrDebuggerModulesStorageKt.access$getMyModulesStorageKey$p();
            boolean $i$f$getOrCreateUserData = false;
            Object object2 = $this$getOrCreateUserData$iv.getUserData(key$iv);
            if (object2 != null) {
                Object it$iv = object2;
                boolean bl = false;
                object = it$iv;
            } else {
                Key key = key$iv;
                void var8_8 = $this$getOrCreateUserData$iv;
                boolean bl = false;
                CidrDebuggerModulesStorage cidrDebuggerModulesStorage = new CidrDebuggerModulesStorage(process, null);
                Object object3 = var8_8.putUserDataIfAbsent(key, (Object)cidrDebuggerModulesStorage);
                object = object3;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"putUserDataIfAbsent(...)");
            }
            return (CidrDebuggerModulesStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

