/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi.HexdumpElementType;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi.HexdumpTokenType;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi.impl.HexdumpDirectiveImpl;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi.impl.HexdumpLineImpl;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi.impl.HexdumpParaImpl;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi.impl.HexdumpWordImpl;

public interface HexdumpParserTypes {
    public static final IElementType DIRECTIVE = new HexdumpElementType("DIRECTIVE");
    public static final IElementType LINE = new HexdumpElementType("LINE");
    public static final IElementType PARA = new HexdumpElementType("PARA");
    public static final IElementType WORD = new HexdumpElementType("WORD");
    public static final IElementType BLOCK_COMMENT = new HexdumpTokenType("BLOCK_COMMENT");
    public static final IElementType DIRECTIVE_CHARACTER = new HexdumpTokenType("DIRECTIVE_CHARACTER");
    public static final IElementType DIRECTIVE_NAME = new HexdumpTokenType("DIRECTIVE_NAME");
    public static final IElementType EOL = new HexdumpTokenType("EOL");
    public static final IElementType FOLDING_PLACEHOLDER = new HexdumpTokenType("FOLDING_PLACEHOLDER");
    public static final IElementType HEXBYTE = new HexdumpTokenType("HEXBYTE");
    public static final IElementType INTEGER = new HexdumpTokenType("INTEGER");
    public static final IElementType LABEL = new HexdumpTokenType("LABEL");
    public static final IElementType LINE_COMMENT = new HexdumpTokenType("LINE_COMMENT");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == DIRECTIVE) {
                return new HexdumpDirectiveImpl(node);
            }
            if (type == LINE) {
                return new HexdumpLineImpl(node);
            }
            if (type == PARA) {
                return new HexdumpParaImpl(node);
            }
            if (type == WORD) {
                return new HexdumpWordImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

