/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\u001a\u001d\u0010\u0000\u001a\u0002H\u0001\"\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u0002H\u0001\u00a2\u0006\u0002\u0010\u0003\u001a1\u0010\u0000\u001a\u0002H\u0001\"\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u0002H\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u001d\u0010\b\u001a\u0002H\u0001\"\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u0002H\u0001\u00a2\u0006\u0002\u0010\u0003\u001a1\u0010\b\u001a\u0002H\u0001\"\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u0002H\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a&\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000b\u001a\u00020\n\u001a&\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\f\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a&\u0010\f\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\u0013\u001a\u00020\n*\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017*\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0019\u0010\u0018\u001a\u00020\n*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0015H\u0007\u00a2\u0006\u0002\b\u001a\u001a\u0012\u0010\u0018\u001a\u00020\n*\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0012\u0010\u001d\u001a\u00020\n*\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0012\u0010 \u001a\u00020\r*\u00020\r2\u0006\u0010!\u001a\u00020\u001c\u001a\u0012\u0010\"\u001a\u00020\r*\u00020\r2\u0006\u0010!\u001a\u00020\u001c\u001a\u0012\u0010#\u001a\u00020\u0015*\u00020\r2\u0006\u0010!\u001a\u00020\u001c\u001a\u0012\u0010 \u001a\u00020\u0015*\u00020\u00152\u0006\u0010!\u001a\u00020\u001c\u001a\u0012\u0010\"\u001a\u00020\u0015*\u00020\u00152\u0006\u0010!\u001a\u00020\u001c\u001a\u0014\u0010$\u001a\u00020\u0015*\u00020\u00152\u0006\u0010!\u001a\u00020\u001cH\u0002\u001a\u001a\u0010%\u001a\u00020\n*\u00020\r2\u0006\u0010&\u001a\u00020\rH\u0087\u0006\u00a2\u0006\u0002\b'\u001a\u001a\u0010(\u001a\u00020\n*\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0087\u0004\u00a2\u0006\u0002\b)\u001a\u0015\u0010*\u001a\u00020\n*\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0086\u0004\"\u0015\u0010\u000e\u001a\u00020\r*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\r*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006+"}, d2={"checkNotEmpty", "T", "Lkotlin/ranges/ClosedRange;", "(Lkotlin/ranges/ClosedRange;)Lkotlin/ranges/ClosedRange;", "lazyMessage", "Lkotlin/Function0;", "", "(Lkotlin/ranges/ClosedRange;Lkotlin/jvm/functions/Function0;)Lkotlin/ranges/ClosedRange;", "requireNotEmpty", "checkInRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "range", "requireInRange", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "endCoerced", "getEndCoerced", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "endExclusive", "getEndExclusive", "grow", "boundary", "", "slice", "Lkotlin/sequences/Sequence;", "toRange", "offsetBytes", "addressToRange", "bytes", "", "toAlignedBlockRange", "blockSize", "", "roundUp", "n", "roundDown", "reminder", "positiveReminder", "rangeTo", "endInclusive", "addressRangeInclusive", "rangeToExclusive", "addressRangeExclusive", "until", "intellij.cidr.debugger.backend"})
@JvmName(name="AddressUtil")
@SourceDebugExtension(value={"SMAP\nAddressUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddressUtil.kt\ncom/jetbrains/cidr/execution/debugger/memory/AddressUtil\n*L\n1#1,103:1\n10#1,3:104\n15#1,3:107\n20#1,3:110\n25#1,3:113\n30#1,3:116\n*S KotlinDebug\n*F\n+ 1 AddressUtil.kt\ncom/jetbrains/cidr/execution/debugger/memory/AddressUtil\n*L\n9#1:104,3\n14#1:107,3\n19#1:110,3\n24#1:113,3\n29#1:116,3\n*E\n"})
public final class AddressUtil {
    @NotNull
    public static final <T extends ClosedRange<?>> T checkNotEmpty(@NotNull T $this$checkNotEmpty) {
        T t;
        Intrinsics.checkNotNullParameter($this$checkNotEmpty, (String)"<this>");
        T $this$checkNotEmpty$iv = $this$checkNotEmpty;
        boolean $i$f$checkNotEmpty = false;
        T $this$checkNotEmpty_u24lambda_u241$iv = t = $this$checkNotEmpty$iv;
        boolean bl = false;
        if (!(!$this$checkNotEmpty_u24lambda_u241$iv.isEmpty())) {
            boolean bl2 = false;
            String string = "Range must not be empty";
            throw new IllegalStateException(string.toString());
        }
        return t;
    }

    @NotNull
    public static final <T extends ClosedRange<?>> T checkNotEmpty(@NotNull T $this$checkNotEmpty, @NotNull Function0<? extends Object> lazyMessage) {
        T t;
        Intrinsics.checkNotNullParameter($this$checkNotEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        boolean $i$f$checkNotEmpty = false;
        T $this$checkNotEmpty_u24lambda_u241 = t = $this$checkNotEmpty;
        boolean bl = false;
        if (!(!$this$checkNotEmpty_u24lambda_u241.isEmpty())) {
            Object object = lazyMessage.invoke();
            throw new IllegalStateException(object.toString());
        }
        return t;
    }

    @NotNull
    public static final <T extends ClosedRange<?>> T requireNotEmpty(@NotNull T $this$requireNotEmpty) {
        T t;
        Intrinsics.checkNotNullParameter($this$requireNotEmpty, (String)"<this>");
        T $this$requireNotEmpty$iv = $this$requireNotEmpty;
        boolean $i$f$requireNotEmpty = false;
        T $this$requireNotEmpty_u24lambda_u243$iv = t = $this$requireNotEmpty$iv;
        boolean bl = false;
        if (!(!$this$requireNotEmpty_u24lambda_u243$iv.isEmpty())) {
            boolean bl2 = false;
            String string = "Range must not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        return t;
    }

    @NotNull
    public static final <T extends ClosedRange<?>> T requireNotEmpty(@NotNull T $this$requireNotEmpty, @NotNull Function0<? extends Object> lazyMessage) {
        T t;
        Intrinsics.checkNotNullParameter($this$requireNotEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        boolean $i$f$requireNotEmpty = false;
        T $this$requireNotEmpty_u24lambda_u243 = t = $this$requireNotEmpty;
        boolean bl = false;
        if (!(!$this$requireNotEmpty_u24lambda_u243.isEmpty())) {
            Object object = lazyMessage.invoke();
            throw new IllegalArgumentException(object.toString());
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final AddressRange checkInRange(@NotNull AddressRange $this$checkInRange, @NotNull AddressRange range) {
        void $this$checkInRange$iv;
        void var5_5;
        Intrinsics.checkNotNullParameter((Object)$this$checkInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        AddressRange addressRange = $this$checkInRange;
        AddressRange range$iv = range;
        boolean $i$f$checkInRange = false;
        void $this$checkInRange_u24lambda_u245$iv = var5_5 = $this$checkInRange$iv;
        boolean bl = false;
        if (!range$iv.contains((AddressRange)$this$checkInRange_u24lambda_u245$iv)) {
            boolean bl2 = false;
            String string = "Range " + $this$checkInRange + " spans beyond the allowed " + range;
            throw new IllegalStateException(string.toString());
        }
        return var5_5;
    }

    @NotNull
    public static final AddressRange checkInRange(@NotNull AddressRange $this$checkInRange, @NotNull AddressRange range, @NotNull Function0<? extends Object> lazyMessage) {
        AddressRange addressRange;
        Intrinsics.checkNotNullParameter((Object)$this$checkInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        boolean $i$f$checkInRange = false;
        AddressRange $this$checkInRange_u24lambda_u245 = addressRange = $this$checkInRange;
        boolean bl = false;
        if (!range.contains($this$checkInRange_u24lambda_u245)) {
            Object object = lazyMessage.invoke();
            throw new IllegalStateException(object.toString());
        }
        return addressRange;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Address requireInRange(@NotNull Address $this$requireInRange, @NotNull AddressRange range) {
        void $this$requireInRange$iv;
        void var5_5;
        Intrinsics.checkNotNullParameter((Object)$this$requireInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Address address = $this$requireInRange;
        AddressRange range$iv = range;
        boolean $i$f$requireInRange = false;
        void $this$requireInRange_u24lambda_u247$iv = var5_5 = $this$requireInRange$iv;
        boolean bl = false;
        if (!range$iv.contains((Comparable)$this$requireInRange_u24lambda_u247$iv)) {
            boolean bl2 = false;
            String string = "Address " + $this$requireInRange + " must be within " + range;
            throw new IllegalArgumentException(string.toString());
        }
        return var5_5;
    }

    @NotNull
    public static final Address requireInRange(@NotNull Address $this$requireInRange, @NotNull AddressRange range, @NotNull Function0<? extends Object> lazyMessage) {
        Address address;
        Intrinsics.checkNotNullParameter((Object)$this$requireInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        boolean $i$f$requireInRange = false;
        Address $this$requireInRange_u24lambda_u247 = address = $this$requireInRange;
        boolean bl = false;
        if (!range.contains((Comparable)$this$requireInRange_u24lambda_u247)) {
            Object object = lazyMessage.invoke();
            throw new IllegalArgumentException(object.toString());
        }
        return address;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final AddressRange requireInRange(@NotNull AddressRange $this$requireInRange, @NotNull AddressRange range) {
        void $this$requireInRange$iv;
        void var5_5;
        Intrinsics.checkNotNullParameter((Object)$this$requireInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        AddressRange addressRange = $this$requireInRange;
        AddressRange range$iv = range;
        boolean $i$f$requireInRange = false;
        void $this$requireInRange_u24lambda_u249$iv = var5_5 = $this$requireInRange$iv;
        boolean bl = false;
        if (!range$iv.contains((AddressRange)$this$requireInRange_u24lambda_u249$iv)) {
            boolean bl2 = false;
            String string = "Range " + $this$requireInRange + " must be within " + range;
            throw new IllegalArgumentException(string.toString());
        }
        return var5_5;
    }

    @NotNull
    public static final AddressRange requireInRange(@NotNull AddressRange $this$requireInRange, @NotNull AddressRange range, @NotNull Function0<? extends Object> lazyMessage) {
        AddressRange addressRange;
        Intrinsics.checkNotNullParameter((Object)$this$requireInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        boolean $i$f$requireInRange = false;
        AddressRange $this$requireInRange_u24lambda_u249 = addressRange = $this$requireInRange;
        boolean bl = false;
        if (!range.contains($this$requireInRange_u24lambda_u249)) {
            Object object = lazyMessage.invoke();
            throw new IllegalArgumentException(object.toString());
        }
        return addressRange;
    }

    @NotNull
    public static final Address getEndCoerced(@NotNull AddressRange $this$endCoerced) {
        Intrinsics.checkNotNullParameter((Object)$this$endCoerced, (String)"<this>");
        return $this$endCoerced.getEndInclusive().plus(Address.Companion.getCoercing(1));
    }

    @NotNull
    public static final Address getEndExclusive(@NotNull AddressRange $this$endExclusive) {
        Intrinsics.checkNotNullParameter((Object)$this$endExclusive, (String)"<this>");
        return $this$endExclusive.getEndInclusive().plus(1);
    }

    @NotNull
    public static final AddressRange grow(@NotNull AddressRange $this$grow, long boundary) {
        Intrinsics.checkNotNullParameter((Object)$this$grow, (String)"<this>");
        return AddressUtil.addressRangeExclusive(AddressUtil.roundDown($this$grow.getStart(), (Number)boundary), AddressUtil.roundUp(AddressUtil.getEndExclusive($this$grow), (Number)boundary));
    }

    @NotNull
    public static final Sequence<AddressRange> slice(@NotNull AddressRange $this$slice, long boundary) {
        Intrinsics.checkNotNullParameter((Object)$this$slice, (String)"<this>");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super AddressRange>, Continuation<? super Unit>, Object>($this$slice, boundary, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AddressRange $this_slice;
            final /* synthetic */ long $boundary;
            {
                this.$this_slice = $receiver;
                this.$boundary = $boundary;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$this_slice.isEmpty()) {
                            return Unit.INSTANCE;
                        }
                        prev = this.$this_slice.getStart();
lbl10:
                        // 2 sources

                        while (true) {
                            next = (Address)RangesKt.coerceAtMost((Comparable)AddressUtil.roundUp(prev, (Number)Boxing.boxLong((long)this.$boundary)), (Comparable)this.$this_slice.getEndInclusive());
                            this.L$0 = $this$sequence;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)prev);
                            this.L$2 = next;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)AddressUtil.addressRangeInclusive(prev, next), (Continuation)this);
                            if (v0 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl25
                            break;
                        }
                    }
                    case 1: {
                        next = (Address)this.L$2;
                        prev = (Address)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        if (!Intrinsics.areEqual((Object)next, (Object)this.$this_slice.getEndInclusive())) {
                            prev = next.plus(Boxing.boxInt((int)1));
                            ** continue;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super AddressRange> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @JvmName(name="addressToRange")
    @NotNull
    public static final AddressRange addressToRange(@NotNull Address $this$toRange, long offsetBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$toRange, (String)"<this>");
        return offsetBytes == 1L ? AddressUtil.addressRangeInclusive($this$toRange, $this$toRange) : (offsetBytes > 0L ? AddressUtil.addressRangeExclusive($this$toRange, $this$toRange.plus(offsetBytes)) : (offsetBytes < 0L ? AddressUtil.addressRangeExclusive($this$toRange.plus(offsetBytes), $this$toRange) : AddressRange.EMPTY));
    }

    @NotNull
    public static final AddressRange toRange(@NotNull Address $this$toRange, @NotNull Number bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$toRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return AddressUtil.addressToRange($this$toRange, bytes.longValue());
    }

    @NotNull
    public static final AddressRange toAlignedBlockRange(@NotNull Address $this$toAlignedBlockRange, int blockSize) {
        boolean bl;
        AddressRange addressRange;
        Intrinsics.checkNotNullParameter((Object)$this$toAlignedBlockRange, (String)"<this>");
        AddressRange it = addressRange = AddressUtil.toRange(AddressUtil.roundDown($this$toAlignedBlockRange, (Number)blockSize), blockSize);
        boolean bl2 = false;
        boolean bl3 = bl = it.getSize() == (long)blockSize;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return addressRange;
    }

    @NotNull
    public static final Address roundUp(@NotNull Address $this$roundUp, @NotNull Number n) {
        Intrinsics.checkNotNullParameter((Object)$this$roundUp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return Address.Companion.fromUnsignedLong(AddressUtil.roundUp($this$roundUp.getUnsignedLongValue(), n));
    }

    @NotNull
    public static final Address roundDown(@NotNull Address $this$roundDown, @NotNull Number n) {
        Intrinsics.checkNotNullParameter((Object)$this$roundDown, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return Address.Companion.fromUnsignedLong(AddressUtil.roundDown($this$roundDown.getUnsignedLongValue(), n));
    }

    public static final long reminder(@NotNull Address $this$reminder, @NotNull Number n) {
        Intrinsics.checkNotNullParameter((Object)$this$reminder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return AddressUtil.positiveReminder($this$reminder.getUnsignedLongValue(), n);
    }

    public static final long roundUp(long $this$roundUp, @NotNull Number n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return AddressUtil.roundDown($this$roundUp + n.longValue() - 1L, n);
    }

    public static final long roundDown(long $this$roundDown, @NotNull Number n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return $this$roundDown - AddressUtil.positiveReminder($this$roundDown, n.longValue());
    }

    private static final long positiveReminder(long $this$positiveReminder, Number n) {
        long reminder;
        long l = n.longValue();
        return reminder + ((reminder = $this$positiveReminder % l) < 0L ? l : 0L);
    }

    @JvmName(name="addressRangeInclusive")
    @NotNull
    public static final AddressRange addressRangeInclusive(@NotNull Address $this$rangeTo, @NotNull Address endInclusive) {
        Intrinsics.checkNotNullParameter((Object)$this$rangeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        return new AddressRange($this$rangeTo, endInclusive);
    }

    @JvmName(name="addressRangeExclusive")
    @NotNull
    public static final AddressRange addressRangeExclusive(@NotNull Address $this$rangeToExclusive, @NotNull Address endExclusive) {
        Intrinsics.checkNotNullParameter((Object)$this$rangeToExclusive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
        return AddressUtil.addressRangeInclusive($this$rangeToExclusive, endExclusive.minus(1));
    }

    @NotNull
    public static final AddressRange until(@NotNull Address $this$until, @NotNull Address endExclusive) {
        Intrinsics.checkNotNullParameter((Object)$this$until, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
        return endExclusive.compareTo(Address.MIN_VALUE) <= 0 ? AddressRange.EMPTY : AddressUtil.addressRangeExclusive($this$until, endExclusive);
    }
}

