/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.util.NlsSafe;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0002\u001a\u00020\u0003J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0006J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0006J\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0006J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0006J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0010H\u0082\u0004J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0010H\u0082\u0004J\u0011\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0017J\b\u0010\u0019\u001a\u00020\u0018H\u0007J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "", "unsignedLongValue", "", "<init>", "(J)V", "getUnsignedLongValue", "()J", "isNull", "", "()Z", "compareTo", "", "other", "plus", "diff", "", "minus", "diffSize", "Lcom/jetbrains/cidr/execution/debugger/memory/Address$Companion$CoercingSize;", "safePlus", "unsignedValue", "safeMinus", "toString", "", "toStringNoZeroPad", "component1", "copy", "equals", "", "hashCode", "Companion", "intellij.cidr.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Address.kt\ncom/jetbrains/cidr/execution/debugger/memory/Address\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class Address
implements Comparable<Address> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long unsignedLongValue;
    @JvmField
    @NotNull
    public static final Address MIN_VALUE = Companion.getAsAddress(0);
    @JvmField
    @NotNull
    public static final Address MAX_VALUE = Companion.getAsAddress(-1);
    @JvmField
    @NotNull
    public static final Address NULL = MIN_VALUE;

    private Address(long unsignedLongValue) {
        this.unsignedLongValue = unsignedLongValue;
    }

    public final long getUnsignedLongValue() {
        return this.unsignedLongValue;
    }

    public final long unsignedLongValue() {
        return this.unsignedLongValue;
    }

    public final boolean isNull() {
        return Intrinsics.areEqual((Object)this, (Object)NULL);
    }

    @Override
    public int compareTo(@NotNull Address other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Long.compareUnsigned(this.unsignedLongValue, other.unsignedLongValue);
    }

    @NotNull
    public final Address plus(@NotNull Number diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        long it = diff.longValue();
        boolean bl = false;
        return it == 0L ? this : new Address(this.unsignedLongValue + it);
    }

    @NotNull
    public final Address minus(@NotNull Number diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        long it = diff.longValue();
        boolean bl = false;
        return it == 0L ? this : new Address(this.unsignedLongValue - it);
    }

    @NotNull
    public final Address plus(@NotNull Companion.CoercingSize diffSize) {
        Intrinsics.checkNotNullParameter((Object)diffSize, (String)"diffSize");
        return this.safePlus(diffSize.getUnsignedLongValue());
    }

    @NotNull
    public final Address minus(@NotNull Companion.CoercingSize diffSize) {
        Intrinsics.checkNotNullParameter((Object)diffSize, (String)"diffSize");
        return this.safeMinus(diffSize.getUnsignedLongValue());
    }

    private final Address safePlus(Number unsignedValue) {
        return Long.compareUnsigned(unsignedValue.longValue(), MAX_VALUE.minus(this)) > 0 ? MAX_VALUE : this.plus(unsignedValue);
    }

    private final Address safeMinus(Number unsignedValue) {
        return Long.compareUnsigned(unsignedValue.longValue(), this.minus(MIN_VALUE)) > 0 ? MIN_VALUE : this.minus(unsignedValue);
    }

    public final long minus(@NotNull Address other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.unsignedLongValue - other.unsignedLongValue;
    }

    @NlsSafe
    @NotNull
    public String toString() {
        String string = Long.toUnsignedString(this.unsignedLongValue, 16);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUnsignedString(...)");
        return "0x" + StringsKt.padStart((String)string, (int)16, (char)'0');
    }

    @NlsSafe
    @NotNull
    public final String toStringNoZeroPad() {
        return "0x" + Long.toUnsignedString(this.unsignedLongValue, 16);
    }

    public final long component1() {
        return this.unsignedLongValue;
    }

    @NotNull
    public final Address copy(long unsignedLongValue) {
        return new Address(unsignedLongValue);
    }

    public static /* synthetic */ Address copy$default(Address address, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = address.unsignedLongValue;
        }
        return address.copy(l);
    }

    public int hashCode() {
        return Long.hashCode(this.unsignedLongValue);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Address)) {
            return false;
        }
        Address address = (Address)other;
        return this.unsignedLongValue == address.unsignedLongValue;
    }

    @JvmStatic
    @NotNull
    public static final Address fromUnsignedLong(long l) {
        return Companion.fromUnsignedLong(l);
    }

    @JvmStatic
    @NotNull
    public static final Address parseHexString(@NotNull String s) throws NumberFormatException {
        return Companion.parseHexString(s);
    }

    public /* synthetic */ Address(long unsignedLongValue, DefaultConstructorMarker $constructor_marker) {
        this(unsignedLongValue);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000e\u001a\u00020\u0005*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0012\u001a\u00020\u0013*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/Address$Companion;", "", "<init>", "()V", "MIN_VALUE", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "MAX_VALUE", "NULL", "fromUnsignedLong", "l", "", "parseHexString", "s", "", "asAddress", "", "getAsAddress", "(Ljava/lang/Number;)Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "coercing", "Lcom/jetbrains/cidr/execution/debugger/memory/Address$Companion$CoercingSize;", "getCoercing", "(Ljava/lang/Number;)Lcom/jetbrains/cidr/execution/debugger/memory/Address$Companion$CoercingSize;", "CoercingSize", "intellij.cidr.debugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Address fromUnsignedLong(long l) {
            return new Address(l, null);
        }

        @JvmStatic
        @NotNull
        public final Address parseHexString(@NotNull String s) throws NumberFormatException {
            String string;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (StringsKt.startsWith((String)s, (String)"0x", (boolean)true)) {
                String string2 = s.substring(2);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = s;
            }
            String hex = string;
            try {
                String string3;
                CharSequence charSequence;
                Regex regex;
                if (((CharSequence)hex).length() > 0 && StringsKt.contains$default((CharSequence)"+-", (char)hex.charAt(0), (boolean)false, (int)2, null)) {
                    throw new NumberFormatException("Illegal leading sign: " + s);
                }
                long unsignedLong = Long.parseUnsignedLong(hex, 16);
                if (hex.length() > 16 && (regex = new Regex("^0+")).replaceFirst(charSequence = (CharSequence)hex, string3 = "").length() > 16) {
                    throw new NumberFormatException("String value " + hex + " exceeds range of unsigned long.");
                }
                return this.fromUnsignedLong(unsignedLong);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Invalid address: " + e.getMessage());
            }
        }

        @NotNull
        public final Address getAsAddress(@NotNull Number $this$asAddress) {
            Intrinsics.checkNotNullParameter((Object)$this$asAddress, (String)"<this>");
            return this.fromUnsignedLong($this$asAddress.longValue());
        }

        @NotNull
        public final CoercingSize getCoercing(@NotNull Number $this$coercing) {
            Intrinsics.checkNotNullParameter((Object)$this$coercing, (String)"<this>");
            return new CoercingSize($this$coercing.longValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/Address$Companion$CoercingSize;", "", "unsignedLongValue", "", "<init>", "(J)V", "getUnsignedLongValue", "()J", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.debugger.backend"})
        public static final class CoercingSize {
            private final long unsignedLongValue;

            public CoercingSize(long unsignedLongValue) {
                this.unsignedLongValue = unsignedLongValue;
            }

            public final long getUnsignedLongValue() {
                return this.unsignedLongValue;
            }

            public final long component1() {
                return this.unsignedLongValue;
            }

            @NotNull
            public final CoercingSize copy(long unsignedLongValue) {
                return new CoercingSize(unsignedLongValue);
            }

            public static /* synthetic */ CoercingSize copy$default(CoercingSize coercingSize, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = coercingSize.unsignedLongValue;
                }
                return coercingSize.copy(l);
            }

            @NotNull
            public String toString() {
                return "CoercingSize(unsignedLongValue=" + this.unsignedLongValue + ")";
            }

            public int hashCode() {
                return Long.hashCode(this.unsignedLongValue);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CoercingSize)) {
                    return false;
                }
                CoercingSize coercingSize = (CoercingSize)other;
                return this.unsignedLongValue == coercingSize.unsignedLongValue;
            }
        }
    }
}

