/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueDescription;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueModifier;
import icons.CidrDebuggerIcons;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRegisterValue
extends CidrPhysicalValue
implements XValueTextProvider {
    public static final Key<Boolean> IS_REGISTER_VALUE = Key.create((String)"cidr.debugger.isRegisterValue");
    public static final Key<String> RAW_VALUE = Key.create((String)"cidr.debugger.rawRegisterValue");
    public static final Key<String> ALTERNATIVE_VALUE = Key.create((String)"cidr.debugger.alternativeRegisterValue");
    public static final Key<Boolean> MODIFIABLE = Key.create((String)"cidr.debugger.isModifiableRegister");
    public static final Key<XSourcePosition> INLINE_DATA_POSITION = Key.create((String)"cidr.debugger.inlineDataPosition");
    @NotNull
    private final LLValue myValue;

    public CidrRegisterValue(@NotNull CidrDebugProcess process, @NotNull CidrStackFrame frame, @NotNull LLValue value) {
        if (process == null) {
            CidrRegisterValue.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            CidrRegisterValue.$$$reportNull$$$0(1);
        }
        if (value == null) {
            CidrRegisterValue.$$$reportNull$$$0(2);
        }
        this(process, frame, value, value.getName());
    }

    public CidrRegisterValue(@NotNull CidrDebugProcess process, @NotNull CidrStackFrame frame, @NotNull LLValue value, @NotNull String displayName) {
        if (process == null) {
            CidrRegisterValue.$$$reportNull$$$0(3);
        }
        if (frame == null) {
            CidrRegisterValue.$$$reportNull$$$0(4);
        }
        if (value == null) {
            CidrRegisterValue.$$$reportNull$$$0(5);
        }
        if (displayName == null) {
            CidrRegisterValue.$$$reportNull$$$0(6);
        }
        super(value, displayName, process, null, frame);
        this.myValue = value;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Nullable
    public String getValueText() {
        return (String)RAW_VALUE.get((UserDataHolder)this.myValue);
    }

    public boolean shouldShowTextValue() {
        return true;
    }

    @Override
    @NotNull
    protected CompletableFuture<XSourcePosition> doComputePositionAsync(@NotNull XSourcePosition position, @NotNull ProgressIndicator indicator) {
        if (position == null) {
            CidrRegisterValue.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            CidrRegisterValue.$$$reportNull$$$0(8);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            CidrRegisterValue.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    @Override
    protected boolean doComputeMayHaveChildren(@NotNull EvaluationContext context) throws DebuggerCommandException, ExecutionException {
        if (context == null) {
            CidrRegisterValue.$$$reportNull$$$0(10);
        }
        LLValueData data = context.getData(this.myValue);
        return data.mayHaveChildren();
    }

    @Override
    @Nullable
    protected Icon doComputeIcon(@NotNull EvaluationContext context, boolean hasChildren) {
        if (context == null) {
            CidrRegisterValue.$$$reportNull$$$0(11);
        }
        return CidrDebuggerIcons.Register;
    }

    @Override
    @Nullable
    protected String doComputeType(@NotNull EvaluationContext context) {
        if (context == null) {
            CidrRegisterValue.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Override
    @NotNull
    protected CidrValueDescription doComputeValueDescription(@NotNull EvaluationContext context) throws DebuggerCommandException, ExecutionException {
        if (context == null) {
            CidrRegisterValue.$$$reportNull$$$0(13);
        }
        LLValueData data = context.getData(this.myValue);
        return new CidrValueDescription(data.getValue());
    }

    @Override
    @NotNull
    protected XValuePresentation createValuePresentation(@NotNull EvaluationContext context, final @NotNull String value, @Nullable String type) {
        if (context == null) {
            CidrRegisterValue.$$$reportNull$$$0(14);
        }
        if (value == null) {
            CidrRegisterValue.$$$reportNull$$$0(15);
        }
        final String naturalValue = (String)this.myValue.getUserData(ALTERNATIVE_VALUE);
        return new XRegularValuePresentation(value, type){

            @NotNull
            public String getSeparator() {
                String string = StringUtil.nullize((String)value) == null && naturalValue == null ? "" : super.getSeparator();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                if (renderer == null) {
                    1.$$$reportNull$$$0(1);
                }
                renderer.renderValue(value);
                if (naturalValue != null) {
                    renderer.renderComment(" [");
                    renderer.renderComment(naturalValue);
                    renderer.renderComment("]");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrRegisterValue$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "renderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSeparator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrRegisterValue$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "renderValue";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Nullable
    public XValueModifier getModifier() {
        return (Boolean)MODIFIABLE.get((UserDataHolder)this.myValue, (Object)false) != false ? new CidrValueModifier(this) : null;
    }

    @Override
    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        XSourcePosition position;
        if (callback == null) {
            CidrRegisterValue.$$$reportNull$$$0(16);
        }
        if ((position = (XSourcePosition)INLINE_DATA_POSITION.get((UserDataHolder)this.myValue)) == null) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                CidrRegisterValue.$$$reportNull$$$0(17);
            }
            return threeState;
        }
        callback.computed(position);
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            CidrRegisterValue.$$$reportNull$$$0(18);
        }
        return threeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrRegisterValue";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrRegisterValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputePositionAsync";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInlineDebuggerData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doComputePositionAsync";
                break;
            }
            case 9: 
            case 17: 
            case 18: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doComputeMayHaveChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIcon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doComputeType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doComputeValueDescription";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createValuePresentation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeInlineDebuggerData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 17, 18 -> new IllegalStateException(string);
        };
    }
}

