/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeEx;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandExpiredException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelperBase;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrNumberValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrRichValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueDescription;
import com.jetbrains.cidr.execution.debugger.evaluation.ValuePresentationKt;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import icons.CidrDebuggerIcons;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrPhysicalValue
extends CidrValue {
    public static final Key THROW_ON_TYPE = Key.create((String)"THROW_ON_TYPE");
    public static final Key THROW_ON_ICON = Key.create((String)"THROW_ON_ICON");
    public static final Key THROW_ON_VALUE = Key.create((String)"THROW_ON_VALUE");
    public static final Key THROW_ON_VAR_DATA = Key.create((String)"THROW_ON_VAR_DATA");
    public static final Key THROW_ON_HAS_CHILDREN = Key.create((String)"THROW_ON_CHILDREN_COUNT");
    public static final Key THROW_ON_CHILDREN = Key.create((String)"THROW_ON_CHILDREN");
    @NotNull
    private final LLValue myVar;
    @Nullable
    private volatile LLValue myPresentationVar;
    @NotNull
    private final CachedDebuggerResult<LLValueData> myVarDataResult;
    @NotNull
    private final CachedDebuggerResult<LLValueData> myPresentationVarDataResult;
    @NotNull
    private final CachedDebuggerResult<ValueRenderer> myRendererResult;

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        if (var == null) {
            CidrPhysicalValue.$$$reportNull$$$0(0);
        }
        if (process == null) {
            CidrPhysicalValue.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            CidrPhysicalValue.$$$reportNull$$$0(2);
        }
        this(var, var.getName(), process, position, frame);
    }

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull String displayName, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        if (var == null) {
            CidrPhysicalValue.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            CidrPhysicalValue.$$$reportNull$$$0(4);
        }
        if (process == null) {
            CidrPhysicalValue.$$$reportNull$$$0(5);
        }
        if (frame == null) {
            CidrPhysicalValue.$$$reportNull$$$0(6);
        }
        super(displayName, process, position, frame);
        this.myVarDataResult = new CachedDebuggerResult();
        this.myPresentationVarDataResult = new CachedDebuggerResult();
        this.myRendererResult = new CachedDebuggerResult();
        this.myVar = var;
    }

    @NotNull
    public ValueRenderer getPreparedRenderer() {
        ValueRenderer result = this.myRendererResult.getResultIfAvailable();
        if (result == null) {
            CidrDebuggerLog.LOG.error("getPreparedRenderer() called before getRenderer()");
            return new ValueRenderer(this);
        }
        ValueRenderer valueRenderer = result;
        if (valueRenderer == null) {
            CidrPhysicalValue.$$$reportNull$$$0(7);
        }
        return valueRenderer;
    }

    @NotNull
    public ValueRenderer getRenderer(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(8);
        }
        ValueRenderer valueRenderer = this.myRendererResult.getResult(new CachedDebuggerResult.NotNullCalculator<ValueRenderer>(){

            @Override
            @NotNull
            public ValueRenderer calculate() throws ExecutionException, DebuggerCommandException {
                ValueRenderer valueRenderer = CidrPhysicalValue.this.doCreateRenderer(context);
                if (valueRenderer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return valueRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue$1", "calculate"));
            }
        });
        if (valueRenderer == null) {
            CidrPhysicalValue.$$$reportNull$$$0(9);
        }
        return valueRenderer;
    }

    @NotNull
    protected ValueRenderer doCreateRenderer(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(10);
        }
        ValueRenderer valueRenderer = ValueRendererFactory.createRenderer(context, this);
        if (valueRenderer == null) {
            CidrPhysicalValue.$$$reportNull$$$0(11);
        }
        return valueRenderer;
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        String string = this.myVar.getReferenceExpression();
        if (string == null) {
            CidrPhysicalValue.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    protected CompletableFuture<XSourcePosition> doComputeNearestUsagePositionAsync(@NotNull XSourcePosition position, @NotNull ProgressIndicator indicator) {
        if (position == null) {
            CidrPhysicalValue.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            CidrPhysicalValue.$$$reportNull$$$0(14);
        }
        CompletableFuture<XSourcePosition> completableFuture = this.getTypesHelper().computeNearestUsageSourcePositionAsync(position, this.getVar(), indicator);
        if (completableFuture == null) {
            CidrPhysicalValue.$$$reportNull$$$0(15);
        }
        return completableFuture;
    }

    @NotNull
    public LLValue getVar() {
        LLValue lLValue = this.myVar;
        if (lLValue == null) {
            CidrPhysicalValue.$$$reportNull$$$0(16);
        }
        return lLValue;
    }

    @NotNull
    public LLValue getPresentationVar() {
        LLValue presentationVar = this.myPresentationVar;
        LLValue lLValue = presentationVar != null ? presentationVar : this.myVar;
        if (lLValue == null) {
            CidrPhysicalValue.$$$reportNull$$$0(17);
        }
        return lLValue;
    }

    public void setPresentationVar(@Nullable LLValue presentationVar) {
        this.myPresentationVar = presentationVar;
    }

    @NotNull
    @NlsSafe
    public String getType() {
        String string = this.myVar.getType();
        if (string == null) {
            CidrPhysicalValue.$$$reportNull$$$0(18);
        }
        return string;
    }

    public boolean isValueDataAvailable() {
        return this.myVarDataResult.getResultIfAvailable() != null;
    }

    @Override
    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            CidrPhysicalValue.$$$reportNull$$$0(19);
        }
        if (place == null) {
            CidrPhysicalValue.$$$reportNull$$$0(20);
        }
        if (!this.isValueDataAvailable() && CidrDebuggerSettings.getInstance().isMuteVariables() && (this.isFrameVariable() || CidrPhysicalValue.isFrameVariableNode(node))) {
            String type = CidrDebuggerSettings.getInstance().isShowTypes() ? ValueRenderer.getDisplayType(this) : null;
            XRegularValuePresentation presentation = StringUtil.isEmpty((String)type) ? new XRegularValuePresentation("", type, "") : new XRegularValuePresentation("", type);
            node.setFullValueEvaluator(this.createOnDemandValueEvaluator(node));
            node.setPresentation(CidrDebuggerIcons.ValueMuted, (XValuePresentation)presentation, false);
        } else {
            super.computePresentation(node, place);
        }
    }

    protected boolean isFrameVariable() {
        return false;
    }

    protected static boolean isFrameVariableNode(@NotNull XValueNode node) {
        if (node == null) {
            CidrPhysicalValue.$$$reportNull$$$0(21);
        }
        while (node instanceof XValueNodeImpl) {
            XValueNodeImpl nodeImpl = (XValueNodeImpl)node;
            if (nodeImpl.getValueContainer() instanceof CidrLocalValue) {
                return true;
            }
            if (!Registry.is((String)"cidr.debugger.muteVariables.muteChildren", (boolean)false)) break;
            node = (XValueNode)ObjectUtils.tryCast((Object)nodeImpl.getParent(), XValueNode.class);
        }
        return false;
    }

    private XFullValueEvaluator createOnDemandValueEvaluator(final @NotNull XValueNode node) {
        if (node == null) {
            CidrPhysicalValue.$$$reportNull$$$0(22);
        }
        return new XFullValueEvaluator(CidrDebuggerBundle.message("debugger.variables.loadMutedValue.link", new Object[0])){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (node instanceof XValueNodeEx) {
                    XValueNodeEx xValueNodeEx = (XValueNodeEx)node;
                    xValueNodeEx.clearFullValueEvaluator();
                    CidrPhysicalValue.super.computePresentation(node, XValuePlace.TREE);
                }
                callback.evaluated("");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue$2", "startEvaluation"));
            }
        }.setShowValuePopup(false);
    }

    @NotNull
    public LLValueData getPreparedVarData() {
        LLValueData result = this.myVarDataResult.getResultIfAvailable();
        if (result == null) {
            CidrDebuggerLog.LOG.error("getPreparedVarData() called before getVarData()");
            return new LLValueData("", null, false, false, false);
        }
        LLValueData lLValueData = result;
        if (lLValueData == null) {
            CidrPhysicalValue.$$$reportNull$$$0(23);
        }
        return lLValueData;
    }

    @NotNull
    public LLValueData getVarData(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(24);
        }
        LLValueData lLValueData = this.myVarDataResult.getResult(new CachedDebuggerResult.NotNullCalculator<LLValueData>(){

            @Override
            @NotNull
            public LLValueData calculate() throws ExecutionException, DebuggerCommandException {
                ThrowInTest.doThrow((UserDataHolder)CidrPhysicalValue.this, THROW_ON_VAR_DATA);
                LLValueData lLValueData = context.getData(CidrPhysicalValue.this.myVar);
                if (lLValueData == null) {
                    3.$$$reportNull$$$0(0);
                }
                return lLValueData;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue$3", "calculate"));
            }
        });
        if (lLValueData == null) {
            CidrPhysicalValue.$$$reportNull$$$0(25);
        }
        return lLValueData;
    }

    @NotNull
    public LLValueData getPresentationVarData(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        LLValue presentationVar;
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(26);
        }
        if ((presentationVar = this.myPresentationVar) == null) {
            LLValueData lLValueData = this.getVarData(context);
            if (lLValueData == null) {
                CidrPhysicalValue.$$$reportNull$$$0(27);
            }
            return lLValueData;
        }
        LLValueData lLValueData = this.myPresentationVarDataResult.getResult(new CachedDebuggerResult.NotNullCalculator<LLValueData>(){

            @Override
            @NotNull
            public LLValueData calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData lLValueData = context.getData(presentationVar);
                if (lLValueData == null) {
                    4.$$$reportNull$$$0(0);
                }
                return lLValueData;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue$4", "calculate"));
            }
        });
        if (lLValueData == null) {
            CidrPhysicalValue.$$$reportNull$$$0(28);
        }
        return lLValueData;
    }

    @Override
    @Nullable
    protected String doComputeType(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(29);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_TYPE);
        return this.getRenderer(context).getDisplayType();
    }

    @Nullable
    public String getShownAddress() {
        if (!this.isValueDataAvailable()) {
            return null;
        }
        return this.getPreparedVarData().getPresentablePointer();
    }

    @Override
    @NotNull
    protected CidrValueDescription doComputeValueDescription(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(30);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VALUE);
        CidrValueDescription cidrValueDescription = this.getRenderer(context).computeValueDescription(context);
        if (cidrValueDescription == null) {
            CidrPhysicalValue.$$$reportNull$$$0(31);
        }
        return cidrValueDescription;
    }

    @Override
    @NotNull
    protected XValuePresentation createValuePresentation(@NotNull EvaluationContext context, @NotNull String value, @Nullable String type) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(32);
        }
        if (value == null) {
            CidrPhysicalValue.$$$reportNull$$$0(33);
        }
        if (this.isRichValueDescriptionEnabled(context)) {
            return new CidrRichValuePresentation(value, type);
        }
        XValuePresentation valuePresentation = this.createNumberValuePresentation(context, value, type);
        if (valuePresentation != null) {
            XValuePresentation xValuePresentation = valuePresentation;
            if (xValuePresentation == null) {
                CidrPhysicalValue.$$$reportNull$$$0(34);
            }
            return xValuePresentation;
        }
        XValuePresentation xValuePresentation = super.createValuePresentation(context, value, type);
        if (xValuePresentation == null) {
            CidrPhysicalValue.$$$reportNull$$$0(35);
        }
        return xValuePresentation;
    }

    @Nullable
    protected XValuePresentation createNumberValuePresentation(@NotNull EvaluationContext context, @NotNull String value, @Nullable String type) throws ExecutionException, DebuggerCommandException {
        BigInteger number;
        LLValueData valueData;
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(36);
        }
        if (value == null) {
            CidrPhysicalValue.$$$reportNull$$$0(37);
        }
        if ((valueData = this.getPresentationVarData(context)).isPointer()) {
            return null;
        }
        Pair<String, String> numberAndData = valueData.splitNumberAndData();
        String numberText = (String)numberAndData.first;
        if (numberText == null) {
            return null;
        }
        if (!value.startsWith(numberText)) {
            return null;
        }
        String text = value.substring(numberText.length());
        try {
            number = new BigInteger(numberText);
        }
        catch (NumberFormatException ignored) {
            number = BigInteger.ZERO;
        }
        boolean isHex = CidrDebuggerSettings.getInstance().isHexFormattingEnabled();
        if (!isHex) {
            return new CidrNumberValuePresentation(value, type, numberText, text);
        }
        CidrDebuggerUtil.ReadActionResult sizeof = CidrDebuggerUtil.runInReadActionWithRetries(() -> {
            context.checkExpiration();
            return this.getTypesHelper().getSizeOf(this);
        }, context);
        int valueBytes = number.toByteArray().length;
        Integer computedTypeSizeBytes = sizeof.wasCompleted ? (Integer)sizeof.value : null;
        int typeSizeBytes = computedTypeSizeBytes != null && computedTypeSizeBytes >= valueBytes ? computedTypeSizeBytes : 8;
        int sizeBytes = Math.max(valueBytes, typeSizeBytes);
        boolean isHexAsSecondary = CidrDebuggerSettings.getInstance().isHexAsSecondaryFormattingEnabled();
        return ValuePresentationKt.createHexValuePresentation(value, type, numberText, text, number, sizeBytes, isHexAsSecondary);
    }

    @Override
    protected boolean doComputeMayHaveChildren(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(38);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_HAS_CHILDREN);
        return this.getRenderer(context).computeMayHaveChildren(context);
    }

    @Override
    @Nullable
    protected Icon doComputeIcon(@NotNull EvaluationContext context, boolean hasChildren) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(39);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_ICON);
        return this.getRenderer(context).getIcon(hasChildren);
    }

    @Override
    public final void computeValueChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            CidrPhysicalValue.$$$reportNull$$$0(40);
        }
        XValueNodeExpirable expirable = new XValueNodeExpirable((Obsolescent)node, true);
        CidrDebugProcess process = this.getProcess();
        process.postCommand((Expirable)expirable, driver -> CidrPhysicalValue.invokeRenderChildren(node, () -> {
            long t0 = System.currentTimeMillis();
            try {
                ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_CHILDREN);
                CidrPhysicalValue.setupCancellation(process, driver, this, node, expirable);
                EvaluationContext context = this.createEvaluationContext(driver, expirable);
                node.setAlreadySorted(true);
                this.getRenderer(context).computeChildren(context, node);
            }
            finally {
                process.addChildrenLoadingTime(System.currentTimeMillis() - t0);
            }
        }));
    }

    private static void setupCancellation(final @NotNull CidrDebugProcess process, @NotNull DebuggerDriver driver, final @NotNull CidrPhysicalValue value, @NotNull XCompositeNode node, final @NotNull XValueNodeExpirable expirable) {
        if (process == null) {
            CidrPhysicalValue.$$$reportNull$$$0(41);
        }
        if (driver == null) {
            CidrPhysicalValue.$$$reportNull$$$0(42);
        }
        if (value == null) {
            CidrPhysicalValue.$$$reportNull$$$0(43);
        }
        if (node == null) {
            CidrPhysicalValue.$$$reportNull$$$0(44);
        }
        if (expirable == null) {
            CidrPhysicalValue.$$$reportNull$$$0(45);
        }
        if (!(node instanceof XValueContainerNode)) {
            return;
        }
        final XValueContainerNode containerNode = (XValueContainerNode)node;
        if (!driver.supportsCommandCancellation()) {
            return;
        }
        XDebuggerTreeNodeHyperlink cancelLink = new XDebuggerTreeNodeHyperlink(CidrDebuggerBundle.message("debug.cancel.loading", new Object[0])){

            public void onClick(MouseEvent event) {
                if (!expirable.isExpired()) {
                    expirable.expire();
                    containerNode.setTemporaryMessage(MessageTreeNode.createInfoMessage((XDebuggerTree)containerNode.getTree(), (String)CidrDebuggerBundle.message("debug.cancelling.loading", new Object[0])));
                    CidrDebuggerUsagesCollector.logChildrenLoadingCancelled(process.getDriverName());
                    process.notifyChildrenLoadingCancelled(value);
                }
            }
        };
        MessageTreeNode loadingMessage = (MessageTreeNode)ContainerUtil.getFirstItem((List)MessageTreeNode.createMessages((XDebuggerTree)containerNode.getTree(), null, (String)(XDebuggerUIConstants.getCollectingDataMessage() + "  "), (XDebuggerTreeNodeHyperlink)cancelLink, null, (SimpleTextAttributes)XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES));
        if (loadingMessage == null) {
            return;
        }
        containerNode.setTemporaryMessage(loadingMessage);
    }

    @Override
    @NotNull
    public String getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(46);
        }
        String string = this.getRenderer(context).getConsoleDescription(context).toString();
        if (string == null) {
            CidrPhysicalValue.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    public CidrDebuggerTypesHelperBase getTypesHelper() {
        CidrDebuggerTypesHelperBase cidrDebuggerTypesHelperBase = this.getProcess().getTypesHelper(this.getFrame());
        if (cidrDebuggerTypesHelperBase == null) {
            CidrPhysicalValue.$$$reportNull$$$0(48);
        }
        return cidrDebuggerTypesHelperBase;
    }

    public String toString() {
        return this.getVar().toString();
    }

    @Nullable
    public DebuggerDriver.DebuggerLanguage getLanguage() {
        return this.getFrame().getFrame().getLanguage();
    }

    public boolean isObjectiveCContext() {
        DebuggerDriver.DebuggerLanguage l = this.getLanguage();
        return l == DebuggerDriver.StandardDebuggerLanguage.OBJC || l == DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
    }

    public boolean isSwiftContext() {
        return this.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT;
    }

    public boolean isRustContext() {
        return this.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.RUST;
    }

    public boolean isSwiftOptional() {
        return this.isSwiftContext() && CidrDebuggerTypesHelper.unwrapSwiftOptionalType(this.getType()) != null;
    }

    public boolean isSwiftVoid() {
        return this.isSwiftContext() && "()".equals(this.getType());
    }

    public static void invokeRenderChildren(@NotNull XCompositeNode node, @NotNull CompositeNodeComputable computable) throws ExecutionException {
        if (node == null) {
            CidrPhysicalValue.$$$reportNull$$$0(49);
        }
        if (computable == null) {
            CidrPhysicalValue.$$$reportNull$$$0(50);
        }
        if (node.isObsolete()) {
            return;
        }
        try {
            computable.compute();
        }
        catch (DebuggerCommandExpiredException e) {
            node.addChildren(CidrPhysicalValue.createErrorChildren(Collections.singletonList(CidrDebuggerBundle.message("debug.cancelled.loading", new Object[0]))), true);
        }
        catch (DebuggerCommandException e) {
            node.addChildren(CidrPhysicalValue.createErrorChildren(Collections.singletonList(e.getMessage())), true);
        }
        catch (ExecutionException e) {
            node.addChildren(CidrPhysicalValue.createErrorChildren(Collections.singletonList(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)))), true);
            throw e;
        }
    }

    public void resetCaches() {
        this.myVarDataResult.reset();
        this.myPresentationVarDataResult.reset();
        this.myRendererResult.reset();
    }

    @ApiStatus.Experimental
    public boolean isRichValueDescriptionEnabled(@NotNull EvaluationContext context) throws DebuggerCommandException, ExecutionException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(51);
        }
        return this.getProcess().isRichValueDescriptionEnabled() || this.getPresentationVarData(context).isRichDescription();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 11, 12, 15, 16, 17, 18, 23, 25, 27, 28, 31, 34, 35, 47, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 1: 
            case 5: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue";
                break;
            }
            case 8: 
            case 10: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 36: 
            case 38: 
            case 39: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 40: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 33: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expirable";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedRenderer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRenderer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationExpression";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeNearestUsagePositionAsync";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getVar";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationVar";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedVarData";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarData";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationVarData";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeValueDescription";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createValuePresentation";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleDescription";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 47: 
            case 48: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRenderer";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doComputeNearestUsagePositionAsync";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isFrameVariableNode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createOnDemandValueEvaluator";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getVarData";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationVarData";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doComputeType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doComputeValueDescription";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createValuePresentation";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createNumberValuePresentation";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "doComputeMayHaveChildren";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIcon";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "computeValueChildren";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setupCancellation";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleDescription";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "invokeRenderChildren";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isRichValueDescriptionEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 11, 12, 15, 16, 17, 18, 23, 25, 27, 28, 31, 34, 35, 47, 48 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface CompositeNodeComputable {
        public void compute() throws ExecutionException, DebuggerCommandException;
    }
}

