/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexEntry;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexState;
import java.io.File;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="gdb-index", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DISABLED)}, allowLoadInTests=true)
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexStorage;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexState;", "<init>", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "loadState", "", "state", "entryForFile", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexEntry;", "file", "Ljava/io/File;", "saveEntry", "buildId", "", "hasIndex", "", "reset", "intellij.cidr.debugger.core"})
public final class GdbIndexStorage
extends SimplePersistentStateComponent<GdbIndexState> {
    @NotNull
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public GdbIndexStorage() {
        super((BaseState)new GdbIndexState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull GdbIndexState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            super.loadState((BaseState)state);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final GdbIndexEntry entryForFile(@NotNull File file) {
        GdbIndexEntry gdbIndexEntry;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String path = file.getAbsolutePath();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            gdbIndexEntry = ((GdbIndexState)this.getState()).getEntries().get(path);
        }
        finally {
            readLock.unlock();
        }
        return gdbIndexEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveEntry(@NotNull File file, @Nullable String buildId, boolean hasIndex) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(buildId != null || !hasIndex)) {
            boolean $i$a$-require-GdbIndexStorage$saveEntry$22 = false;
            String $i$a$-require-GdbIndexStorage$saveEntry$22 = "if buildId is missing hasIndex must be false";
            throw new IllegalArgumentException($i$a$-require-GdbIndexStorage$saveEntry$22.toString());
        }
        String path = file.getAbsolutePath();
        Object object = new GdbIndexEntry();
        GdbIndexEntry $this$saveEntry_u24lambda_u243 = object;
        boolean bl = false;
        $this$saveEntry_u24lambda_u243.setFileLength(file.length());
        $this$saveEntry_u24lambda_u243.setFileLastModifiedTime(file.lastModified());
        $this$saveEntry_u24lambda_u243.setBuildId(buildId);
        $this$saveEntry_u24lambda_u243.setHasIndex(hasIndex);
        GdbIndexEntry entry = object;
        object = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            ((GdbIndexState)this.getState()).getEntries().put(path, entry);
            ((GdbIndexState)this.getState()).intIncrementModificationCount();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.loadState(new GdbIndexState());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }
}

