/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.CidrOSProcessUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class NativeStacktraceProvider {
    @Nullable
    public String getNativeStacktrace(int pid) throws ExecutionException {
        String string;
        DebuggerController controller = new DebuggerController(pid);
        try {
            StringBuilder stacktraces = new StringBuilder();
            controller.attach();
            controller.interrupt();
            List<LLThread> threads2 = controller.getThreads();
            int counter = 0;
            for (LLThread thread : threads2) {
                DebuggerDriver.ResultList<LLFrame> frames2 = controller.getFrames(thread, 0, 30);
                stacktraces.append("Thread ").append(++counter);
                stacktraces.append('\n');
                for (LLFrame frame : frames2.list) {
                    stacktraces.append("[").append(frame.getProgramCounter()).append("] ").append(frame.getFunction()).append(" at ").append(frame.getFile()).append(":").append(frame.getIndex()).append('\n');
                }
                stacktraces.append('\n');
            }
            controller.resume();
            controller.detach();
            string = stacktraces.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    controller.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ExecutionException ex) {
                throw ex;
            }
            catch (Throwable thr) {
                throw new ExecutionException(thr);
            }
        }
        controller.close();
        return string;
    }

    private static final class DebuggerController
    implements AutoCloseable {
        private final int myPid;
        @NotNull
        private final MyDebuggerHandler myHandler;
        @NotNull
        private final DebuggerDriver myDriver;
        @Nullable
        private DebuggerDriver.Inferior myInferior = null;

        private DebuggerController(int pid) {
            this.myPid = pid;
            this.myHandler = new MyDebuggerHandler();
            this.myDriver = DebuggerController.createDriver(this.myHandler, pid);
        }

        void attach() throws Exception {
            assert (this.myInferior == null) : "Attaching twice?";
            this.myInferior = this.myDriver.loadForAttach(this.myPid);
            this.myInferior.start();
            this.myHandler.running.get(15L, TimeUnit.SECONDS);
            this.myHandler.clear();
        }

        void interrupt() throws Exception {
            this.myDriver.interrupt();
            this.myHandler.suspended.get(15L, TimeUnit.SECONDS);
            this.myHandler.clear();
        }

        void resume() throws Exception {
            this.myDriver.resume();
            this.myHandler.running.get(15L, TimeUnit.SECONDS);
            this.myHandler.clear();
        }

        void detach() throws Exception {
            assert (this.myInferior != null) : "Forgot to attach first?";
            this.myInferior.detach();
            this.myInferior = null;
            this.myHandler.detached.get(15L, TimeUnit.SECONDS);
            this.myHandler.clear();
        }

        @NotNull
        public List<LLThread> getThreads() throws Exception {
            List<LLThread> list = this.myDriver.getThreads();
            if (list == null) {
                DebuggerController.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull LLThread thread, int from, int count) throws Exception {
            if (thread == null) {
                DebuggerController.$$$reportNull$$$0(1);
            }
            DebuggerDriver.ResultList<LLFrame> resultList = this.myDriver.getFrames(thread, from, count);
            if (resultList == null) {
                DebuggerController.$$$reportNull$$$0(2);
            }
            return resultList;
        }

        @Override
        public void close() throws ExecutionException {
            try {
                if (this.myInferior != null) {
                    if (this.myDriver.getState() == DebuggerDriver.TargetState.SUSPENDED) {
                        this.resume();
                    }
                    this.detach();
                }
            }
            catch (ExecutionException ex) {
                throw ex;
            }
            catch (Throwable thr) {
                throw new ExecutionException(thr);
            }
            finally {
                this.myDriver.getProcessHandler().destroyProcess();
            }
        }

        @NotNull
        private static DebuggerDriver createDriver(@NotNull MyDebuggerHandler handler, int pid) {
            ArchitectureType archType;
            if (handler == null) {
                DebuggerController.$$$reportNull$$$0(3);
            }
            DebuggerDriverConfiguration configuration = SystemInfoRt.isLinux ? new GDBDriverConfiguration(){} : new LLDBDriverConfiguration(){};
            try {
                archType = SystemInfoRt.isMac ? ArchitectureType.UNKNOWN : CidrOSProcessUtil.getProcessArchitectureType(pid);
            }
            catch (Throwable thr) {
                archType = ArchitectureType.UNKNOWN;
            }
            DebuggerDriver driver = null;
            try {
                driver = configuration.createDriver(handler, archType);
                driver.startDebuggerProcess();
                driver.getProcessHandler().startNotify();
            }
            catch (Throwable thr) {
                if (driver != null) {
                    driver.getProcessHandler().destroyProcess();
                }
                ExceptionUtil.rethrow((Throwable)thr);
            }
            DebuggerDriver debuggerDriver = driver;
            if (debuggerDriver == null) {
                DebuggerController.$$$reportNull$$$0(4);
            }
            return debuggerDriver;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/NativeStacktraceProvider$DebuggerController";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thread";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThreads";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/NativeStacktraceProvider$DebuggerController";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrames";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDriver";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFrames";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDriver";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3 -> new IllegalArgumentException(string);
            };
        }

        private static class MyDebuggerHandler
        implements DebuggerDriver.Handler {
            @NotNull
            CompletableFuture<Object> attached = new CompletableFuture();
            @NotNull
            CompletableFuture<Object> running = new CompletableFuture();
            @NotNull
            CompletableFuture<Object> suspended = new CompletableFuture();
            @NotNull
            CompletableFuture<Object> detached = new CompletableFuture();

            private MyDebuggerHandler() {
            }

            @Override
            public void handleAttached(int pid) {
                this.attached.complete(true);
            }

            @Override
            public void handleRunning() {
                this.running.complete(true);
            }

            @Override
            public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
                if (signal == null) {
                    MyDebuggerHandler.$$$reportNull$$$0(0);
                }
                if (meaning == null) {
                    MyDebuggerHandler.$$$reportNull$$$0(1);
                }
                if (stopPlace == null) {
                    MyDebuggerHandler.$$$reportNull$$$0(2);
                }
                this.suspended.complete(true);
            }

            @Override
            public void handleException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
                if (stopPlace == null) {
                    MyDebuggerHandler.$$$reportNull$$$0(3);
                }
                if (exceptionAddress == null) {
                    MyDebuggerHandler.$$$reportNull$$$0(4);
                }
                if (description == null) {
                    MyDebuggerHandler.$$$reportNull$$$0(5);
                }
                this.suspended.complete(true);
            }

            @Override
            public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
                if (stopPlace == null) {
                    MyDebuggerHandler.$$$reportNull$$$0(6);
                }
                this.suspended.complete(true);
            }

            @Override
            public void handleDetached() {
                this.detached.complete(true);
            }

            void clear() {
                if (this.attached.isDone()) {
                    this.attached = new CompletableFuture();
                }
                if (this.running.isDone()) {
                    this.running = new CompletableFuture();
                }
                if (this.suspended.isDone()) {
                    this.suspended = new CompletableFuture();
                }
                if (this.detached.isDone()) {
                    this.detached = new CompletableFuture();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "signal";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "meaning";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stopPlace";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "exceptionAddress";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "description";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/NativeStacktraceProvider$DebuggerController$MyDebuggerHandler";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleSignal";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleException";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleInterrupted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

