/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u000f\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u0010\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J9\u0010\u0011\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\u0013\"\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDevToolLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "()V", "log", "", "time", "", "logLevel", "Lcom/intellij/openapi/diagnostic/LogLevel;", "message", "", "t", "", "debug", "info", "warn", "error", "details", "", "(Ljava/lang/String;Ljava/lang/Throwable;[Ljava/lang/String;)V", "buildMessage", "msg", "setLevel", "level", "isDebugEnabled", "", "intellij.cidr.debugger.core"})
public class CidrDevToolLogger
extends Logger {
    public void log(long time, @NotNull LogLevel logLevel, @Nullable String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
    }

    public void debug(@Nullable String message, @Nullable Throwable t) {
        this.log(System.currentTimeMillis(), LogLevel.DEBUG, message, t);
    }

    public void info(@Nullable String message, @Nullable Throwable t) {
        this.log(System.currentTimeMillis(), LogLevel.INFO, message, t);
    }

    public void warn(@Nullable String message, @Nullable Throwable t) {
        this.log(System.currentTimeMillis(), LogLevel.WARNING, message, t);
    }

    public void error(@Nullable String message, @Nullable Throwable t, String ... details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.log(System.currentTimeMillis(), LogLevel.ERROR, message, t);
    }

    @NotNull
    public final String buildMessage(@Nullable String msg, @Nullable Throwable t) {
        StringBuilder result = new StringBuilder();
        if (msg != null) {
            result.append(msg);
        }
        if (t != null) {
            result.append(ExceptionUtil.getMessage((Throwable)t));
            result.append(ExceptionUtil.getThrowableText((Throwable)t));
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void setLevel(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
    }

    public final boolean isDebugEnabled() {
        return false;
    }
}

