/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.jetbrains.cidr.execution.CidrDebuggerPluginService;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessChildProcessHandlerKt;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDefaultAttachDebuggerProvider;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachDebugger;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \f2\u00020\u0001:\u0001\fJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessChildProcessHandler;", "", "onChildProcessCreated", "", "childPid", "", "getSuitableDebuggerForAttach", "Lcom/intellij/xdebugger/attach/XAttachDebugger;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "Companion", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrDebugProcessChildProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDebugProcessChildProcessHandler.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebugProcessChildProcessHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n295#2,2:89\n*S KotlinDebug\n*F\n+ 1 CidrDebugProcessChildProcessHandler.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebugProcessChildProcessHandler\n*L\n65#1:89,2\n*E\n"})
public interface CidrDebugProcessChildProcessHandler {
    @NotNull
    public static final Companion Companion = com.jetbrains.cidr.execution.debugger.CidrDebugProcessChildProcessHandler$Companion.$$INSTANCE;

    default public void onChildProcessCreated(long childPid) {
        CidrDebuggerLog.LOG.debug("Child process created: " + childPid);
        XAttachDebugger debugger = this.getSuitableDebuggerForAttach();
        if (debugger == null) {
            CidrDebuggerLog.LOG.warn("No debugger found for child process: " + childPid);
            return;
        }
        ProcessInfo processInfo = CidrDebugProcessChildProcessHandlerKt.access$getProcessInfo(childPid);
        if (processInfo == null) {
            CidrDebuggerLog.LOG.warn("Child process not found: " + childPid);
            CidrDebugProcessChildProcessHandlerKt.access$showNotification(this, childPid, "debug.childProcessDebugging.processNotFound");
            return;
        }
        CoroutineScope pluginScope = ((CidrDebuggerPluginService)this.getProject().getService(CidrDebuggerPluginService.class)).getCoroutineScope();
        BuildersKt.launch$default((CoroutineScope)pluginScope, (CoroutineContext)((CoroutineContext)new CoroutineName("AttachToChildProcess-" + com.jetbrains.cidr.execution.debugger.CidrDebugProcessChildProcessHandler$Companion.waitJobCounter.incrementAndGet())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(debugger, this, processInfo, childPid, null){
            int label;
            final /* synthetic */ XAttachDebugger $debugger;
            final /* synthetic */ CidrDebugProcessChildProcessHandler this$0;
            final /* synthetic */ ProcessInfo $processInfo;
            final /* synthetic */ long $childPid;
            {
                this.$debugger = $debugger;
                this.this$0 = $receiver;
                this.$processInfo = $processInfo;
                this.$childPid = $childPid;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$debugger, this.this$0, this.$processInfo, this.$childPid, null){
                            int label;
                            final /* synthetic */ XAttachDebugger $debugger;
                            final /* synthetic */ CidrDebugProcessChildProcessHandler this$0;
                            final /* synthetic */ ProcessInfo $processInfo;
                            final /* synthetic */ long $childPid;
                            {
                                this.$debugger = $debugger;
                                this.this$0 = $receiver;
                                this.$processInfo = $processInfo;
                                this.$childPid = $childPid;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        try {
                                            this.$debugger.attachDebugSession(this.this$0.getProject(), (XAttachHost)LocalAttachHost.INSTANCE, this.$processInfo);
                                        }
                                        catch (CancellationException cancellationException) {
                                            CidrDebuggerLog.LOG.debug("Attach to child process cancelled: " + this.$childPid);
                                            return Unit.INSTANCE;
                                        }
                                        catch (Exception e) {
                                            CidrDebuggerLog.LOG.warn("Failed to attach debugger to child process: " + this.$childPid, (Throwable)e);
                                            CidrDebugProcessChildProcessHandlerKt.access$showNotification(this.this$0, this.$childPid, "debug.childProcessDebugging.failedToAttach");
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    default public XAttachDebugger getSuitableDebuggerForAttach() {
        List debuggerProviders = XAttachDebuggerProvider.EP.getExtensionList();
        for (XAttachDebuggerProvider provider : debuggerProviders) {
            XAttachDebugger availableDebugger;
            Object v3;
            block2: {
                void $this$firstOrNull$iv;
                if (!(provider instanceof CidrDefaultAttachDebuggerProvider)) continue;
                CidrDefaultAttachDebuggerProvider cidrDefaultAttachDebuggerProvider = (CidrDefaultAttachDebuggerProvider)provider;
                Project project = this.getProject();
                LocalAttachHost localAttachHost = LocalAttachHost.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)localAttachHost, (String)"INSTANCE");
                Iterable iterable = cidrDefaultAttachDebuggerProvider.getAvailableDebuggers(project, (XAttachHost)localAttachHost);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    XAttachDebugger it = (XAttachDebugger)element$iv;
                    boolean bl = false;
                    if (!(it instanceof CidrLocalAttachDebugger && ((CidrLocalAttachDebugger)it).getConfiguration() instanceof LLDBDriverConfiguration)) continue;
                    v3 = element$iv;
                    break block2;
                }
                v3 = null;
            }
            if ((availableDebugger = (XAttachDebugger)v3) == null) continue;
            return availableDebugger;
        }
        return null;
    }

    @NotNull
    public Project getProject();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessChildProcessHandler$Companion;", "", "<init>", "()V", "waitJobCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "intellij.cidr.debugger.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final AtomicLong waitJobCounter;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            waitJobCounter = new AtomicLong(0L);
        }
    }
}

