/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ResourceUtil {
    private static final Logger LOG = Logger.getInstance(ResourceUtil.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readResourceFromFile(@NotNull Class<?> resourceContainerClass, @NonNls @NotNull String filePath) {
        if (resourceContainerClass == null) {
            ResourceUtil.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            ResourceUtil.$$$reportNull$$$0(1);
        }
        try (InputStream stream = resourceContainerClass.getClassLoader().getResourceAsStream(filePath);){
            String string;
            block18: {
                LineNumberReader lineNumberReader = stream == null ? null : new LineNumberReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                try {
                    String line;
                    if (stream == null) {
                        throw new IOException("Resource not found: " + filePath);
                    }
                    StringBuilder result = new StringBuilder();
                    while ((line = lineNumberReader.readLine()) != null) {
                        result.append(line);
                        result.append("\n");
                    }
                    string = result.toString();
                    if (lineNumberReader == null) break block18;
                }
                catch (Throwable throwable) {
                    if (lineNumberReader != null) {
                        try {
                            lineNumberReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lineNumberReader.close();
            }
            return string;
        }
        catch (IOException e) {
            LOG.error("Cannot load resource from" + filePath, (Throwable)e);
            return "";
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "resourceContainerClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "filePath";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/ResourceUtil";
        objectArray[2] = "readResourceFromFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

