/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.Java2DConverter;

public class IsInUtil {
    private static final Logger log = Logger.getLogger(IsInUtil.class);
    public static final int IN = 1;
    public static final int ON = 2;
    public static final int OUT = 4;
    public static final int IN_ON_OUT = 7;
    private static final int EPS_HP = 4;
    private static final int EPS_HP_SQRD = 16;
    private static final double EPS = 0.15;
    private static final double EPS_OFF = 0.3;

    private IsInUtil() {
    }

    public static void mergePolygons(Set<Way> polygons, List<List<Coord>> outers, List<List<Coord>> holes) {
        Path2D.Double path = new Path2D.Double();
        for (Way polygon : polygons) {
            path.append(Java2DConverter.createPath2D(polygon.getPoints()), false);
        }
        java.awt.geom.Area polygonsArea = new java.awt.geom.Area(path);
        List<List<Coord>> mergedShapes = Java2DConverter.areaToShapes(polygonsArea);
        for (List<Coord> shape : mergedShapes) {
            (Way.clockwise(shape) ? outers : holes).add(shape);
        }
    }

    public static int isLineInShape(List<Coord> lineToTest, List<Coord> shape, Area elementBbox) {
        int n = lineToTest.size();
        int status = IsInUtil.isPointInShape(lineToTest.get(0), shape);
        BitSet onBoundary = new BitSet();
        for (int i = 0; i < shape.size() - 1; ++i) {
            Coord p12;
            Coord p11 = shape.get(i);
            if (p11.distanceInHighPrecSquared(p12 = shape.get(i + 1)) < 16L || Math.min(p11.getLatitude(), p12.getLatitude()) > elementBbox.getMaxLat() + 1 || Math.max(p11.getLatitude(), p12.getLatitude()) < elementBbox.getMinLat() - 1 || Math.min(p11.getLongitude(), p12.getLongitude()) > elementBbox.getMaxLong() + 1 || Math.max(p11.getLongitude(), p12.getLongitude()) < elementBbox.getMinLong() - 1) continue;
            for (int k = 0; k < n - 1; ++k) {
                Coord inter;
                Coord p22;
                Coord p21 = lineToTest.get(k);
                if (p21.distanceInHighPrecSquared(p22 = lineToTest.get(k + 1)) < 16L || (inter = Utils.getSegmentSegmentIntersection(p11, p12, p21, p22)) == null) continue;
                boolean isCrossing = false;
                if (inter.distanceInHighPrecSquared(p21) < 16L) {
                    onBoundary.set(k);
                    if (k == 0) {
                        status |= 2;
                    } else if (p21.distanceInHighPrecSquared(p11) < 16L) {
                        int testStat;
                        Coord p20 = lineToTest.get(k - 1);
                        Coord p10 = shape.get(i - 1 >= 0 ? i - 1 : shape.size() - 2);
                        IntersectionStatus x = IsInUtil.analyseCrossingInPoint(p11, p20, p22, p10, p12);
                        Coord pTest = null;
                        if (x == IntersectionStatus.CROSSING) {
                            isCrossing = true;
                        } else if (x == IntersectionStatus.JOINING) {
                            if (!IsInUtil.isOnOrCloseToEdgeOfShape(shape, p21, p20)) {
                                pTest = p21.destOnRhumbLine(0.3, p21.bearingTo(p20));
                            }
                        } else if (x == IntersectionStatus.SPLITTING && !IsInUtil.isOnOrCloseToEdgeOfShape(shape, p21, p22)) {
                            pTest = p21.destOnRhumbLine(0.3, p21.bearingTo(p22));
                        }
                        if (pTest != null && ((status |= (testStat = IsInUtil.isPointInShape(pTest, shape))) | 2) == 7) {
                            return 7;
                        }
                    } else if (p21.distanceInHighPrecSquared(p12) >= 16L) {
                        long isLeftPrev = lineToTest.get(k - 1).isLeft(p11, p12);
                        long isLeftNext = p22.isLeft(p11, p12);
                        if (isLeftPrev < 0L && isLeftNext > 0L || isLeftPrev > 0L && isLeftNext < 0L) {
                            isCrossing = true;
                        }
                    }
                } else if (inter.distanceInHighPrecSquared(p22) < 16L) {
                    onBoundary.set(k + 1);
                } else if (inter.distanceInHighPrecSquared(p11) < 16L || inter.distanceInHighPrecSquared(p12) < 16L) {
                    if (inter.distToLineSegment(p21, p22) > 0.15) {
                        isCrossing = true;
                    }
                } else {
                    isCrossing = true;
                }
                if (!isCrossing) continue;
                return 7;
            }
        }
        if (!onBoundary.isEmpty()) {
            status |= 2;
        }
        if (status == 2) {
            while (onBoundary.cardinality() != n) {
                int pos = onBoundary.nextClearBit(0);
                Coord pTest = lineToTest.get(pos);
                if ((status |= IsInUtil.isPointInShape(pTest, shape)) == 2) {
                    onBoundary.set(pos);
                    continue;
                }
                return status;
            }
            status |= IsInUtil.checkAllOn(lineToTest, shape);
        }
        return status;
    }

    private static int checkAllOn(List<Coord> lineToTest, List<Coord> shape) {
        int n = lineToTest.size();
        for (int i = 0; i < n - 1; ++i) {
            Coord pTest;
            int resMidPoint;
            Coord p2;
            Coord p1 = lineToTest.get(i);
            if (IsInUtil.isOnOrCloseToEdgeOfShape(shape, p1, p2 = lineToTest.get(i + 1)) || (resMidPoint = IsInUtil.isPointInShape(pTest = p1.destOnRhumbLine(0.3, p1.bearingTo(p2)), shape)) == 2) continue;
            return resMidPoint;
        }
        return 2;
    }

    private static IntersectionStatus analyseCrossingInPoint(Coord s, Coord a, Coord b, Coord x, Coord y) {
        TreeMap<Long, Character> map = new TreeMap<Long, Character>();
        long ba = Math.round(s.bearingTo(a) * 1000.0);
        long bb = Math.round(s.bearingTo(b) * 1000.0);
        long bx = Math.round(s.bearingTo(x) * 1000.0);
        long by = Math.round(s.bearingTo(y) * 1000.0);
        map.put(ba, Character.valueOf('a'));
        map.put(bb, Character.valueOf('b'));
        map.put(bx, Character.valueOf('x'));
        map.put(by, Character.valueOf('y'));
        ArrayList sortedByBearing = new ArrayList(map.values());
        int apos = sortedByBearing.indexOf(Character.valueOf('a'));
        int bpos = sortedByBearing.indexOf(Character.valueOf('b'));
        int xpos = sortedByBearing.indexOf(Character.valueOf('x'));
        int ypos = sortedByBearing.indexOf(Character.valueOf('y'));
        if (map.size() == 4) {
            if (Math.abs(xpos - ypos) == 2) {
                return IntersectionStatus.CROSSING;
            }
            return IntersectionStatus.TOUCHING;
        }
        if (map.size() == 3) {
            if (xpos < 0) {
                return IntersectionStatus.TOUCHING;
            }
            if (bpos < 0) {
                return IntersectionStatus.JOINING;
            }
            if (ba == bx || ba == by) {
                return IntersectionStatus.SPLITTING;
            }
            return IntersectionStatus.TOUCHING;
        }
        if (map.size() == 2) {
            if (apos > 0 || bpos > 0) {
                return IntersectionStatus.TOUCHING;
            }
            return IntersectionStatus.SIMILAR;
        }
        return IntersectionStatus.DOUBLE_SPIKE;
    }

    private static boolean isOnOrCloseToEdgeOfShape(List<Coord> shape, Coord p1, Coord p2) {
        for (int i = 0; i < shape.size(); ++i) {
            int posNext2;
            int posNext;
            Coord p = shape.get(i);
            if (p.distanceInHighPrecSquared(p1) >= 16L) continue;
            int posPrev = i > 0 ? i - 1 : shape.size() - 2;
            int n = posNext = i < shape.size() - 1 ? i + 1 : 1;
            if (shape.get(posPrev).distanceInHighPrecSquared(p2) < 16L || shape.get(posNext).distanceInHighPrecSquared(p2) < 16L) {
                return true;
            }
            int posPrev2 = posPrev > 0 ? posPrev - 1 : shape.size() - 2;
            int n2 = posNext2 = posNext < shape.size() - 1 ? posNext + 1 : 1;
            if (shape.get(posPrev2).distanceInHighPrecSquared(p2) < 16L && Math.abs(Utils.getAngle(p1, shape.get(posPrev), p2)) < 0.1) {
                return true;
            }
            if (shape.get(posNext2).distanceInHighPrecSquared(p2) >= 16L || !(Math.abs(Utils.getAngle(p1, shape.get(posNext), p2)) < 0.1)) continue;
            return true;
        }
        return false;
    }

    public static int isPointInShape(Coord node, List<Coord> shape) {
        int nodeLat = node.getHighPrecLat();
        int nodeLon = node.getHighPrecLon();
        if (log.isDebugEnabled()) {
            log.debug("node", node, nodeLon, nodeLat, shape.size(), shape);
        }
        int trailLat = 0;
        int trailLon = 0;
        int lhsCount = 0;
        int rhsCount = 0;
        boolean subsequent = false;
        for (Coord leadCoord : shape) {
            int leadLat = leadCoord.getHighPrecLat();
            int leadLon = leadCoord.getHighPrecLon();
            if (subsequent) {
                int maxLon;
                int minLon;
                int maxLat;
                int minLat;
                if (leadCoord.distanceInHighPrecSquared(node) < 16L) {
                    return 2;
                }
                if (leadLat < trailLat) {
                    minLat = leadLat;
                    maxLat = trailLat;
                } else {
                    minLat = trailLat;
                    maxLat = leadLat;
                }
                if (leadLon < trailLon) {
                    minLon = leadLon;
                    maxLon = trailLon;
                } else {
                    minLon = trailLon;
                    maxLon = leadLon;
                }
                if (minLat - 4 <= nodeLat && maxLat + 4 >= nodeLat) {
                    if (minLon - 4 > nodeLon && minLat < nodeLat && maxLat > nodeLat) {
                        ++rhsCount;
                    } else if (maxLon + 4 < nodeLon && minLat < nodeLat && maxLat > nodeLat) {
                        ++lhsCount;
                    } else {
                        double lonDif = leadLat == trailLat ? Double.POSITIVE_INFINITY : (double)(nodeLon - trailLon) - (double)(nodeLat - trailLat) / (double)(leadLat - trailLat) * (double)(leadLon - trailLon);
                        if (minLon - 4 <= nodeLon && maxLon + 4 >= nodeLon) {
                            double distSqrd;
                            double latDif = leadLon == trailLon ? Double.POSITIVE_INFINITY : (double)(nodeLat - trailLat) - (double)(nodeLon - trailLon) / (double)(leadLon - trailLon) * (double)(leadLat - trailLat);
                            log.debug("inBox", leadLon - nodeLon, leadLat - nodeLat, trailLon - nodeLon, trailLat - nodeLat, lonDif, latDif, lhsCount, rhsCount);
                            if (Double.isInfinite(lonDif)) {
                                distSqrd = latDif * latDif;
                            } else if (Double.isInfinite(latDif)) {
                                distSqrd = lonDif * lonDif;
                            } else {
                                if (Math.abs(lonDif) < 4.0 || Math.abs(latDif) < 4.0) {
                                    return 2;
                                }
                                distSqrd = lonDif * lonDif * latDif * latDif / (lonDif * lonDif + latDif * latDif);
                            }
                            if (distSqrd < 16.0) {
                                return 2;
                            }
                        } else {
                            log.debug("inSlice", leadLon - nodeLon, leadLat - nodeLat, trailLon - nodeLon, trailLat - nodeLat, lonDif, "N/A", lhsCount, rhsCount);
                        }
                        if (trailLat <= nodeLat && leadLat > nodeLat || trailLat > nodeLat && leadLat <= nodeLat) {
                            if (lonDif < 0.0) {
                                ++rhsCount;
                            } else {
                                ++lhsCount;
                            }
                        }
                    }
                }
            }
            subsequent = true;
            trailLat = leadLat;
            trailLon = leadLon;
        }
        log.debug("lhs | rhs", lhsCount, rhsCount);
        assert ((lhsCount & 1) == (rhsCount & 1)) : "LHS: " + lhsCount + " RHS: " + rhsCount;
        return (rhsCount & 1) == 1 ? 1 : 4;
    }

    private static enum IntersectionStatus {
        TOUCHING,
        CROSSING,
        SPLITTING,
        JOINING,
        SIMILAR,
        DOUBLE_SPIKE;

    }
}

