/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.eval;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValueWithUnit
implements Comparable<ValueWithUnit> {
    private static final Pattern EXTRACT_NUMBER_UNIT = Pattern.compile("[ \t]*(-?[0-9.]+)[ \t]*(.*)");
    private static final BigDecimal ZERO = new BigDecimal(0);
    private final BigDecimal value;
    private final String unit;
    private final boolean valid;

    public ValueWithUnit(String val) {
        Matcher m = EXTRACT_NUMBER_UNIT.matcher(val);
        boolean found = m.find();
        BigDecimal value = ZERO;
        String unit = "";
        boolean ok = false;
        if (found) {
            try {
                value = new BigDecimal(m.group(1));
                unit = m.group(2).trim();
                ok = true;
            }
            catch (NumberFormatException e) {
                ok = false;
            }
        }
        this.value = value;
        this.unit = unit;
        this.valid = ok;
    }

    @Override
    public int compareTo(ValueWithUnit o) {
        return this.value.compareTo(o.value);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return this.value + this.unit;
    }
}

