/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapShape;

public class RemoveObsoletePointsFilter
implements MapFilter {
    private static final Logger log = Logger.getLogger(RemoveObsoletePointsFilter.class);
    private boolean checkPreserved;

    @Override
    public void init(FilterConfig config) {
        this.checkPreserved = config.getLevel() == 0 && config.hasNet();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        List<Coord> newPoints;
        MapLine line;
        block22: {
            block21: {
                line = (MapLine)element;
                List<Coord> points = line.getPoints();
                int numPoints = points.size();
                if (numPoints <= 1) {
                    return;
                }
                int requiredPoints = line instanceof MapShape ? 4 : 2;
                newPoints = new ArrayList<Coord>(numPoints);
                while (true) {
                    boolean removedSpike = false;
                    numPoints = points.size();
                    Coord lastP = points.get(0);
                    newPoints.add(lastP);
                    block9: for (int i = 1; i < numPoints; ++i) {
                        Coord newP = points.get(i);
                        int last = newPoints.size() - 1;
                        lastP = (Coord)newPoints.get(last);
                        if (lastP.equals(newP)) {
                            if (!this.checkPreserved || !line.isRoad() || !newP.preserved()) continue;
                            if (!lastP.preserved()) {
                                newPoints.set(last, newP);
                                continue;
                            }
                        }
                        if (newPoints.size() > 1) {
                            switch (Utils.isStraight((Coord)newPoints.get(last - 1), lastP, newP)) {
                                case 2: {
                                    if (this.checkPreserved && lastP.preserved() && line.isRoad()) break;
                                    log.debug((Object)"found three consecutive points on strictly straight line");
                                    newPoints.set(last, newP);
                                    continue block9;
                                }
                                case 1: {
                                    if (!(line instanceof MapShape)) break;
                                    log.debug((Object)"removing spike");
                                    newPoints.remove(last);
                                    removedSpike = true;
                                    if (newPoints.get(last - 1).equals(newP)) continue block9;
                                }
                            }
                        }
                        newPoints.add(newP);
                    }
                    if (!removedSpike || newPoints.size() < requiredPoints) break;
                    points = newPoints;
                    newPoints = new ArrayList(points.size());
                }
                if (line instanceof MapShape) break block21;
                if (!this.checkPreserved && newPoints.size() > 2) {
                    int lenDup = 0;
                    while (((Coord)newPoints.get(lenDup)).equals(newPoints.get(newPoints.size() - 1 - lenDup)) && ++lenDup <= newPoints.size() - 1 - lenDup) {
                    }
                    if (lenDup > 1) {
                        newPoints = newPoints.subList(0, newPoints.size() + 1 - lenDup);
                    }
                }
                break block22;
            }
            while (newPoints.size() > 3) {
                int nPoints = newPoints.size();
                switch (Utils.isStraight((Coord)newPoints.get(newPoints.size() - 2), (Coord)newPoints.get(0), (Coord)newPoints.get(1))) {
                    case 1: {
                        log.debug((Object)"removing closing spike");
                        newPoints.remove(0);
                        newPoints.set(newPoints.size() - 1, newPoints.get(0));
                        if (!newPoints.get(newPoints.size() - 2).equals(newPoints.get(newPoints.size() - 1))) break;
                        newPoints.remove(newPoints.size() - 2);
                        break;
                    }
                    case 2: {
                        log.debug((Object)"removing straight line across closing");
                        newPoints.remove(newPoints.size() - 1);
                        newPoints.set(0, newPoints.get(newPoints.size() - 1));
                        break;
                    }
                }
                if (nPoints != newPoints.size()) continue;
            }
        }
        if (newPoints.size() == line.getPoints().size()) {
            next.doFilter(line);
            return;
        }
        if (line instanceof MapShape) {
            if (newPoints.size() <= 3) return;
        }
        if (newPoints.size() <= 1) {
            return;
        }
        MapLine newLine = line.copy();
        newLine.setPoints(newPoints);
        next.doFilter(newLine);
    }
}

