/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.srt.MultiSortKey;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr5
extends MdrMapSection {
    private ArrayList<Mdr5Record> allCities = new ArrayList();
    private ArrayList<Mdr5Record> cities;
    private int maxCityIndex;
    private int localCitySize;
    private int mdr20PointerSize = 0;
    private int[] mdr20s;

    public Mdr5(MdrConfig config) {
        this.setConfig(config);
    }

    public void addCity(Mdr5Record record) {
        assert (record.getMapIndex() != 0);
        this.allCities.add(record);
        if (record.getCityIndex() > this.maxCityIndex) {
            this.maxCityIndex = record.getCityIndex();
        }
    }

    @Override
    public void preWriteImpl() {
        this.allCities.trimToSize();
        this.localCitySize = Utils.numberToPointerSize(this.maxCityIndex + 1);
        Sort sort = this.getConfig().getSort();
        this.genCitiesAndMdr20s(sort);
        this.calcMdr20SortPos(sort);
        this.calcMdr21SortPos(sort);
        this.calcMdr22SortPos(sort);
    }

    private void genCitiesAndMdr20s(Sort sort) {
        ArrayList<SortKey<Mdr5Record>> sortKeys = new ArrayList<SortKey<Mdr5Record>>(this.allCities.size());
        HashMap<String, byte[]> regionCache = new HashMap<String, byte[]>();
        HashMap<String, byte[]> countryCache = new HashMap<String, byte[]>();
        for (Mdr5Record m : this.allCities) {
            if (m.getName() == null) continue;
            SortKey<Mdr5Record> sortKey = sort.createSortKey(m, m.getName());
            SortKey<Object> regionKey = sort.createSortKey(null, m.getRegionName(), 0, regionCache);
            SortKey<Object> countryKey = sort.createSortKey(null, m.getCountryName(), m.getMapIndex(), countryCache);
            sortKey = new MultiSortKey<Object>(sortKey, regionKey, countryKey);
            sortKeys.add(sortKey);
        }
        regionCache = null;
        countryCache = null;
        sortKeys.sort(null);
        this.cities = new ArrayList(sortKeys.size());
        Collator collator = sort.getCollator();
        int count = 0;
        Mdr5Record lastCity = null;
        this.mdr20s = new int[sortKeys.size() + 1];
        int mdr20count = 0;
        for (SortKey sortKey : sortKeys) {
            Mdr5Record c = (Mdr5Record)sortKey.getObject();
            c.setMdr20set(this.mdr20s);
            if (!c.isSameByName(collator, lastCity)) {
                ++mdr20count;
            }
            c.setMdr20Index(mdr20count);
            if (c.isSameByMapAndName(collator, lastCity)) {
                c.setGlobalCityIndex(count);
                continue;
            }
            c.setGlobalCityIndex(++count);
            this.cities.add(c);
            lastCity = c;
        }
    }

    private void calcMdr20SortPos(Sort sort) {
        ArrayList<SortKey<Mdr5Record>> sortKeys = new ArrayList<SortKey<Mdr5Record>>(this.allCities.size());
        HashMap<String, byte[]> regionCache = new HashMap<String, byte[]>();
        HashMap<String, byte[]> countryCache = new HashMap<String, byte[]>();
        for (Mdr5Record m : this.allCities) {
            if (m.getName() == null) continue;
            SortKey<Mdr5Record> sortKey = sort.createSortKey(m, m.getName());
            SortKey<Object> sortKey2 = sort.createSortKey(null, m.getRegionName(), 0, regionCache);
            SortKey<Object> countryKey = sort.createSortKey(null, m.getCountryName(), 0, countryCache);
            sortKey = new MultiSortKey<Object>(sortKey, sortKey2, countryKey);
            sortKeys.add(sortKey);
        }
        regionCache = null;
        countryCache = null;
        sortKeys.sort(null);
        SortKey lastKey = null;
        int pos = 0;
        for (SortKey sortKey : sortKeys) {
            Mdr5Record c = (Mdr5Record)sortKey.getObject();
            if (lastKey == null || sortKey.compareTo(lastKey) != 0) {
                ++pos;
            }
            c.setMdr20SortPos(pos);
            lastKey = sortKey;
        }
    }

    private void calcMdr21SortPos(Sort sort) {
        ArrayList<SortKey<Mdr5Record>> sortKeys = new ArrayList<SortKey<Mdr5Record>>(this.allCities.size());
        for (Mdr5Record m : this.allCities) {
            if (m.getRegionName() == null) continue;
            sortKeys.add(sort.createSortKey(m, m.getRegionName()));
        }
        sortKeys.sort(null);
        SortKey lastKey = null;
        int pos = 0;
        for (SortKey sortKey : sortKeys) {
            Mdr5Record c = (Mdr5Record)sortKey.getObject();
            if (lastKey == null || sortKey.compareTo(lastKey) != 0) {
                ++pos;
            }
            c.setMdr21SortPos(pos);
            lastKey = sortKey;
        }
    }

    private void calcMdr22SortPos(Sort sort) {
        ArrayList<SortKey<Mdr5Record>> sortKeys = new ArrayList<SortKey<Mdr5Record>>(this.allCities.size());
        for (Mdr5Record m : this.allCities) {
            if (m.getCountryName() == null) continue;
            SortKey<Mdr5Record> countryKey = sort.createSortKey(m, m.getCountryName());
            sortKeys.add(countryKey);
        }
        sortKeys.sort(null);
        SortKey lastKey = null;
        int pos = 0;
        for (SortKey sortKey : sortKeys) {
            Mdr5Record c = (Mdr5Record)sortKey.getObject();
            if (lastKey == null || sortKey.compareTo(lastKey) != 0) {
                ++pos;
            }
            c.setMdr22SortPos(pos);
            lastKey = sortKey;
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        Mdr5Record lastCity = null;
        boolean hasString = this.hasFlag(8);
        boolean hasRegion = this.hasFlag(4);
        Collator collator = this.getConfig().getSort().getCollator();
        for (Mdr5Record city : this.cities) {
            int gci = city.getGlobalCityIndex();
            this.addIndexPointer(city.getMapIndex(), gci);
            int flag = 0;
            int mapIndex = city.getMapIndex();
            int region = city.getRegionIndex();
            if (!city.isSameByName(collator, lastCity)) {
                flag = 0x800000;
                lastCity = city;
            }
            this.putMapIndex(writer, mapIndex);
            this.putLocalCityIndex(writer, city.getCityIndex());
            writer.put3u(flag | city.getLblOffset());
            if (hasRegion) {
                writer.put2u(region);
            }
            if (hasString) {
                this.putStringOffset(writer, city.getStringOffset());
            }
            if (this.mdr20PointerSize <= 0) continue;
            writer.putNu(this.mdr20PointerSize, city.getMdr20());
        }
    }

    private void putLocalCityIndex(ImgFileWriter writer, int cityIndex) {
        writer.putNu(this.localCitySize, cityIndex);
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        int size = sizes.getMapSize() + this.localCitySize + 3 + this.mdr20PointerSize;
        if (this.hasFlag(4)) {
            size += 2;
        }
        if (this.hasFlag(8)) {
            size += sizes.getStrOffSize();
        }
        return size;
    }

    @Override
    protected int numberOfItems() {
        return this.cities.size();
    }

    @Override
    public int getExtraValue() {
        int val = this.localCitySize - 1;
        if (this.isForDevice()) {
            if (!this.getConfig().getSort().isMulti()) {
                val |= 0x40;
            }
        } else {
            val |= 4;
            val |= 8;
        }
        val |= 0x10;
        if (this.getSizes().getNumberOfItems(20) > 0) {
            this.mdr20PointerSize = this.getSizes().getMdr20Size();
            val |= 0x100;
        }
        return val;
    }

    @Override
    protected void releaseMemory() {
        this.allCities = null;
        this.cities = null;
        this.mdr20s = null;
    }

    public List<Mdr5Record> getCities() {
        return Collections.unmodifiableList(this.allCities);
    }

    public List<Mdr5Record> getSortedCities() {
        return Collections.unmodifiableList(this.cities);
    }
}

