/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr14Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr28Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr29Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr26
extends MdrSection {
    private final List<Mdr28Record> index = new ArrayList<Mdr28Record>();

    public Mdr26(MdrConfig config) {
        this.setConfig(config);
    }

    public void sortMdr28(List<Mdr28Record> in) {
        Sort sort = this.getConfig().getSort();
        ArrayList<SortKey<Mdr28Record>> sortList = new ArrayList<SortKey<Mdr28Record>>();
        int record = 0;
        for (Mdr28Record mdr28 : in) {
            SortKey<Mdr28Record> key = sort.createSortKey(mdr28, mdr28.getMdr14().getName(), ++record);
            sortList.add(key);
        }
        sortList.sort(null);
        this.addToIndex(sortList);
    }

    private void addToIndex(List<SortKey<Mdr28Record>> sortList) {
        String lastName = null;
        int record26 = 0;
        for (SortKey<Mdr28Record> key : sortList) {
            ++record26;
            Mdr28Record mdr28 = key.getObject();
            Mdr14Record mdr14 = mdr28.getMdr14();
            assert (mdr14 != null);
            String name = mdr14.getName();
            if (!name.equals(lastName)) {
                Mdr29Record mdr29 = mdr14.getMdr29();
                mdr29.setMdr26(record26);
                lastName = name;
            }
            this.index.add(mdr28);
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int size = this.getSizes().getSize(28);
        for (Mdr28Record record : this.index) {
            writer.putNu(size, record.getIndex());
        }
    }

    @Override
    public int getItemSize() {
        return this.getSizes().getSize(28);
    }

    @Override
    protected int numberOfItems() {
        return this.index.size();
    }
}

