/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="A config file that needs to be created and made available as a volume in an service component container.")
@XmlRootElement
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ConfigFile
implements Serializable {
    private static final long serialVersionUID = -7009402089417704612L;
    private TypeEnum type = null;
    private String destFile = null;
    private String srcFile = null;
    private LocalResourceVisibility visibility = null;
    private Map<String, String> properties = new HashMap<String, String>();

    public ConfigFile copy() {
        ConfigFile copy = new ConfigFile();
        copy.setType(this.getType());
        copy.setSrcFile(this.getSrcFile());
        copy.setDestFile(this.getDestFile());
        copy.setVisibility(this.visibility);
        if (this.getProperties() != null && !this.getProperties().isEmpty()) {
            copy.getProperties().putAll(this.getProperties());
        }
        return copy;
    }

    public ConfigFile type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Config file in the standard format like xml, properties, json, yaml, template.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ConfigFile destFile(String destFile) {
        this.destFile = destFile;
        return this;
    }

    @ApiModelProperty(example="null", value="The absolute path that this configuration file should be mounted as, in the service container.")
    @JsonProperty(value="dest_file")
    public String getDestFile() {
        return this.destFile;
    }

    @XmlElement(name="dest_file")
    public void setDestFile(String destFile) {
        this.destFile = destFile;
    }

    public ConfigFile srcFile(String srcFile) {
        this.srcFile = srcFile;
        return this;
    }

    @ApiModelProperty(example="null", value="This provides the source location of the configuration file, the content of which is dumped to dest_file post property substitutions, in the format as specified in type. Typically the src_file would point to a source controlled network accessible file maintained by tools like puppet, chef, or hdfs etc. Currently, only hdfs is supported.")
    @JsonProperty(value="src_file")
    public String getSrcFile() {
        return this.srcFile;
    }

    @XmlElement(name="src_file")
    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public ConfigFile visibility(LocalResourceVisibility localrsrcVisibility) {
        this.visibility = localrsrcVisibility;
        return this;
    }

    @ApiModelProperty(example="null", value="Visibility of the Config file")
    @JsonProperty(value="visibility")
    public LocalResourceVisibility getVisibility() {
        return this.visibility;
    }

    @XmlElement(name="visibility", defaultValue="APPLICATION")
    public void setVisibility(LocalResourceVisibility localrsrcVisibility) {
        this.visibility = localrsrcVisibility;
    }

    public ConfigFile properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(example="null", value="A blob of key value pairs that will be dumped in the dest_file in the format as specified in type. If src_file is specified, src_file content are dumped in the dest_file and these properties will overwrite, if any, existing properties in src_file or be added as new properties in src_file.")
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public long getLong(String name, long defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        String value = this.properties.get(name.trim());
        return Long.parseLong(value);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        return Boolean.valueOf(this.properties.get(name.trim()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigFile configFile = (ConfigFile)o;
        return Objects.equals((Object)this.type, (Object)configFile.type) && Objects.equals(this.destFile, configFile.destFile) && Objects.equals(this.srcFile, configFile.srcFile) && Objects.equals(this.visibility, configFile.visibility) && Objects.equals(this.properties, configFile.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.destFile, this.srcFile, this.visibility, this.properties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfigFile {\n").append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n").append("    destFile: ").append(this.toIndentedString(this.destFile)).append("\n").append("    srcFile: ").append(this.toIndentedString(this.srcFile)).append("\n").append("    visibility: ").append(this.toIndentedString(this.visibility)).append("\n").append("    properties: ").append(this.toIndentedString(this.properties)).append("\n").append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @XmlType(name="config_type")
    @XmlEnum
    public static enum TypeEnum {
        XML("XML"),
        PROPERTIES("PROPERTIES"),
        JSON("JSON"),
        YAML("YAML"),
        TEMPLATE("TEMPLATE"),
        HADOOP_XML("HADOOP_XML"),
        STATIC("STATIC"),
        ARCHIVE("ARCHIVE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

