/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.azurebfs.enums.AbfsBackoffMetricsEnum;
import org.apache.hadoop.fs.azurebfs.enums.RetryValue;
import org.apache.hadoop.fs.azurebfs.enums.StatisticTypeEnum;
import org.apache.hadoop.fs.azurebfs.services.AbstractAbfsStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsBackoffMetrics
extends AbstractAbfsStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsBackoffMetrics.class);
    private static final List<RetryValue> RETRY_LIST = Arrays.asList(RetryValue.values());

    public AbfsBackoffMetrics() {
        IOStatisticsStore ioStatisticsStore = IOStatisticsBinding.iostatisticsStore().withCounters(this.getMetricNames(StatisticTypeEnum.TYPE_COUNTER)).withGauges(this.getMetricNames(StatisticTypeEnum.TYPE_GAUGE)).build();
        this.setIOStatistics(ioStatisticsStore);
    }

    private String[] getMetricNames(StatisticTypeEnum type) {
        return (String[])Arrays.stream(AbfsBackoffMetricsEnum.values()).filter(backoffMetricsEnum -> backoffMetricsEnum.getStatisticType().equals((Object)type)).flatMap(backoffMetricsEnum -> "RETRY".equals(backoffMetricsEnum.getType()) ? RETRY_LIST.stream().map(retryCount -> this.getMetricName((AbfsBackoffMetricsEnum)((Object)backoffMetricsEnum), (RetryValue)((Object)((Object)retryCount)))) : Stream.of(backoffMetricsEnum.getName())).toArray(String[]::new);
    }

    private String getMetricName(AbfsBackoffMetricsEnum metric, RetryValue retryValue) {
        if (metric == null) {
            LOG.error("ABFS Backoff Metric should not be null");
            return "";
        }
        if ("RETRY".equals(metric.getType()) && retryValue != null) {
            return retryValue.getValue() + ":" + metric.getName();
        }
        return metric.getName();
    }

    public long getMetricValue(AbfsBackoffMetricsEnum metric, RetryValue retryValue) {
        String metricName = this.getMetricName(metric, retryValue);
        switch (metric.getStatisticType()) {
            case TYPE_COUNTER: {
                return this.lookupCounterValue(metricName);
            }
            case TYPE_GAUGE: {
                return this.lookupGaugeValue(metricName);
            }
        }
        return 0L;
    }

    public long getMetricValue(AbfsBackoffMetricsEnum metric) {
        return this.getMetricValue(metric, null);
    }

    public void incrementMetricValue(AbfsBackoffMetricsEnum metric, RetryValue retryValue) {
        String metricName = this.getMetricName(metric, retryValue);
        switch (metric.getStatisticType()) {
            case TYPE_COUNTER: {
                this.incCounterValue(metricName);
                break;
            }
            case TYPE_GAUGE: {
                this.incGaugeValue(metricName);
                break;
            }
        }
    }

    public void incrementMetricValue(AbfsBackoffMetricsEnum metric) {
        this.incrementMetricValue(metric, null);
    }

    public void setMetricValue(AbfsBackoffMetricsEnum metric, long value, RetryValue retryValue) {
        String metricName = this.getMetricName(metric, retryValue);
        switch (metric.getStatisticType()) {
            case TYPE_COUNTER: {
                this.setCounterValue(metricName, value);
                break;
            }
            case TYPE_GAUGE: {
                this.setGaugeValue(metricName, value);
                break;
            }
        }
    }

    public void setMetricValue(AbfsBackoffMetricsEnum metric, long value) {
        this.setMetricValue(metric, value, null);
    }

    private String getPrecisionMetrics(AbfsBackoffMetricsEnum metricName, RetryValue retryCount, long denominator) {
        return StringUtils.format((String)"%.3f", (Object[])new Object[]{(double)this.getMetricValue(metricName, retryCount) / (double)denominator});
    }

    private void getRetryMetrics(StringBuilder metricBuilder) {
        for (RetryValue retryCount : RETRY_LIST) {
            long totalRequests = this.getMetricValue(AbfsBackoffMetricsEnum.TOTAL_REQUESTS, retryCount);
            metricBuilder.append("$RCTSI$_").append(retryCount.getValue()).append("R=").append(this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_SUCCEEDED, retryCount));
            if (totalRequests > 0L) {
                metricBuilder.append("$MMA$_").append(retryCount.getValue()).append("R=").append(this.getPrecisionMetrics(AbfsBackoffMetricsEnum.MIN_BACK_OFF, retryCount, 1000L)).append("s").append(this.getPrecisionMetrics(AbfsBackoffMetricsEnum.MAX_BACK_OFF, retryCount, 1000L)).append("s").append(this.getPrecisionMetrics(AbfsBackoffMetricsEnum.TOTAL_BACK_OFF, retryCount, totalRequests * 1000L)).append("s");
                continue;
            }
            metricBuilder.append("$MMA$_").append(retryCount.getValue()).append("R==0s");
        }
    }

    private void getBaseMetrics(StringBuilder metricBuilder) {
        long totalRequestsThrottled = this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_NETWORK_FAILED_REQUESTS) + this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_IOPS_THROTTLED_REQUESTS) + this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_OTHER_THROTTLED_REQUESTS) + this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_BANDWIDTH_THROTTLED_REQUESTS);
        metricBuilder.append("$BWT=").append(this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_BANDWIDTH_THROTTLED_REQUESTS)).append("$IT=").append(this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_IOPS_THROTTLED_REQUESTS)).append("$OT=").append(this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_OTHER_THROTTLED_REQUESTS)).append("$RT=").append(StringUtils.formatPercent((double)((double)totalRequestsThrottled / (double)this.getMetricValue(AbfsBackoffMetricsEnum.TOTAL_NUMBER_OF_REQUESTS)), (int)3)).append("$NFR=").append(this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_NETWORK_FAILED_REQUESTS)).append("$TRNR=").append(this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_SUCCEEDED_WITHOUT_RETRYING)).append("$TRF=").append(this.getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_FAILED)).append("$TR=").append(this.getMetricValue(AbfsBackoffMetricsEnum.TOTAL_NUMBER_OF_REQUESTS)).append("$MRC=").append(this.getMetricValue(AbfsBackoffMetricsEnum.MAX_RETRY_COUNT));
    }

    @Override
    public String toString() {
        if (this.getMetricValue(AbfsBackoffMetricsEnum.TOTAL_NUMBER_OF_REQUESTS) == 0L) {
            return "";
        }
        StringBuilder metricBuilder = new StringBuilder();
        this.getRetryMetrics(metricBuilder);
        this.getBaseMetrics(metricBuilder);
        return metricBuilder.toString();
    }

    @VisibleForTesting
    String[] getMetricNamesByType(StatisticTypeEnum type) {
        return this.getMetricNames(type);
    }
}

