/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import com.microsoft.azure.datalake.store.DirectoryEntry;
import com.microsoft.azure.datalake.store.DirectoryEntryType;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlPermission;
import org.apache.hadoop.fs.permission.FsPermission;

class AdlFileStatus
extends FileStatus {
    private static final long serialVersionUID = 33341022L;
    private boolean hasAcl = false;

    AdlFileStatus(DirectoryEntry entry, Path path, boolean hasAcl) {
        this(entry, path, entry.user, entry.group, hasAcl);
    }

    AdlFileStatus(DirectoryEntry entry, Path path, String owner, String group, boolean hasAcl) {
        super(entry.length, DirectoryEntryType.DIRECTORY == entry.type, 1, 0x10000000L, entry.lastModifiedTime.getTime(), entry.lastAccessTime.getTime(), (FsPermission)new AdlPermission(hasAcl, Short.parseShort(entry.permission, 8)), owner, group, null, path);
        this.hasAcl = hasAcl;
    }

    public boolean hasAcl() {
        return this.hasAcl;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

