/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.apache.hadoop.util.functional.TaskPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupJobStage
extends AbstractJobOrTaskStage<Arguments, Result> {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupJobStage.class);
    private final AtomicInteger deleteDirCount = new AtomicInteger();
    private final AtomicInteger deleteFailureCount = new AtomicInteger();
    private IOException lastDeleteException;
    private String stageName = "job_stage_cleanup";
    public static final Arguments DISABLED = new Arguments("job_stage_cleanup", false, false, false, false, 0L);

    public CleanupJobStage(StageConfig stageConfig) {
        super(false, stageConfig, "job_stage_cleanup", true);
    }

    @Override
    protected String getStageStatisticName(Arguments arguments) {
        return arguments.statisticName;
    }

    @Override
    protected Result executeStage(Arguments args) throws IOException {
        Result result;
        this.stageName = this.getStageName(args);
        Path baseDir = Objects.requireNonNull(this.getStageConfig().getOutputTempSubDir());
        LOG.debug("{}: Cleanup of directory {} with {}", new Object[]{this.getName(), baseDir, args});
        if (!args.enabled) {
            LOG.info("{}: Cleanup of {} disabled", (Object)this.getName(), (Object)baseDir);
            return new Result(Outcome.DISABLED, baseDir, 0, null);
        }
        if (this.getFileStatusOrNull(baseDir) == null) {
            return new Result(Outcome.NOTHING_TO_CLEAN_UP, baseDir, 0, null);
        }
        Outcome outcome = null;
        IOException exception = null;
        boolean baseDirDeleted = false;
        LOG.info("{}: Deleting job directory {}", (Object)this.getName(), (Object)baseDir);
        long directoryCount = args.directoryCount;
        if (directoryCount > 0L) {
            LOG.info("{}: Expected directory count: {}", (Object)this.getName(), (Object)directoryCount);
        }
        this.progress();
        if (args.deleteTaskAttemptDirsInParallel) {
            if (args.parallelDeleteAttemptBaseDeleteFirst) {
                try (DurationInfo info = new DurationInfo(LOG, true, "Initial delete of %s", baseDir);){
                    exception = this.deleteOneDir(baseDir);
                    if (exception == null) {
                        outcome = Outcome.DELETED;
                        baseDirDeleted = true;
                    } else {
                        LOG.warn("{}: Exception on initial attempt at deleting base dir {} with directory count {}. Falling back to parallel delete", new Object[]{this.getName(), baseDir, directoryCount, exception});
                    }
                }
            }
            if (!baseDirDeleted) {
                Path taskSubDir = this.getStageConfig().getJobAttemptTaskSubDir();
                try (DurationInfo info = new DurationInfo(LOG, true, "parallel deletion of task attempts in %s", taskSubDir);){
                    RemoteIterator<FileStatus> dirs = RemoteIterators.filteringRemoteIterator(this.listStatusIterator(taskSubDir), FileStatus::isDirectory);
                    TaskPool.foreach(dirs).executeWith(this.getIOProcessors()).stopOnFailure().suppressExceptions(false).run(this::rmTaskAttemptDir);
                    this.getIOStatistics().aggregate(IOStatisticsSupport.retrieveIOStatistics(dirs));
                    if (this.getLastDeleteException() != null) {
                        throw this.getLastDeleteException();
                    }
                    outcome = Outcome.PARALLEL_DELETE;
                }
                catch (FileNotFoundException ex) {
                    LOG.debug("{}: Task attempt dir {} not found", (Object)this.getName(), (Object)taskSubDir);
                    outcome = Outcome.DELETED;
                }
                catch (IOException ex) {
                    LOG.info("{}: Exception while listing/deleting task attempts under {}; continuing", new Object[]{this.getName(), taskSubDir, ex});
                }
            }
        }
        if (!baseDirDeleted) {
            exception = this.deleteOneDir(baseDir);
            if (exception != null) {
                LOG.warn("{}: Exception on final attempt at deleting base dir {} with directory count {}", new Object[]{this.getName(), baseDir, directoryCount, exception});
                outcome = Outcome.FAILURE;
            } else if (outcome == null) {
                outcome = Outcome.DELETED;
            }
        }
        if (!(result = new Result(outcome, baseDir, this.deleteDirCount.get(), exception)).succeeded() && !args.suppressExceptions) {
            result.maybeRethrowException();
        }
        return result;
    }

    private void rmTaskAttemptDir(FileStatus status) throws IOException {
        this.updateAuditContext(this.stageName);
        this.progress();
        this.deleteOneDir(status.getPath());
    }

    private IOException deleteOneDir(Path dir) throws IOException {
        this.deleteDirCount.incrementAndGet();
        return this.noteAnyDeleteFailure(this.deleteRecursiveSuppressingExceptions(dir, "op_delete_dir"));
    }

    private synchronized IOException noteAnyDeleteFailure(IOException ex) {
        if (ex != null) {
            this.deleteFailureCount.incrementAndGet();
            this.lastDeleteException = ex;
        }
        return ex;
    }

    public synchronized IOException getLastDeleteException() {
        return this.lastDeleteException;
    }

    public static Arguments cleanupStageOptionsFromConfig(String statisticName, Configuration conf) {
        boolean enabled = !conf.getBoolean("mapreduce.fileoutputcommitter.cleanup.skipped", false);
        boolean suppressExceptions = conf.getBoolean("mapreduce.fileoutputcommitter.cleanup-failures.ignored", false);
        boolean deleteTaskAttemptDirsInParallel = conf.getBoolean("mapreduce.manifest.committer.cleanup.parallel.delete", true);
        boolean parallelDeleteAttemptBaseDeleteFirst = conf.getBoolean("mapreduce.manifest.committer.cleanup.parallel.delete.base.first", false);
        return new Arguments(statisticName, enabled, deleteTaskAttemptDirsInParallel, parallelDeleteAttemptBaseDeleteFirst, suppressExceptions, 0L);
    }

    public static final class Result {
        private final Outcome outcome;
        private final Path directory;
        private final int deleteCalls;
        private final IOException exception;

        public Result(Outcome outcome, Path directory, int deleteCalls, IOException exception) {
            this.outcome = Objects.requireNonNull(outcome, "outcome");
            this.directory = directory;
            this.deleteCalls = deleteCalls;
            this.exception = exception;
            if (outcome == Outcome.FAILURE) {
                Objects.requireNonNull(exception, "No exception in failure result");
            }
        }

        public Path getDirectory() {
            return this.directory;
        }

        public boolean wasExecuted() {
            return this.outcome != Outcome.DISABLED;
        }

        public boolean succeeded() {
            return this.outcome.isSuccess();
        }

        public Outcome getOutcome() {
            return this.outcome;
        }

        public int getDeleteCalls() {
            return this.deleteCalls;
        }

        public IOException getException() {
            return this.exception;
        }

        public String maybeRethrowException() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.toString();
        }

        public String toString() {
            return "CleanupResult{outcome=" + (Object)((Object)this.outcome) + ", directory=" + this.directory + ", deleteCalls=" + this.deleteCalls + ", exception=" + this.exception + '}';
        }
    }

    public static enum Outcome {
        DISABLED("Disabled", false),
        NOTHING_TO_CLEAN_UP("Nothing to clean up", true),
        PARALLEL_DELETE("Parallel Delete of Task Attempt Directories", true),
        DELETED("Delete of job directory", true),
        FAILURE("Delete failed", false);

        private final String description;
        private final boolean success;

        private Outcome(String description, boolean success) {
            this.description = description;
            this.success = success;
        }

        public String toString() {
            return "Outcome{" + this.name() + " '" + this.description + '\'' + "}";
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }

    public static final class Arguments {
        private final String statisticName;
        private final boolean enabled;
        private final boolean deleteTaskAttemptDirsInParallel;
        private final boolean parallelDeleteAttemptBaseDeleteFirst;
        private final boolean suppressExceptions;
        private long directoryCount;

        public Arguments(String statisticName, boolean enabled, boolean deleteTaskAttemptDirsInParallel, boolean parallelDeleteAttemptBaseDeleteFirst, boolean suppressExceptions, long directoryCount) {
            this.statisticName = statisticName;
            this.enabled = enabled;
            this.deleteTaskAttemptDirsInParallel = deleteTaskAttemptDirsInParallel;
            this.suppressExceptions = suppressExceptions;
            this.parallelDeleteAttemptBaseDeleteFirst = parallelDeleteAttemptBaseDeleteFirst;
            this.directoryCount = directoryCount;
        }

        public String getStatisticName() {
            return this.statisticName;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDeleteTaskAttemptDirsInParallel() {
            return this.deleteTaskAttemptDirsInParallel;
        }

        public boolean isSuppressExceptions() {
            return this.suppressExceptions;
        }

        public boolean isParallelDeleteAttemptBaseDeleteFirst() {
            return this.parallelDeleteAttemptBaseDeleteFirst;
        }

        public long getDirectoryCount() {
            return this.directoryCount;
        }

        public void setDirectoryCount(long directoryCount) {
            this.directoryCount = directoryCount;
        }

        public String toString() {
            return "Arguments{statisticName='" + this.statisticName + '\'' + ", enabled=" + this.enabled + ", deleteTaskAttemptDirsInParallel=" + this.deleteTaskAttemptDirsInParallel + ", parallelDeleteAttemptBaseDeleteFirst=" + this.parallelDeleteAttemptBaseDeleteFirst + ", suppressExceptions=" + this.suppressExceptions + '}';
        }
    }
}

