/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.JsonSerializable;
import com.microsoft.azure.cosmosdb.PartitionKeyDefinitionVersion;
import com.microsoft.azure.cosmosdb.PartitionKind;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public final class PartitionKeyDefinition
extends JsonSerializable {
    private List<String> paths;
    private PartitionKind kind;
    private PartitionKeyDefinitionVersion version;

    public PartitionKeyDefinition() {
        this.setKind(PartitionKind.Hash);
    }

    public PartitionKeyDefinition(String jsonString) {
        super(jsonString);
    }

    public PartitionKind getKind() {
        if (this.kind == null) {
            this.kind = super.getObject("kind", PartitionKind.class);
        }
        return this.kind;
    }

    public void setKind(PartitionKind kind) {
        this.kind = kind;
    }

    public PartitionKeyDefinitionVersion getVersion() {
        if (this.version == null) {
            String versionStr;
            Object versionObject = super.getObject("version", Object.class);
            this.version = versionObject == null ? null : (StringUtils.isNumeric((CharSequence)(versionStr = String.valueOf(versionObject))) ? PartitionKeyDefinitionVersion.valueOf(String.format("V%d", Integer.parseInt(versionStr))) : (!Strings.isNullOrEmpty(versionStr) ? PartitionKeyDefinitionVersion.valueOf(WordUtils.capitalize((String)versionStr)) : null));
        }
        return this.version;
    }

    public void setVersion(PartitionKeyDefinitionVersion version) {
        this.version = version;
    }

    public List<String> getPaths() {
        if (this.paths == null) {
            this.paths = super.has("paths") ? super.getList("paths", String.class) : new ArrayList<String>();
        }
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        if (paths == null || paths.size() == 0) {
            throw new IllegalArgumentException("paths must not be null or empty.");
        }
        this.paths = paths;
    }

    @Override
    void populatePropertyBag() {
        if (this.kind != null) {
            super.set("kind", this.kind.name());
        }
        if (this.paths != null) {
            super.set("paths", this.paths);
        }
        if (this.version != null) {
            super.set("version", this.version.name());
        }
        super.populatePropertyBag();
    }
}

